from typing import List

# dependencies for the generated Python class
from ..std_msgs.pdu_pytype_Header import Header
from ..builtin_interfaces.pdu_pytype_Time import Time


# class definition for the ROS message
class Image:
    """
    ROS message: sensor_msgs/Image
    Generated by hakoniwa-ros2pdu.
    """

    header: Header
    height: int
    width: int
    encoding: str
    is_bigendian: int
    step: int
    data: List[int]

    def __init__(self):
        self.header = Header()
        self.height = 0
        self.width = 0
        self.encoding = ""
        self.is_bigendian = 0
        self.step = 0
        self.data = []

    def __str__(self):
        return f"Image(" + ", ".join([
            f"header={self.header}"
            f"height={self.height}"
            f"width={self.width}"
            f"encoding={self.encoding}"
            f"is_bigendian={self.is_bigendian}"
            f"step={self.step}"
            f"data={self.data}"
        ]) + ")"

    def __repr__(self):
        return self.__str__()

    def to_dict(self):
        """
        Convert the object to a dictionary.
        """
        d = {}
        # handle field 'header'
        field_val = self.header
        if isinstance(field_val, bytearray):
            d['header'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['header'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['header'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['header'] = field_val
        # handle field 'height'
        field_val = self.height
        if isinstance(field_val, bytearray):
            d['height'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['height'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['height'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['height'] = field_val
        # handle field 'width'
        field_val = self.width
        if isinstance(field_val, bytearray):
            d['width'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['width'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['width'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['width'] = field_val
        # handle field 'encoding'
        field_val = self.encoding
        if isinstance(field_val, bytearray):
            d['encoding'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['encoding'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['encoding'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['encoding'] = field_val
        # handle field 'is_bigendian'
        field_val = self.is_bigendian
        if isinstance(field_val, bytearray):
            d['is_bigendian'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['is_bigendian'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['is_bigendian'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['is_bigendian'] = field_val
        # handle field 'step'
        field_val = self.step
        if isinstance(field_val, bytearray):
            d['step'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['step'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['step'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['step'] = field_val
        # handle field 'data'
        field_val = self.data
        if isinstance(field_val, bytearray):
            d['data'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['data'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['data'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['data'] = field_val
        return d

    @classmethod
    def from_dict(cls, d: dict):
        """
        Create an object from a dictionary.
        """
        obj = cls()
        # handle field 'header'
        if 'header' in d:
            field_type = cls.__annotations__.get('header')
            value = d['header']
            
            if field_type is bytearray:
                obj.header = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.header = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.header = value
            elif hasattr(field_type, 'from_dict'):
                obj.header = field_type.from_dict(value)
            else:
                obj.header = value
        # handle field 'height'
        if 'height' in d:
            field_type = cls.__annotations__.get('height')
            value = d['height']
            
            if field_type is bytearray:
                obj.height = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.height = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.height = value
            elif hasattr(field_type, 'from_dict'):
                obj.height = field_type.from_dict(value)
            else:
                obj.height = value
        # handle field 'width'
        if 'width' in d:
            field_type = cls.__annotations__.get('width')
            value = d['width']
            
            if field_type is bytearray:
                obj.width = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.width = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.width = value
            elif hasattr(field_type, 'from_dict'):
                obj.width = field_type.from_dict(value)
            else:
                obj.width = value
        # handle field 'encoding'
        if 'encoding' in d:
            field_type = cls.__annotations__.get('encoding')
            value = d['encoding']
            
            if field_type is bytearray:
                obj.encoding = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.encoding = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.encoding = value
            elif hasattr(field_type, 'from_dict'):
                obj.encoding = field_type.from_dict(value)
            else:
                obj.encoding = value
        # handle field 'is_bigendian'
        if 'is_bigendian' in d:
            field_type = cls.__annotations__.get('is_bigendian')
            value = d['is_bigendian']
            
            if field_type is bytearray:
                obj.is_bigendian = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.is_bigendian = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.is_bigendian = value
            elif hasattr(field_type, 'from_dict'):
                obj.is_bigendian = field_type.from_dict(value)
            else:
                obj.is_bigendian = value
        # handle field 'step'
        if 'step' in d:
            field_type = cls.__annotations__.get('step')
            value = d['step']
            
            if field_type is bytearray:
                obj.step = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.step = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.step = value
            elif hasattr(field_type, 'from_dict'):
                obj.step = field_type.from_dict(value)
            else:
                obj.step = value
        # handle field 'data'
        if 'data' in d:
            field_type = cls.__annotations__.get('data')
            value = d['data']
            
            if field_type is bytearray:
                obj.data = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.data = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.data = value
            elif hasattr(field_type, 'from_dict'):
                obj.data = field_type.from_dict(value)
            else:
                obj.data = value
        return obj

    def to_json(self, indent=2):
        """
        Convert the object to a JSON string.
        """
        import json
        return json.dumps(self.to_dict(), indent=indent)

    @classmethod
    def from_json(cls, json_str: str):
        """
        Create an object from a JSON string.
        """
        import json
        return cls.from_dict(json.loads(json_str))
