from typing import List

# dependencies for the generated Python class
from ..std_msgs.pdu_pytype_Header import Header
from ..builtin_interfaces.pdu_pytype_Time import Time


# class definition for the ROS message
class LaserScan:
    """
    ROS message: sensor_msgs/LaserScan
    Generated by hakoniwa-ros2pdu.
    """

    header: Header
    angle_min: float
    angle_max: float
    angle_increment: float
    time_increment: float
    scan_time: float
    range_min: float
    range_max: float
    ranges: List[float]
    intensities: List[float]

    def __init__(self):
        self.header = Header()
        self.angle_min = 0.0
        self.angle_max = 0.0
        self.angle_increment = 0.0
        self.time_increment = 0.0
        self.scan_time = 0.0
        self.range_min = 0.0
        self.range_max = 0.0
        self.ranges = []
        self.intensities = []

    def __str__(self):
        return f"LaserScan(" + ", ".join([
            f"header={self.header}"
            f"angle_min={self.angle_min}"
            f"angle_max={self.angle_max}"
            f"angle_increment={self.angle_increment}"
            f"time_increment={self.time_increment}"
            f"scan_time={self.scan_time}"
            f"range_min={self.range_min}"
            f"range_max={self.range_max}"
            f"ranges={self.ranges}"
            f"intensities={self.intensities}"
        ]) + ")"

    def __repr__(self):
        return self.__str__()

    def to_dict(self):
        """
        Convert the object to a dictionary.
        """
        d = {}
        # handle field 'header'
        field_val = self.header
        if isinstance(field_val, bytearray):
            d['header'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['header'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['header'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['header'] = field_val
        # handle field 'angle_min'
        field_val = self.angle_min
        if isinstance(field_val, bytearray):
            d['angle_min'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['angle_min'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['angle_min'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['angle_min'] = field_val
        # handle field 'angle_max'
        field_val = self.angle_max
        if isinstance(field_val, bytearray):
            d['angle_max'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['angle_max'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['angle_max'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['angle_max'] = field_val
        # handle field 'angle_increment'
        field_val = self.angle_increment
        if isinstance(field_val, bytearray):
            d['angle_increment'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['angle_increment'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['angle_increment'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['angle_increment'] = field_val
        # handle field 'time_increment'
        field_val = self.time_increment
        if isinstance(field_val, bytearray):
            d['time_increment'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['time_increment'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['time_increment'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['time_increment'] = field_val
        # handle field 'scan_time'
        field_val = self.scan_time
        if isinstance(field_val, bytearray):
            d['scan_time'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['scan_time'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['scan_time'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['scan_time'] = field_val
        # handle field 'range_min'
        field_val = self.range_min
        if isinstance(field_val, bytearray):
            d['range_min'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['range_min'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['range_min'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['range_min'] = field_val
        # handle field 'range_max'
        field_val = self.range_max
        if isinstance(field_val, bytearray):
            d['range_max'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['range_max'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['range_max'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['range_max'] = field_val
        # handle field 'ranges'
        field_val = self.ranges
        if isinstance(field_val, bytearray):
            d['ranges'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['ranges'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['ranges'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['ranges'] = field_val
        # handle field 'intensities'
        field_val = self.intensities
        if isinstance(field_val, bytearray):
            d['intensities'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['intensities'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['intensities'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['intensities'] = field_val
        return d

    @classmethod
    def from_dict(cls, d: dict):
        """
        Create an object from a dictionary.
        """
        obj = cls()
        # handle field 'header'
        if 'header' in d:
            field_type = cls.__annotations__.get('header')
            value = d['header']
            
            if field_type is bytearray:
                obj.header = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.header = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.header = value
            elif hasattr(field_type, 'from_dict'):
                obj.header = field_type.from_dict(value)
            else:
                obj.header = value
        # handle field 'angle_min'
        if 'angle_min' in d:
            field_type = cls.__annotations__.get('angle_min')
            value = d['angle_min']
            
            if field_type is bytearray:
                obj.angle_min = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.angle_min = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.angle_min = value
            elif hasattr(field_type, 'from_dict'):
                obj.angle_min = field_type.from_dict(value)
            else:
                obj.angle_min = value
        # handle field 'angle_max'
        if 'angle_max' in d:
            field_type = cls.__annotations__.get('angle_max')
            value = d['angle_max']
            
            if field_type is bytearray:
                obj.angle_max = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.angle_max = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.angle_max = value
            elif hasattr(field_type, 'from_dict'):
                obj.angle_max = field_type.from_dict(value)
            else:
                obj.angle_max = value
        # handle field 'angle_increment'
        if 'angle_increment' in d:
            field_type = cls.__annotations__.get('angle_increment')
            value = d['angle_increment']
            
            if field_type is bytearray:
                obj.angle_increment = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.angle_increment = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.angle_increment = value
            elif hasattr(field_type, 'from_dict'):
                obj.angle_increment = field_type.from_dict(value)
            else:
                obj.angle_increment = value
        # handle field 'time_increment'
        if 'time_increment' in d:
            field_type = cls.__annotations__.get('time_increment')
            value = d['time_increment']
            
            if field_type is bytearray:
                obj.time_increment = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.time_increment = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.time_increment = value
            elif hasattr(field_type, 'from_dict'):
                obj.time_increment = field_type.from_dict(value)
            else:
                obj.time_increment = value
        # handle field 'scan_time'
        if 'scan_time' in d:
            field_type = cls.__annotations__.get('scan_time')
            value = d['scan_time']
            
            if field_type is bytearray:
                obj.scan_time = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.scan_time = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.scan_time = value
            elif hasattr(field_type, 'from_dict'):
                obj.scan_time = field_type.from_dict(value)
            else:
                obj.scan_time = value
        # handle field 'range_min'
        if 'range_min' in d:
            field_type = cls.__annotations__.get('range_min')
            value = d['range_min']
            
            if field_type is bytearray:
                obj.range_min = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.range_min = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.range_min = value
            elif hasattr(field_type, 'from_dict'):
                obj.range_min = field_type.from_dict(value)
            else:
                obj.range_min = value
        # handle field 'range_max'
        if 'range_max' in d:
            field_type = cls.__annotations__.get('range_max')
            value = d['range_max']
            
            if field_type is bytearray:
                obj.range_max = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.range_max = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.range_max = value
            elif hasattr(field_type, 'from_dict'):
                obj.range_max = field_type.from_dict(value)
            else:
                obj.range_max = value
        # handle field 'ranges'
        if 'ranges' in d:
            field_type = cls.__annotations__.get('ranges')
            value = d['ranges']
            
            if field_type is bytearray:
                obj.ranges = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.ranges = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.ranges = value
            elif hasattr(field_type, 'from_dict'):
                obj.ranges = field_type.from_dict(value)
            else:
                obj.ranges = value
        # handle field 'intensities'
        if 'intensities' in d:
            field_type = cls.__annotations__.get('intensities')
            value = d['intensities']
            
            if field_type is bytearray:
                obj.intensities = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.intensities = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.intensities = value
            elif hasattr(field_type, 'from_dict'):
                obj.intensities = field_type.from_dict(value)
            else:
                obj.intensities = value
        return obj

    def to_json(self, indent=2):
        """
        Convert the object to a JSON string.
        """
        import json
        return json.dumps(self.to_dict(), indent=indent)

    @classmethod
    def from_json(cls, json_str: str):
        """
        Create an object from a JSON string.
        """
        import json
        return cls.from_dict(json.loads(json_str))
