from typing import List

# dependencies for the generated Python class
from ..std_msgs.pdu_pytype_MultiArrayDimension import MultiArrayDimension


# class definition for the ROS message
class MultiArrayLayout:
    """
    ROS message: std_msgs/MultiArrayLayout
    Generated by hakoniwa-ros2pdu.
    """

    dim: List[MultiArrayDimension]
    data_offset: int

    def __init__(self):
        self.dim = []
        self.data_offset = 0

    def __str__(self):
        return f"MultiArrayLayout(" + ", ".join([
            f"dim={self.dim}"
            f"data_offset={self.data_offset}"
        ]) + ")"

    def __repr__(self):
        return self.__str__()

    def to_dict(self):
        """
        Convert the object to a dictionary.
        """
        d = {}
        # handle field 'dim'
        field_val = self.dim
        if isinstance(field_val, bytearray):
            d['dim'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['dim'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['dim'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['dim'] = field_val
        # handle field 'data_offset'
        field_val = self.data_offset
        if isinstance(field_val, bytearray):
            d['data_offset'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['data_offset'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['data_offset'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['data_offset'] = field_val
        return d

    @classmethod
    def from_dict(cls, d: dict):
        """
        Create an object from a dictionary.
        """
        obj = cls()
        # handle field 'dim'
        if 'dim' in d:
            field_type = cls.__annotations__.get('dim')
            value = d['dim']
            
            if field_type is bytearray:
                obj.dim = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.dim = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.dim = value
            elif hasattr(field_type, 'from_dict'):
                obj.dim = field_type.from_dict(value)
            else:
                obj.dim = value
        # handle field 'data_offset'
        if 'data_offset' in d:
            field_type = cls.__annotations__.get('data_offset')
            value = d['data_offset']
            
            if field_type is bytearray:
                obj.data_offset = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.data_offset = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.data_offset = value
            elif hasattr(field_type, 'from_dict'):
                obj.data_offset = field_type.from_dict(value)
            else:
                obj.data_offset = value
        return obj

    def to_json(self, indent=2):
        """
        Convert the object to a JSON string.
        """
        import json
        return json.dumps(self.to_dict(), indent=indent)

    @classmethod
    def from_json(cls, json_str: str):
        """
        Create an object from a JSON string.
        """
        import json
        return cls.from_dict(json.loads(json_str))
