# coding: utf-8

"""
    Pingera API

     The official API for Pingera, a monitoring and status page platform. This API allows you to manage checks, organizations, incidents, and more.   Some useful links: * [Pingera website](https://pingera.ru?utm_source=api_docs) * [API documentation](https://docs.pingera.ru/api/overview) * [Application](https://app.pingera.ru) * [Status page](https://status.pingera.ru) 

    The version of the OpenAPI document: v1
    Contact: privet@pingera.ru
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class Alert(BaseModel):
    """
    Alert
    """ # noqa: E501
    check_name: Optional[Any] = Field(default=None, description="The name of the monitor check that triggered this alert.")
    severity: Optional[StrictStr] = Field(default=None, description="The severity level of the alert.")
    status: Optional[StrictStr] = Field(default=None, description="The current status of the alert.")
    check_id: Optional[StrictStr] = Field(default=None, description="The identifier of the monitor check that triggered this alert.")
    rule_id: Optional[StrictStr] = Field(default=None, description="The identifier of the alert rule that triggered this alert.")
    title: Optional[StrictStr] = Field(default=None, description="A short, descriptive title for the alert.")
    acknowledged_by_id: Optional[StrictStr] = Field(default=None, description="The identifier of the user who acknowledged the alert. Null if not acknowledged.")
    is_active: Optional[Any] = Field(default=None, description="Whether the alert is currently active (firing or acknowledged).")
    notification_count: Optional[StrictInt] = Field(default=None, description="The number of notifications sent for this alert.")
    rule_name: Optional[Any] = Field(default=None, description="The name of the alert rule that triggered this alert.")
    description: Optional[StrictStr] = Field(default=None, description="A detailed description of the alert condition.")
    fired_at: Optional[datetime] = Field(default=None, description="The timestamp when the alert was first triggered in ISO format.")
    duration: Optional[Any] = Field(default=None, description="The duration of the alert in seconds. For active alerts, this is time since firing.")
    acknowledged_at: Optional[datetime] = Field(default=None, description="The timestamp when the alert was acknowledged in ISO format. Null if not acknowledged.")
    id: Optional[StrictStr] = Field(default=None, description="The unique identifier for the alert.")
    resolved_at: Optional[datetime] = Field(default=None, description="The timestamp when the alert was resolved in ISO format. Null if not resolved.")
    alert_metadata: Optional[Dict[str, Any]] = Field(default=None, description="Additional context and metadata about what triggered the alert.")
    last_notification_at: Optional[datetime] = Field(default=None, description="The timestamp when the last notification was sent in ISO format. Null if no notifications sent.")
    __properties: ClassVar[List[str]] = ["check_name", "severity", "status", "check_id", "rule_id", "title", "acknowledged_by_id", "is_active", "notification_count", "rule_name", "description", "fired_at", "duration", "acknowledged_at", "id", "resolved_at", "alert_metadata", "last_notification_at"]

    @field_validator('severity')
    def severity_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['low', 'medium', 'high', 'critical']):
            raise ValueError("must be one of enum values ('low', 'medium', 'high', 'critical')")
        return value

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['firing', 'resolved', 'acknowledged', 'suppressed']):
            raise ValueError("must be one of enum values ('firing', 'resolved', 'acknowledged', 'suppressed')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Alert from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "check_name",
            "severity",
            "status",
            "check_id",
            "rule_id",
            "title",
            "acknowledged_by_id",
            "is_active",
            "notification_count",
            "rule_name",
            "description",
            "fired_at",
            "duration",
            "acknowledged_at",
            "id",
            "resolved_at",
            "alert_metadata",
            "last_notification_at",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if check_name (nullable) is None
        # and model_fields_set contains the field
        if self.check_name is None and "check_name" in self.model_fields_set:
            _dict['check_name'] = None

        # set to None if acknowledged_by_id (nullable) is None
        # and model_fields_set contains the field
        if self.acknowledged_by_id is None and "acknowledged_by_id" in self.model_fields_set:
            _dict['acknowledged_by_id'] = None

        # set to None if is_active (nullable) is None
        # and model_fields_set contains the field
        if self.is_active is None and "is_active" in self.model_fields_set:
            _dict['is_active'] = None

        # set to None if rule_name (nullable) is None
        # and model_fields_set contains the field
        if self.rule_name is None and "rule_name" in self.model_fields_set:
            _dict['rule_name'] = None

        # set to None if duration (nullable) is None
        # and model_fields_set contains the field
        if self.duration is None and "duration" in self.model_fields_set:
            _dict['duration'] = None

        # set to None if acknowledged_at (nullable) is None
        # and model_fields_set contains the field
        if self.acknowledged_at is None and "acknowledged_at" in self.model_fields_set:
            _dict['acknowledged_at'] = None

        # set to None if resolved_at (nullable) is None
        # and model_fields_set contains the field
        if self.resolved_at is None and "resolved_at" in self.model_fields_set:
            _dict['resolved_at'] = None

        # set to None if last_notification_at (nullable) is None
        # and model_fields_set contains the field
        if self.last_notification_at is None and "last_notification_at" in self.model_fields_set:
            _dict['last_notification_at'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Alert from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "check_name": obj.get("check_name"),
            "severity": obj.get("severity"),
            "status": obj.get("status"),
            "check_id": obj.get("check_id"),
            "rule_id": obj.get("rule_id"),
            "title": obj.get("title"),
            "acknowledged_by_id": obj.get("acknowledged_by_id"),
            "is_active": obj.get("is_active"),
            "notification_count": obj.get("notification_count"),
            "rule_name": obj.get("rule_name"),
            "description": obj.get("description"),
            "fired_at": obj.get("fired_at"),
            "duration": obj.get("duration"),
            "acknowledged_at": obj.get("acknowledged_at"),
            "id": obj.get("id"),
            "resolved_at": obj.get("resolved_at"),
            "alert_metadata": obj.get("alert_metadata"),
            "last_notification_at": obj.get("last_notification_at")
        })
        return _obj


