# coding: utf-8

"""
    Pingera API

     The official API for Pingera, a monitoring and status page platform. This API allows you to manage checks, organizations, incidents, and more.   Some useful links: * [Pingera website](https://pingera.ru?utm_source=api_docs) * [API documentation](https://docs.pingera.ru/api/overview) * [Application](https://app.pingera.ru) * [Status page](https://status.pingera.ru) 

    The version of the OpenAPI document: v1
    Contact: privet@pingera.ru
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class AlertNotification(BaseModel):
    """
    AlertNotification
    """ # noqa: E501
    status: Optional[StrictStr] = Field(default=None, description="The delivery status of the notification.")
    channel_type: Optional[StrictStr] = Field(default=None, description="The type of the alert channel used for this notification.")
    created_at: Optional[datetime] = Field(default=None, description="The timestamp when the notification was created in ISO format.")
    error_message: Optional[StrictStr] = Field(default=None, description="Error message if the notification failed to send. Null if successful.")
    channel_id: Optional[StrictStr] = Field(default=None, description="The identifier of the alert channel used for this notification.")
    channel_name: Optional[Any] = Field(default=None, description="The name of the alert channel used for this notification.")
    alert_id: Optional[StrictStr] = Field(default=None, description="The identifier of the alert this notification belongs to.")
    retry_count: Optional[StrictInt] = Field(default=None, description="The number of retry attempts for this notification.")
    id: Optional[StrictStr] = Field(default=None, description="The unique identifier for the alert notification.")
    sent_at: Optional[datetime] = Field(default=None, description="The timestamp when the notification was successfully sent in ISO format. Null if not sent.")
    notification_type: Optional[StrictStr] = Field(default=None, description="The type of notification sent.")
    __properties: ClassVar[List[str]] = ["status", "channel_type", "created_at", "error_message", "channel_id", "channel_name", "alert_id", "retry_count", "id", "sent_at", "notification_type"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['pending', 'sent', 'failed', 'retrying']):
            raise ValueError("must be one of enum values ('pending', 'sent', 'failed', 'retrying')")
        return value

    @field_validator('channel_type')
    def channel_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['email', 'webhook', 'statuspage', 'telegram']):
            raise ValueError("must be one of enum values ('email', 'webhook', 'statuspage', 'telegram')")
        return value

    @field_validator('notification_type')
    def notification_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['alert_fired', 'alert_resolved', 'alert_acknowledged']):
            raise ValueError("must be one of enum values ('alert_fired', 'alert_resolved', 'alert_acknowledged')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AlertNotification from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "status",
            "channel_type",
            "created_at",
            "error_message",
            "channel_id",
            "channel_name",
            "alert_id",
            "retry_count",
            "id",
            "sent_at",
            "notification_type",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if error_message (nullable) is None
        # and model_fields_set contains the field
        if self.error_message is None and "error_message" in self.model_fields_set:
            _dict['error_message'] = None

        # set to None if channel_name (nullable) is None
        # and model_fields_set contains the field
        if self.channel_name is None and "channel_name" in self.model_fields_set:
            _dict['channel_name'] = None

        # set to None if sent_at (nullable) is None
        # and model_fields_set contains the field
        if self.sent_at is None and "sent_at" in self.model_fields_set:
            _dict['sent_at'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AlertNotification from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "status": obj.get("status"),
            "channel_type": obj.get("channel_type"),
            "created_at": obj.get("created_at"),
            "error_message": obj.get("error_message"),
            "channel_id": obj.get("channel_id"),
            "channel_name": obj.get("channel_name"),
            "alert_id": obj.get("alert_id"),
            "retry_count": obj.get("retry_count"),
            "id": obj.get("id"),
            "sent_at": obj.get("sent_at"),
            "notification_type": obj.get("notification_type")
        })
        return _obj


