# coding: utf-8

"""
    Pingera API

     The official API for Pingera, a monitoring and status page platform. This API allows you to manage checks, organizations, incidents, and more.   Some useful links: * [Pingera website](https://pingera.ru?utm_source=api_docs) * [API documentation](https://docs.pingera.ru/api/overview) * [Application](https://app.pingera.ru) * [Status page](https://status.pingera.ru) 

    The version of the OpenAPI document: v1
    Contact: privet@pingera.ru
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from pingera.models.alert_channel import AlertChannel
from typing import Optional, Set
from typing_extensions import Self

class AlertRule(BaseModel):
    """
    AlertRule
    """ # noqa: E501
    condition: StrictStr = Field(description="The condition that triggers this alert rule.")
    check_name: Optional[Any] = Field(default=None, description="The name of the monitor check this rule applies to.")
    severity: Optional[StrictStr] = Field(default=None, description="The severity level of alerts generated by this rule.")
    check_id: StrictStr = Field(description="The identifier of the monitor check this rule applies to.")
    channels: Optional[List[AlertChannel]] = Field(default=None, description="List of alert channels configured for this rule.")
    channel_ids: Annotated[List[StrictStr], Field(min_length=1)] = Field(description="List of alert channel IDs to send notifications to.")
    created_at: Optional[datetime] = Field(default=None, description="The timestamp when the alert rule was created in ISO format.")
    auto_resolve: Optional[StrictBool] = Field(default=True, description="Whether alerts should automatically resolve when the check recovers. Defaults to true.")
    updated_at: Optional[datetime] = Field(default=None, description="The timestamp when the alert rule was last updated in ISO format.")
    cooldown_period: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=300, description="Time in seconds to wait before triggering another alert. Defaults to 300.")
    name: Annotated[str, Field(min_length=1, strict=True, max_length=100)] = Field(description="A user-friendly name for the alert rule. Max 100 characters.")
    id: Optional[StrictStr] = Field(default=None, description="The unique identifier for the alert rule.")
    condition_parameters: Optional[Dict[str, Any]] = Field(default=None, description="Parameters specific to the trigger condition. Required for some conditions.")
    enabled: Optional[StrictBool] = Field(default=True, description="Whether the alert rule is enabled. Defaults to true.")
    __properties: ClassVar[List[str]] = ["condition", "check_name", "severity", "check_id", "channels", "channel_ids", "created_at", "auto_resolve", "updated_at", "cooldown_period", "name", "id", "condition_parameters", "enabled"]

    @field_validator('condition')
    def condition_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['check_failed', 'check_timeout', 'check_degraded', 'consecutive_failures', 'uptime_below_threshold']):
            raise ValueError("must be one of enum values ('check_failed', 'check_timeout', 'check_degraded', 'consecutive_failures', 'uptime_below_threshold')")
        return value

    @field_validator('severity')
    def severity_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['low', 'medium', 'high', 'critical']):
            raise ValueError("must be one of enum values ('low', 'medium', 'high', 'critical')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AlertRule from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "check_name",
            "channels",
            "created_at",
            "updated_at",
            "id",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in channels (list)
        _items = []
        if self.channels:
            for _item_channels in self.channels:
                if _item_channels:
                    _items.append(_item_channels.to_dict())
            _dict['channels'] = _items
        # set to None if check_name (nullable) is None
        # and model_fields_set contains the field
        if self.check_name is None and "check_name" in self.model_fields_set:
            _dict['check_name'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AlertRule from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "condition": obj.get("condition"),
            "check_name": obj.get("check_name"),
            "severity": obj.get("severity"),
            "check_id": obj.get("check_id"),
            "channels": [AlertChannel.from_dict(_item) for _item in obj["channels"]] if obj.get("channels") is not None else None,
            "channel_ids": obj.get("channel_ids"),
            "created_at": obj.get("created_at"),
            "auto_resolve": obj.get("auto_resolve") if obj.get("auto_resolve") is not None else True,
            "updated_at": obj.get("updated_at"),
            "cooldown_period": obj.get("cooldown_period") if obj.get("cooldown_period") is not None else 300,
            "name": obj.get("name"),
            "id": obj.get("id"),
            "condition_parameters": obj.get("condition_parameters"),
            "enabled": obj.get("enabled") if obj.get("enabled") is not None else True
        })
        return _obj


