# coding: utf-8

"""
    Pingera API

     The official API for Pingera, a monitoring and status page platform. This API allows you to manage checks, organizations, incidents, and more.   Some useful links: * [Pingera website](https://pingera.ru?utm_source=api_docs) * [API documentation](https://docs.pingera.ru/api/overview) * [Application](https://app.pingera.ru) * [Status page](https://status.pingera.ru) 

    The version of the OpenAPI document: v1
    Contact: privet@pingera.ru
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CheckJob(BaseModel):
    """
    CheckJob
    """ # noqa: E501
    status: Optional[StrictStr] = Field(default=None, description="The current status of the check job execution.")
    check_id: Optional[StrictStr] = Field(default=None, description="The identifier of the monitor check this job belongs to.")
    job_type: Optional[Any] = Field(default=None, description="The type of check job being executed.")
    result: Optional[Any] = Field(default=None, description="The result data from the completed check job, including server information.")
    check_parameters: Optional[Dict[str, Any]] = Field(default=None, description="The parameters used for executing this check job.")
    error_message: Optional[StrictStr] = Field(default=None, description="Error message if the job execution failed.")
    created_at: Optional[datetime] = Field(default=None, description="The timestamp when the check job was created in ISO format.")
    started_at: Optional[datetime] = Field(default=None, description="The timestamp when the check job started execution in ISO format.")
    completed_at: Optional[datetime] = Field(default=None, description="The timestamp when the check job completed execution in ISO format.")
    id: Optional[StrictStr] = Field(default=None, description="The unique identifier for the check job.")
    __properties: ClassVar[List[str]] = ["status", "check_id", "job_type", "result", "check_parameters", "error_message", "created_at", "started_at", "completed_at", "id"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['pending', 'running', 'completed', 'failed']):
            raise ValueError("must be one of enum values ('pending', 'running', 'completed', 'failed')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CheckJob from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "status",
            "check_id",
            "job_type",
            "result",
            "check_parameters",
            "error_message",
            "created_at",
            "started_at",
            "completed_at",
            "id",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if job_type (nullable) is None
        # and model_fields_set contains the field
        if self.job_type is None and "job_type" in self.model_fields_set:
            _dict['job_type'] = None

        # set to None if result (nullable) is None
        # and model_fields_set contains the field
        if self.result is None and "result" in self.model_fields_set:
            _dict['result'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CheckJob from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "status": obj.get("status"),
            "check_id": obj.get("check_id"),
            "job_type": obj.get("job_type"),
            "result": obj.get("result"),
            "check_parameters": obj.get("check_parameters"),
            "error_message": obj.get("error_message"),
            "created_at": obj.get("created_at"),
            "started_at": obj.get("started_at"),
            "completed_at": obj.get("completed_at"),
            "id": obj.get("id")
        })
        return _obj


