# coding: utf-8

"""
    Pingera API

     The official API for Pingera, a monitoring and status page platform. This API allows you to manage checks, organizations, incidents, and more.   Some useful links: * [Pingera website](https://pingera.ru?utm_source=api_docs) * [API documentation](https://docs.pingera.ru/api/overview) * [Application](https://app.pingera.ru) * [Status page](https://status.pingera.ru) 

    The version of the OpenAPI document: v1
    Contact: privet@pingera.ru
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class Component1(BaseModel):
    """
    Component1
    """ # noqa: E501
    status: Optional[StrictStr] = Field(default=None, description="Current operational status of the component")
    start_date: Optional[datetime] = Field(default=None, description="Date when monitoring for this component started")
    group: Optional[StrictBool] = Field(default=False, description="Whether this component is a group container for other components")
    created_at: Optional[datetime] = Field(default=None, description="Timestamp when the component was created")
    updated_at: Optional[datetime] = Field(default=None, description="Timestamp when the component was last updated")
    group_id: Optional[StrictStr] = Field(default=None, description="ID of the group this component belongs to (if any)")
    showcase: Optional[StrictBool] = Field(default=None, description="Whether to prominently display this component on the status page")
    description: Optional[StrictStr] = Field(default=None, description="Detailed description of the component")
    only_show_if_degraded: Optional[StrictBool] = Field(default=None, description="Whether to show this component only when it's not operational")
    name: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=100)]] = Field(default=None, description="Display name of the component")
    id: Optional[StrictStr] = Field(default=None, description="Unique identifier for the component")
    page_id: Optional[StrictStr] = Field(default=None, description="ID of the status page this component belongs to")
    position: Optional[StrictInt] = Field(default=None, description="Display order position of the component on the status page")
    __properties: ClassVar[List[str]] = ["status", "start_date", "group", "created_at", "updated_at", "group_id", "showcase", "description", "only_show_if_degraded", "name", "id", "page_id", "position"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['operational', 'under_maintenance', 'degraded_performance', 'partial_outage', 'major_outage']):
            raise ValueError("must be one of enum values ('operational', 'under_maintenance', 'degraded_performance', 'partial_outage', 'major_outage')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Component1 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "created_at",
            "updated_at",
            "id",
            "page_id",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if group_id (nullable) is None
        # and model_fields_set contains the field
        if self.group_id is None and "group_id" in self.model_fields_set:
            _dict['group_id'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if position (nullable) is None
        # and model_fields_set contains the field
        if self.position is None and "position" in self.model_fields_set:
            _dict['position'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Component1 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "status": obj.get("status"),
            "start_date": obj.get("start_date"),
            "group": obj.get("group") if obj.get("group") is not None else False,
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "group_id": obj.get("group_id"),
            "showcase": obj.get("showcase"),
            "description": obj.get("description"),
            "only_show_if_degraded": obj.get("only_show_if_degraded"),
            "name": obj.get("name"),
            "id": obj.get("id"),
            "page_id": obj.get("page_id"),
            "position": obj.get("position")
        })
        return _obj


