# coding: utf-8

"""
    Pingera API

     The official API for Pingera, a monitoring and status page platform. This API allows you to manage checks, organizations, incidents, and more.   Some useful links: * [Pingera website](https://pingera.ru?utm_source=api_docs) * [API documentation](https://docs.pingera.ru/api/overview) * [Application](https://app.pingera.ru) * [Status page](https://status.pingera.ru) 

    The version of the OpenAPI document: v1
    Contact: privet@pingera.ru
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class Incident(BaseModel):
    """
    Incident
    """ # noqa: E501
    reminder_intervals: Optional[StrictStr] = Field(default=None, description="The intervals at which to send reminder notifications for scheduled maintenance.")
    status: StrictStr = Field(description="The current status of the incident.")
    scheduled_until: Optional[datetime] = Field(default=None, description="For scheduled maintenance, the timestamp when maintenance is scheduled to end.")
    auto_transition_to_operational_state: Optional[StrictBool] = Field(default=None, description="Whether to automatically transition components back to operational state after scheduled maintenance.")
    scheduled_auto_completed: Optional[StrictBool] = Field(default=None, description="Whether the scheduled maintenance should automatically be marked as completed.")
    metadata: Optional[Dict[str, Any]] = Field(default=None, description="Additional metadata associated with the incident.")
    postmortem_published_at: Optional[Any] = Field(default=None, description="The timestamp when the postmortem was published.")
    scheduled_remind_prior: Optional[StrictBool] = Field(default=None, description="Whether to send reminder notifications before scheduled maintenance begins.")
    scheduled_reminded_at: Optional[datetime] = Field(default=None, description="The timestamp when reminder notifications were sent for scheduled maintenance.")
    impact: Optional[StrictStr] = Field(default=None, description="The impact level of the incident.")
    scheduled_for: Optional[datetime] = Field(default=None, description="For scheduled maintenance, the timestamp when maintenance is scheduled to start.")
    body: Optional[StrictStr] = Field(default=None, description="The main description/body content of the incident.")
    postmortem_body_last_updated_at: Optional[Any] = Field(default=None, description="The timestamp when the postmortem body was last updated.")
    resolved_at: Optional[Any] = Field(default=None, description="The timestamp when the incident was resolved, derived from the latest update with 'resolved' status.")
    incident_updates: Optional[Any] = Field(default=None, description="List of all updates posted for this incident, sorted by creation time (newest first).")
    created_at: Optional[datetime] = Field(default=None, description="The timestamp when the incident was created in ISO format.")
    updated_at: Optional[datetime] = Field(default=None, description="The timestamp when the incident was last updated in ISO format.")
    auto_transition_deliver_notifications_at_end: Optional[StrictBool] = Field(default=None, description="Whether to deliver notifications when auto-transitioning at the end of scheduled maintenance.")
    monitoring_at: Optional[datetime] = Field(default=None, description="The timestamp when the incident status was changed to monitoring.")
    auto_transition_to_maintenance_state: Optional[StrictBool] = Field(default=None, description="Whether to automatically transition components to maintenance state during scheduled maintenance.")
    id: Optional[StrictStr] = Field(default=None, description="The unique identifier for the incident.")
    page_id: Optional[StrictStr] = Field(default=None, description="The unique identifier of the status page this incident belongs to.")
    postmortem_body: Optional[Any] = Field(default=None, description="The content of the incident postmortem, if published.")
    deliver_notifications: Optional[StrictBool] = Field(default=None, description="Whether to send notifications when creating or updating this incident.")
    components: Optional[Any] = Field(default=None, description="List of components affected by this incident with their current status.")
    scheduled_auto_in_progress: Optional[StrictBool] = Field(default=None, description="Whether the scheduled maintenance should automatically be marked as in progress.")
    name: Annotated[str, Field(min_length=1, strict=True, max_length=200)] = Field(description="The name/title of the incident. Must be between 1 and 200 characters.")
    auto_transition_deliver_notifications_at_start: Optional[StrictBool] = Field(default=None, description="Whether to deliver notifications when auto-transitioning at the start of scheduled maintenance.")
    __properties: ClassVar[List[str]] = ["reminder_intervals", "status", "scheduled_until", "auto_transition_to_operational_state", "scheduled_auto_completed", "metadata", "postmortem_published_at", "scheduled_remind_prior", "scheduled_reminded_at", "impact", "scheduled_for", "body", "postmortem_body_last_updated_at", "resolved_at", "incident_updates", "created_at", "updated_at", "auto_transition_deliver_notifications_at_end", "monitoring_at", "auto_transition_to_maintenance_state", "id", "page_id", "postmortem_body", "deliver_notifications", "components", "scheduled_auto_in_progress", "name", "auto_transition_deliver_notifications_at_start"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['investigating', 'identified', 'monitoring', 'resolved']):
            raise ValueError("must be one of enum values ('investigating', 'identified', 'monitoring', 'resolved')")
        return value

    @field_validator('impact')
    def impact_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['minor', 'major', 'critical']):
            raise ValueError("must be one of enum values ('minor', 'major', 'critical')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Incident from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "postmortem_published_at",
            "postmortem_body_last_updated_at",
            "resolved_at",
            "incident_updates",
            "created_at",
            "updated_at",
            "id",
            "page_id",
            "postmortem_body",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if postmortem_published_at (nullable) is None
        # and model_fields_set contains the field
        if self.postmortem_published_at is None and "postmortem_published_at" in self.model_fields_set:
            _dict['postmortem_published_at'] = None

        # set to None if postmortem_body_last_updated_at (nullable) is None
        # and model_fields_set contains the field
        if self.postmortem_body_last_updated_at is None and "postmortem_body_last_updated_at" in self.model_fields_set:
            _dict['postmortem_body_last_updated_at'] = None

        # set to None if resolved_at (nullable) is None
        # and model_fields_set contains the field
        if self.resolved_at is None and "resolved_at" in self.model_fields_set:
            _dict['resolved_at'] = None

        # set to None if incident_updates (nullable) is None
        # and model_fields_set contains the field
        if self.incident_updates is None and "incident_updates" in self.model_fields_set:
            _dict['incident_updates'] = None

        # set to None if postmortem_body (nullable) is None
        # and model_fields_set contains the field
        if self.postmortem_body is None and "postmortem_body" in self.model_fields_set:
            _dict['postmortem_body'] = None

        # set to None if components (nullable) is None
        # and model_fields_set contains the field
        if self.components is None and "components" in self.model_fields_set:
            _dict['components'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Incident from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "reminder_intervals": obj.get("reminder_intervals"),
            "status": obj.get("status"),
            "scheduled_until": obj.get("scheduled_until"),
            "auto_transition_to_operational_state": obj.get("auto_transition_to_operational_state"),
            "scheduled_auto_completed": obj.get("scheduled_auto_completed"),
            "metadata": obj.get("metadata"),
            "postmortem_published_at": obj.get("postmortem_published_at"),
            "scheduled_remind_prior": obj.get("scheduled_remind_prior"),
            "scheduled_reminded_at": obj.get("scheduled_reminded_at"),
            "impact": obj.get("impact"),
            "scheduled_for": obj.get("scheduled_for"),
            "body": obj.get("body"),
            "postmortem_body_last_updated_at": obj.get("postmortem_body_last_updated_at"),
            "resolved_at": obj.get("resolved_at"),
            "incident_updates": obj.get("incident_updates"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "auto_transition_deliver_notifications_at_end": obj.get("auto_transition_deliver_notifications_at_end"),
            "monitoring_at": obj.get("monitoring_at"),
            "auto_transition_to_maintenance_state": obj.get("auto_transition_to_maintenance_state"),
            "id": obj.get("id"),
            "page_id": obj.get("page_id"),
            "postmortem_body": obj.get("postmortem_body"),
            "deliver_notifications": obj.get("deliver_notifications"),
            "components": obj.get("components"),
            "scheduled_auto_in_progress": obj.get("scheduled_auto_in_progress"),
            "name": obj.get("name"),
            "auto_transition_deliver_notifications_at_start": obj.get("auto_transition_deliver_notifications_at_start")
        })
        return _obj


