# coding: utf-8

"""
    Pingera API

     The official API for Pingera, a monitoring and status page platform. This API allows you to manage checks, organizations, incidents, and more.   Some useful links: * [Pingera website](https://pingera.ru?utm_source=api_docs) * [API documentation](https://docs.pingera.ru/api/overview) * [Application](https://app.pingera.ru) * [Status page](https://status.pingera.ru) 

    The version of the OpenAPI document: v1
    Contact: privet@pingera.ru
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class IncidentUpdate(BaseModel):
    """
    IncidentUpdate
    """ # noqa: E501
    status: Optional[StrictStr] = Field(default=None, description="The status of the incident update.")
    created_at: Optional[datetime] = Field(default=None, description="The timestamp when the incident update was created.")
    updated_at: Optional[datetime] = Field(default=None, description="The timestamp when the incident update was last updated.")
    body: Optional[StrictStr] = Field(default=None, description="The content of the incident update.")
    deliver_notifications: Optional[StrictBool] = Field(default=True, description="Whether to send notifications for this update.")
    incident_id: Optional[StrictStr] = Field(default=None, description="The ID of the incident this update belongs to.")
    components: Optional[Any] = Field(default=None, description="Components affected by this incident update.")
    id: Optional[StrictStr] = Field(default=None, description="The unique identifier for the incident update.")
    __properties: ClassVar[List[str]] = ["status", "created_at", "updated_at", "body", "deliver_notifications", "incident_id", "components", "id"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['investigating', 'identified', 'monitoring', 'resolved']):
            raise ValueError("must be one of enum values ('investigating', 'identified', 'monitoring', 'resolved')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IncidentUpdate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "created_at",
            "updated_at",
            "incident_id",
            "components",
            "id",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if components (nullable) is None
        # and model_fields_set contains the field
        if self.components is None and "components" in self.model_fields_set:
            _dict['components'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IncidentUpdate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "status": obj.get("status"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "body": obj.get("body"),
            "deliver_notifications": obj.get("deliver_notifications") if obj.get("deliver_notifications") is not None else True,
            "incident_id": obj.get("incident_id"),
            "components": obj.get("components"),
            "id": obj.get("id")
        })
        return _obj


