# coding: utf-8

"""
    Pingera API

     The official API for Pingera, a monitoring and status page platform. This API allows you to manage checks, organizations, incidents, and more.   Some useful links: * [Pingera website](https://pingera.ru?utm_source=api_docs) * [API documentation](https://docs.pingera.ru/api/overview) * [Application](https://app.pingera.ru) * [Status page](https://status.pingera.ru) 

    The version of the OpenAPI document: v1
    Contact: privet@pingera.ru
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from pingera.models.check_server import CheckServer
from typing import Optional, Set
from typing_extensions import Self

class MonitorCheckResult(BaseModel):
    """
    MonitorCheckResult
    """ # noqa: E501
    status: Optional[StrictStr] = Field(default=None, description="The result status of the check execution.")
    check_id: StrictStr = Field(description="The identifier of the monitor check this result belongs to.")
    created_at: Optional[datetime] = Field(default=None, description="The timestamp when the check result was created in ISO format.")
    error_message: Optional[StrictStr] = Field(default=None, description="Error message if the check failed.")
    check_metadata: Optional[Dict[str, Any]] = Field(default=None, description="Additional metadata collected during the check execution.")
    check_server_id: Optional[StrictStr] = Field(default=None, description="The identifier of the server that executed this check.")
    check_server: Optional[CheckServer] = Field(default=None, description="Details about the server that executed this check.")
    id: Optional[StrictStr] = Field(default=None, description="The unique identifier for the check result.")
    response_time: Optional[StrictInt] = Field(default=None, description="The response time of the check in milliseconds.")
    __properties: ClassVar[List[str]] = ["status", "check_id", "created_at", "error_message", "check_metadata", "check_server_id", "check_server", "id", "response_time"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ok', 'failed', 'degraded', 'timeout', 'pending']):
            raise ValueError("must be one of enum values ('ok', 'failed', 'degraded', 'timeout', 'pending')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MonitorCheckResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "created_at",
            "check_server",
            "id",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of check_server
        if self.check_server:
            _dict['check_server'] = self.check_server.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MonitorCheckResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "status": obj.get("status"),
            "check_id": obj.get("check_id"),
            "created_at": obj.get("created_at"),
            "error_message": obj.get("error_message"),
            "check_metadata": obj.get("check_metadata"),
            "check_server_id": obj.get("check_server_id"),
            "check_server": CheckServer.from_dict(obj["check_server"]) if obj.get("check_server") is not None else None,
            "id": obj.get("id"),
            "response_time": obj.get("response_time")
        })
        return _obj


