# coding: utf-8

"""
    Pingera API

     The official API for Pingera, a monitoring and status page platform. This API allows you to manage checks, organizations, incidents, and more.   Some useful links: * [Pingera website](https://pingera.ru?utm_source=api_docs) * [API documentation](https://docs.pingera.ru/api/overview) * [Application](https://app.pingera.ru) * [Status page](https://status.pingera.ru) 

    The version of the OpenAPI document: v1
    Contact: privet@pingera.ru
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from pingera.models.user import User
from typing import Optional, Set
from typing_extensions import Self

class OAuthLoginResponse(BaseModel):
    """
    OAuthLoginResponse
    """ # noqa: E501
    auth_method: Optional[StrictStr] = Field(default=None, description="Authentication method used")
    linked_account: Optional[StrictBool] = Field(default=None, description="Whether OAuth account was linked to existing user")
    is_new_user: Optional[StrictBool] = Field(default=None, description="Whether this was a new user registration")
    user: Optional[User] = Field(default=None, description="User information")
    access_token: Optional[StrictStr] = Field(default=None, description="JWT access token for authenticated requests")
    refresh_token: Optional[StrictStr] = Field(default=None, description="Refresh token for obtaining new access tokens")
    __properties: ClassVar[List[str]] = ["auth_method", "linked_account", "is_new_user", "user", "access_token", "refresh_token"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OAuthLoginResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "auth_method",
            "linked_account",
            "is_new_user",
            "user",
            "access_token",
            "refresh_token",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of user
        if self.user:
            _dict['user'] = self.user.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OAuthLoginResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "auth_method": obj.get("auth_method"),
            "linked_account": obj.get("linked_account"),
            "is_new_user": obj.get("is_new_user"),
            "user": User.from_dict(obj["user"]) if obj.get("user") is not None else None,
            "access_token": obj.get("access_token"),
            "refresh_token": obj.get("refresh_token")
        })
        return _obj


