# coding: utf-8

"""
    Pingera API

     The official API for Pingera, a monitoring and status page platform. This API allows you to manage checks, organizations, incidents, and more.   Some useful links: * [Pingera website](https://pingera.ru?utm_source=api_docs) * [API documentation](https://docs.pingera.ru/api/overview) * [Application](https://app.pingera.ru) * [Status page](https://status.pingera.ru) 

    The version of the OpenAPI document: v1
    Contact: privet@pingera.ru
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class User1(BaseModel):
    """
    User1
    """ # noqa: E501
    first_name: Optional[Annotated[str, Field(strict=True, max_length=50)]] = Field(default=None, description="The user's first name. Maximum 50 characters.")
    org_name: Optional[Annotated[str, Field(strict=True, max_length=100)]] = Field(default=None, description="Organization name for registration. Used when creating a new organization. Maximum 100 characters.")
    onboarding_completed: Optional[StrictBool] = Field(default=None, description="Whether the user has completed the onboarding process.")
    email: Optional[StrictStr] = Field(default=None, description="The user's email address. Must be a valid email format and unique.")
    email_verified: Optional[StrictBool] = Field(default=None, description="Whether the user's email address has been verified.")
    created_at: Optional[datetime] = Field(default=None, description="The timestamp when the user account was created in ISO format.")
    onboarding_completed_at: Optional[datetime] = Field(default=None, description="The timestamp when onboarding was completed in ISO format. Null if not completed.")
    last_name: Optional[Annotated[str, Field(strict=True, max_length=50)]] = Field(default=None, description="The user's last name. Maximum 50 characters.")
    last_login: Optional[datetime] = Field(default=None, description="The timestamp of the user's last login in ISO format. Null if never logged in.")
    onboarding_step: Optional[StrictStr] = Field(default=None, description="The current step in the onboarding process. Null if onboarding is completed.")
    verification_token_expires: Optional[Any] = Field(default=None, description="The expiration time of the email verification token in ISO format. Null if already verified.")
    role: Optional[StrictStr] = Field(default=None, description="The user's role within the organization.")
    password: Optional[Annotated[str, Field(min_length=6, strict=True)]] = Field(default=None, description="The user's password. Minimum 6 characters. Only used for input, never returned.")
    organization_id: Optional[StrictStr] = Field(default=None, description="The ID of the organization the user belongs to.")
    id: Optional[StrictStr] = Field(default=None, description="The unique identifier for the user account.")
    is_first_login: Optional[StrictBool] = Field(default=None, description="Whether this is the user's first login to the system.")
    __properties: ClassVar[List[str]] = ["first_name", "org_name", "onboarding_completed", "email", "email_verified", "created_at", "onboarding_completed_at", "last_name", "last_login", "onboarding_step", "verification_token_expires", "role", "password", "organization_id", "id", "is_first_login"]

    @field_validator('role')
    def role_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['admin', 'editor', 'viewer', 'billing']):
            raise ValueError("must be one of enum values ('admin', 'editor', 'viewer', 'billing')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of User1 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "onboarding_completed",
            "email_verified",
            "created_at",
            "onboarding_completed_at",
            "last_login",
            "onboarding_step",
            "verification_token_expires",
            "organization_id",
            "id",
            "is_first_login",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if last_login (nullable) is None
        # and model_fields_set contains the field
        if self.last_login is None and "last_login" in self.model_fields_set:
            _dict['last_login'] = None

        # set to None if verification_token_expires (nullable) is None
        # and model_fields_set contains the field
        if self.verification_token_expires is None and "verification_token_expires" in self.model_fields_set:
            _dict['verification_token_expires'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of User1 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "first_name": obj.get("first_name"),
            "org_name": obj.get("org_name"),
            "onboarding_completed": obj.get("onboarding_completed"),
            "email": obj.get("email"),
            "email_verified": obj.get("email_verified"),
            "created_at": obj.get("created_at"),
            "onboarding_completed_at": obj.get("onboarding_completed_at"),
            "last_name": obj.get("last_name"),
            "last_login": obj.get("last_login"),
            "onboarding_step": obj.get("onboarding_step"),
            "verification_token_expires": obj.get("verification_token_expires"),
            "role": obj.get("role"),
            "password": obj.get("password"),
            "organization_id": obj.get("organization_id"),
            "id": obj.get("id"),
            "is_first_login": obj.get("is_first_login")
        })
        return _obj


