###############################################################################
# Orkid Build System
# Copyright 2010-2020, Michael T. Mayers
# email: michael@tweakoz.com
# The Orkid Build System is published under the GPL 2.0 license
# see http://www.gnu.org/licenses/gpl-2.0.html
###############################################################################

from obt import dep, path

###############################################################################

class depthaicore(dep.StdProvider):
  name = "depthaicore"
  def __init__(self):
    super().__init__(depthaicore.name)
    self.declareDep("cmake")
    self._builder = self.createBuilder(dep.CMakeBuilder)
    self._builder._cmakeenv = {
      "BUILD_SHARED_LIBS": "ON",
      "DEPTHAI_BUILD_TESTS": "ON",
    	"DEPTHAI_BUILD_EXAMPLES": "OFF"
    }

	# echo 'SUBSYSTEM=="usb", ATTRS{idVendor}=="03e7", MODE="0666"' | sudo tee /etc/udev/rules.d/80-movidius.rules
  # sudo udevadm control --reload-rules && sudo udevadm trigger
  
  ########################################################################
  @property
  def _fetcher(self):
    return dep.GithubFetcher(name=depthaicore.name,
                             repospec="tweakoz/depthai-core",
                             revision="main",
                             recursive=True)

  ########################################################################
  def areRequiredSourceFilesPresent(self):
    return (self.source_root/"CMakeLists.txt").exists()
  def areRequiredBinaryFilesPresent(self):
    return (path.libs()/"libxxxx.so").exists()
