# PyQUDA

Python wrapper for [QUDA](https://github.com/lattice/quda) written in Cython.

This project aims to benefit from the optimized linear algebra library [CuPy](https://cupy.dev/) in Python based on CUDA. CuPy and QUDA will allow us to perform most lattice QCD research operations with high performance. [PyTorch](https://pytorch.org/) is an alternative option.

This project is based on the latest QUDA `develop` branch. PyQUDA should be compatible with any commit of QUDA after https://github.com/lattice/quda/pull/1489, but leave some features disabled.

## Feature

- Multi-GPU supported
  - with [MPI for Python](https://mpi4py.readthedocs.io/en/stable/) package
- File I/O
  - Read gauge and propagator in Chroma format (with checksum)
  - Read gauge and propagator in MILC format (with checksum)
  - Read/write gauge and propagator in KYU format
  - Read/write gauge and propagator in XQCD format
  - Read/write gauge and propagator in NPY format (numpy)
- Quark propagator
  - Isotropic/anisotropic Wilson fermion action with multigrid support
  - Isotropic/anisotropic Clover fermion action with multigrid support
  - Isotropic HISQ fermion action
- HMC
  - Isotropic gauge action
  - 1-flavor isotropic clover fermion action
  - 2-flavor isotropic clover fermion action
  - N-flavor isotropic HISQ fermion action
- Gauge fixing
  - Rotation field with over-relaxation method (waiting for QUDA merge)
- Gauge smearing
  - 3D/4D APE smearing
  - 3D/4D stout smearing
  - 3D/4D HYP smearing
- Fermion smearing
  - Gaussian smearing
- Gradient flow
  - Wilson flow
  - Symanzik flow

## Installation

### Install from PyPI

Assuming the QUDA installation path is `/path/to/quda/build/usqcd`

```bash
export QUDA_PATH=/path/to/quda/build/usqcd
python3 -m pip install pyquda pyquda-utils
```

### Install from source

Refer to https://github.com/CLQCD/PyQUDA/wiki/Installation for detailed instructions to install PyQUDA from the source.

## Benchmark

Refer to https://github.com/CLQCD/PyQUDA/wiki/Benchmark for detailed instructions to run the PyQUDA benchmark.

## Documentation (draft)

https://github.com/CLQCD/PyQUDA/wiki/Documentation

## Development

We recommend building PyQUDA using in-place mode instead of installing PyQUDA for development.

```bash
git clone --recursive https://github.com/CLQCD/PyQUDA.git
cd PyQUDA
ln -s pyquda_core/pyquda pyquda
cd pyquda_core
export QUDA_PATH=/path/to/quda/build/usqcd
python3 setup.py build_ext --inplace
```

Now you can modify Python files in the project and immediately get the new result by running scripts. Adding the root directory to `sys.path` is needed if you are running scripts from other directories.

## Maintenance

Function definitions (mainly in `quda.in.pxd` and `pyquda.in.pyx`) and most docstrings (mainly in `pyquda.pyi` and `enum_quda.in.py`) should be manually updated as they cannot be autogenerated now. This also means PyQUDA should work well with future versions if the API remains unchanged.
