# Welcome to jQMC

**jQMC** code implements two real-space ab initio quantum Monte Carlo (QMC) methods. Variatioinal Monte Carlo (VMC) and lattice regularized diffusion Monte Carlo (LRDMC) methods.

![jQMC logo](_static/logo_yoko2.jpg)

The following features of **jQMC** are highlighted:

- {ref}`Variational Monte Carlo (VMC) <vmc_tags>`
- {ref}`Variational Monte Carlo: Wavefuntion Optimization (VMCopt) <vmcopt_tags>`
- {ref}`Lattice Regularized Diffusion Monte Carlo (LRDMC) <lrdmc_tags>`
- {ref}`Atomic forces calculations by VMC and LRDMC <atomic_forces_tags>`
- {ref}`JAX-compaible modules <jax_compatible_modules_tags>`
- {ref}`Interfaces with the TREX-IO wavefunction format <trexio_tags>`


```{toctree}
:hidden:
install
examples
notes/technical_notes
modules
citation
reference
changelog
```

## License

BSD-3-Clause license.

## Developer(s)

- Kosuke Nakano, National Institute for Materials Science

## Acknowledgements

**jQMC** development is supported by:

- National Institute for Materials Science (NIMS).
- Japan Science and Technology Agency (JST), PRESTO program.
- Hpc AlliaNce for Applications and supercoMputing Innovation: the Europe - Japan collaboration
