"""
GravixLayer Python SDK - OpenAI Compatible
"""
__version__ = "0.0.17"

from .client import GravixLayer
from .types.async_client import AsyncGravixLayer
from .types.chat import (
    ChatCompletion,
    ChatCompletionMessage,
    ChatCompletionChoice,
    ChatCompletionUsage,
    FunctionCall,
    ToolCall,
)
from .types.embeddings import (
    EmbeddingResponse,
    EmbeddingObject,
    EmbeddingUsage,
)
from .types.completions import (
    Completion,
    CompletionChoice,
    CompletionUsage,
)

__all__ = [
    "GravixLayer",
    "AsyncGravixLayer",
    "ChatCompletion",
    "ChatCompletionMessage",
    "ChatCompletionChoice",
    "ChatCompletionUsage",
    "FunctionCall",
    "ToolCall",
    "EmbeddingResponse",
    "EmbeddingObject",
    "EmbeddingUsage",
    "Completion",
    "CompletionChoice",
    "CompletionUsage",
]

OpenAI = GravixLayer
