"""
    Setup file for poemai-utils.
    Use setup.cfg to configure your project.

    This file was generated with PyScaffold 4.4.1.
    PyScaffold helps you to put up the scaffold of your new Python project.
    Learn more under: https://pyscaffold.org/
"""

import os
from pathlib import Path

from setuptools import setup

if __name__ == "__main__":
    try:
        version = os.environ.get("POEMAI_BUILD_VERSION")
        if version is None:
            version = Path(__file__).parent.joinpath("VERSION.txt").read_text().strip()
        setup(version=version)
    except:  # noqa
        print(
            "\n\nAn error occurred while building the project, "
            "please ensure you have the most updated version of setuptools, "
            "setuptools_scm and wheel with:\n"
            "   pip install -U setuptools setuptools_scm wheel\n\n"
        )
        raise
