from enum import Enum
from typing import TypeAlias

from google.genai import types

class GeminiRole(Enum):
    User = "user"
    Model = "model"

GeminiMessage: TypeAlias = types.Content

# class Content(_common.BaseModel):
#   """Contains the multi-part content of a message."""
#
#   parts: Optional[list[Part]] = Field(
#       default=None,
#       description="""List of parts that constitute a single message. Each part may have
#       a different IANA MIME type.""",
#   )
#   role: Optional[str] = Field(
#       default=None,
#       description="""Optional. The producer of the content. Must be either 'user' or
#       'model'. Useful to set for multi-turn conversations, otherwise can be
#       left blank or unset. If role is not specified, SDK will determine the role.""",
#   )
#
# class Part(_common.BaseModel):
#   """A datatype containing media content.
#
#   Exactly one field within a Part should be set, representing the specific type
#   of content being conveyed. Using multiple fields within the same `Part`
#   instance is considered invalid.
#   """
#
#   video_metadata: Optional[VideoMetadata] = Field(
#       default=None, description="""Metadata for a given video."""
#   )
#   thought: Optional[bool] = Field(
#       default=None,
#       description="""Indicates if the part is thought from the model.""",
#   )
#   code_execution_result: Optional[CodeExecutionResult] = Field(
#       default=None,
#       description="""Optional. Result of executing the [ExecutableCode].""",
#   )
#   executable_code: Optional[ExecutableCode] = Field(
#       default=None,
#       description="""Optional. Code generated by the model that is meant to be executed.""",
#   )
#   file_data: Optional[FileData] = Field(
#       default=None, description="""Optional. URI based data."""
#   )
#   function_call: Optional[FunctionCall] = Field(
#       default=None,
#       description="""Optional. A predicted [FunctionCall] returned from the model that contains a string representing the [FunctionDeclaration.name] with the parameters and their values.""",
#   )
#   function_response: Optional[FunctionResponse] = Field(
#       default=None,
#       description="""Optional. The result output of a [FunctionCall] that contains a string representing the [FunctionDeclaration.name] and a structured JSON object containing any output from the function call. It is used as context to the model.""",
#   )
#   inline_data: Optional[Blob] = Field(
#       default=None, description="""Optional. Inlined bytes data."""
#   )
#   text: Optional[str] = Field(
#       default=None, description="""Optional. Text part (can be code)."""
#   )
#
#   @classmethod
#   def from_uri(cls, file_uri: str, mime_type: str) -> 'Part':
#     file_data = FileData(file_uri=file_uri, mime_type=mime_type)
#     return cls(file_data=file_data)
#
#   @classmethod
#   def from_text(cls, text: str) -> 'Part':
#     return cls(text=text)
#
#   @classmethod
#   def from_bytes(cls, data: bytes, mime_type: str) -> 'Part':
#     inline_data = Blob(
#         data=data,
#         mime_type=mime_type,
#     )
#     return cls(inline_data=inline_data)
#
#   @classmethod
#   def from_function_call(cls, name: str, args: dict[str, Any]) -> 'Part':
#     function_call = FunctionCall(name=name, args=args)
#     return cls(function_call=function_call)
#
#   @classmethod
#   def from_function_response(
#       cls, name: str, response: dict[str, Any]
#   ) -> 'Part':
#     function_response = FunctionResponse(name=name, response=response)
#     return cls(function_response=function_response)
#
#   @classmethod
#   def from_video_metadata(cls, end_offset: str, start_offset: str) -> 'Part':
#     video_metadata = VideoMetadata(
#         end_offset=end_offset, start_offset=start_offset
#     )
#     return cls(video_metadata=video_metadata)
#
#   @classmethod
#   def from_executable_code(cls, code: str, language: Language) -> 'Part':
#     executable_code = ExecutableCode(code=code, language=language)
#     return cls(executable_code=executable_code)
#
#   @classmethod
#   def from_code_execution_result(cls, outcome: Outcome, output: str) -> 'Part':
#     code_execution_result = CodeExecutionResult(outcome=outcome, output=output)
#     return cls(code_execution_result=code_execution_result)
