"""
Internal mapping of Hector components and variables.
Auto-generated from Hector headers.
"""

components = {
    "CORE": "core",
    "CCS": "carbon-cycle-solver",
    "BOX_MODEL": "carbon-box-model",
    "SIMPLENBOX": "simpleNbox",
    "CH4": "CH4",
    "OH": "OH",
    "N2O": "N2O",
    "TEMPERATURE": "temperature",
    "OCEAN": "ocean",
    "ONELINEOCEAN": "onelineocean",
    "CF4": "CF4_halocarbon",
    "C2F6": "C2F6_halocarbon",
    "HFC23": "HFC23_halocarbon",
    "HFC32": "HFC32_halocarbon",
    "HFC4310": "HFC4310_halocarbon",
    "HFC125": "HFC125_halocarbon",
    "HFC134a": "HFC134a_halocarbon",
    "HFC143a": "HFC143a_halocarbon",
    "HFC227ea": "HFC227ea_halocarbon",
    "HFC245fa": "HFC245fa_halocarbon",
    "SF6": "SF6_halocarbon",
    "CFC11": "CFC11_halocarbon",
    "CFC12": "CFC12_halocarbon",
    "CFC113": "CFC113_halocarbon",
    "CFC114": "CFC114_halocarbon",
    "CFC115": "CFC115_halocarbon",
    "CCl4": "CCl4_halocarbon",
    "CH3CCl3": "CH3CCl3_halocarbon",
    "HCF22": "HCF22_halocarbon",
    "HFC141b": "HCF141b_halocarbon",
    "HFC142b": "HCF142b_halocarbon",
    "halon1211": "halon1211_halocarbon",
    "halon1301": "halon1301_halocarbon",
    "halon2402": "halon2402_halocarbon",
    "CH3Cl": "CH3Cl_halocarbon",
    "CH3Br": "CH3Br_halocarbon",
    "BLACK_CARBON": "bc",
    "ORGANIC_CARBON": "oc",
    "SULFUR": "so2",
    "FORCING": "forcing",
    "SLR": "slr",
    "OZONE": "ozone",
    "DUMMY": "dummy-component",
}

variables = {
    "RUN_NAME": "run_name",
    "START_DATE": "startDate",
    "END_DATE": "endDate",
    "DO_SPINUP": "do_spinup",
    "MAX_SPINUP": "max_spinup",
    "ENABLED": "enabled",
    "OUTPUT_ENABLED": "output",
    "EMISSIONS_BC": "BC_emissions",
    "CCS_EPS_ABS": "eps_abs",
    "CCS_EPS_REL": "eps_rel",
    "CCS_DT": "dt",
    "EPS_SPINUP": "eps_spinup",
    "RF_PREFIX": "F",
    "RF_TOTAL": "Ftot",
    "RF_T_ALBEDO": "Ftalbedo",
    "FTOT_CONSTRAIN": "Ftot_constrain",
    "RF_BASEYEAR": "baseyear",
    "RF_CO2": "FCO2",
    "RF_N2O": "FN2O",
    "RF_H2O": "FH2O",
    "RF_O3": "FO3",
    "RF_BC": "FBC",
    "RF_OC": "FOC",
    "RF_SO2d": "FSO2d",
    "RF_SO2i": "FSO2i",
    "RF_SO2": "FSO2",
    "RF_VOL": "Fvol",
    "RF_halocarbons": "Fhalocarbons",
    "RF_CF4": "FCF4",
    "RF_C2F6": "FC2F6",
    "RF_HFC23": "FHFC23",
    "RF_HFC32": "FHFC32",
    "RF_HFC4310": "FHFC4310",
    "RF_HFC125": "FHFC125",
    "RF_HFC134a": "FHFC134a",
    "RF_HFC143a": "FHFC143a",
    "RF_HFC227ea": "FHFC227ea",
    "RF_HFC245fa": "FHFC245fa",
    "RF_SF6": "FSF6",
    "RF_CFC11": "FCFC11",
    "RF_CFC12": "FCFC12",
    "RF_CFC113": "FCFC113",
    "RF_CFC114": "FCFC114",
    "RF_CFC115": "FCFC115",
    "RF_CCl4": "FCCl4",
    "RF_CH3CCl3": "FCH3CCl3",
    "RF_HCF22": "FHCF22",
    "RF_HCF141b": "FHCF141b",
    "RF_HCF142b": "FHCF142b",
    "RF_halon1211": "Fhalon1211",
    "RF_halon1301": "Fhalon1301",
    "RF_halon2402": "Fhalon2402",
    "RF_CH3Cl": "FCH3Cl",
    "RF_CH3Br": "FCH3Br",
    "EMISSIONS_CF4": "CF4_emissions",
    "EMISSIONS_C2F6": "C2F6_emissions",
    "EMISSIONS_HFC23": "HFC23_emissions",
    "EMISSIONS_HFC32": "HFC32_emissions",
    "EMISSIONS_HFC4310": "HFC4310_emissions",
    "EMISSIONS_HFC125": "HFC125_emissions",
    "EMISSIONS_HFC134a": "HFC134a_emissions",
    "EMISSIONS_HFC143a": "HFC143a_emissions",
    "EMISSIONS_HFC227ea": "HFC227ea_emissions",
    "EMISSIONS_HFC245fa": "HFC245fa_emissions",
    "EMISSIONS_SF6": "SF6_emissions",
    "EMISSIONS_CFC11": "CFC11_emissions",
    "EMISSIONS_CFC12": "CFC12_emissions",
    "EMISSIONS_CFC113": "CFC113_emissions",
    "EMISSIONS_CFC114": "CFC114_emissions",
    "EMISSIONS_CFC115": "CFC115_emissions",
    "EMISSIONS_CCl4": "CCl4_emissions",
    "EMISSIONS_CH3CCl3": "CH3CCl3_emissions",
    "EMISSIONS_HCF22": "HCF22_emissions",
    "EMISSIONS_HCF141b": "HCF141b_emissions",
    "EMISSIONS_HCF142b": "HCF142b_emissions",
    "EMISSIONS_halon1211": "halon1211_emissions",
    "EMISSIONS_halon1301": "halon1301_emissions",
    "EMISSIONS_halon2402": "halon2402_emissions",
    "EMISSIONS_CH3Cl": "CH3Cl_emissions",
    "EMISSIONS_CH3Br": "CH3Br_emissions",
    "PREINDUSTRIAL_HC": "H0",
    "HC_CONCENTRATION": "hc_concentration",
    "HC_EMISSION": "hc_emission",
    "HC_TAU": "tau",
    "HC_RHO": "rho",
    "HC_MOLARMASS": "molarMass",
    "ATMOSPHERIC_CH4": "CH4",
    "PREINDUSTRIAL_CH4": "M0",
    "RF_CH4": "FCH4",
    "EMISSIONS_CH4": "CH4_emissions",
    "NATURAL_CH4": "CH4N",
    "CONVERSION_CH4": "UC_CH4",
    "LIFETIME_SOIL": "Tsoil",
    "LIFETIME_STRAT": "Tstrat",
    "ATMOSPHERIC_N2O": "N2O",
    "PREINDUSTRIAL_N2O": "N0",
    "EMISSIONS_N2O": "N2O_emissions",
    "CONVERSION_N2O": "UC_N2O",
    "INITIAL_LIFETIME_N2O": "TN2O0",
    "NAT_EMISSIONS_N2O": "N2O_natural_emissions",
    "TAU_N2O": "TAU_N2O",
    "LIFETIME_OH": "TAU_OH",
    "INITIAL_LIFETIME_OH": "TOH0",
    "COEFFICENT_NOX": "CNOX",
    "COEFFICENT_CH4": "CCH4",
    "COEFFICENT_NMVOC": "CNMVOC",
    "COEFFICENT_CO": "CCO",
    "PREINDUSTRIAL_O3": "PO3",
    "ATMOSPHERIC_O3": "O3",
    "ATMOSPHERIC_EM_CH4": "CH4",
    "EMISSIONS_NOX": "NOX_emissions",
    "EMISSIONS_CO": "CO_emissions",
    "EMISSIONS_NMVOC": "NMVOC_emissions",
    "EMISSIONS_OC": "OC_emissions",
    "OCEAN_CFLUX": "atm_ocean_flux",
    "OCEAN_C": "ocean_c",
    "TT": "tt",
    "TU": "tu",
    "TWI": "twi",
    "TID": "tid",
    "CIRC_TOPT": "circ_Topt",
    "CIRC_T50_HIGH": "circ_T50_high",
    "CIRC_T50_LOW": "circ_T50_low",
    "HL_DO": "HL_DO_Cflux",
    "PH_HL": "pH_HL",
    "PH_LL": "pH_LL",
    "ATM_OCEAN_FLUX_HL": "atm_ocean_flux_HL",
    "ATM_OCEAN_FLUX_LL": "atm_ocean_flux_LL",
    "PCO2_HL": "PCO2_HL",
    "PCO2_LL": "PCO2_LL",
    "DIC_HL": "DIC_HL",
    "DIC_LL": "DIC_LL",
    "P0_LL": "p0_LL",
    "CARBON_HL": "carbon_HL",
    "CARBON_LL": "carbon_LL",
    "CARBON_IO": "carbon_IO",
    "CARBON_DO": "carbon_DO",
    "OMEGACA_HL": "OmegaCa_HL",
    "OMEGACA_LL": "OmegaCa_LL",
    "OMEGAAR_HL": "OmegaAr_HL",
    "OMEGAAR_LL": "OmegaAr_LL",
    "TEMP_HL": "Temp_HL",
    "TEMP_LL": "Temp_LL",
    "SPINUP_CHEM": "spinup_chem",
    "CO3_LL": "CO3_LL",
    "CO3_HL": "CO3_HL",
    "ATM_OCEAN_CONSTRAIN": "atm_ocean_constrain",
    "TIMESTEPS": "ocean_timesteps",
    "REVELLE_HL": "Revelle_HL",
    "REVELLE_LL": "Revelle_LL",
    "LAND_CFLUX": "atm_land_flux",
    "ATMOSPHERIC_CO2": "Ca",
    "PREINDUSTRIAL_CO2": "C0",
    "ATMOSPHERIC_C": "atmos_c",
    "ATMOSPHERIC_C_RESIDUAL": "atmos_c_residual",
    "EARTHC": "earth_c",
    "VEGC": "veg_c",
    "DETRITUSC": "detritus_c",
    "SOILC": "soil_c",
    "FFI_EMISSIONS": "ffi_emissions",
    "LUC_EMISSIONS": "luc_emissions",
    "CO2FERT": "co2fert",
    "TEMPFERTD": "detritus_tempfert",
    "TEMPFERTS": "soil_tempfert",
    "Q10_RH": "q10_rh",
    "NPP": "npp",
    "RH": "rh",
    "F_NPPV": "f_nppv",
    "F_NPPD": "f_nppd",
    "F_LITTERD": "f_litterd",
    "F_LUCV": "f_lucv",
    "F_LUCD": "f_lucd",
    "NPP_FLUX0": "npp_flux0",
    "CA_CONSTRAIN": "Ca_constrain",
    "BETA": "beta",
    "WARMINGFACTOR": "warmingfactor",
    "SL_RC": "sl_rc",
    "SLR": "slr",
    "SL_RC_NO_ICE": "sl_rc_no_ice",
    "SLR_NO_ICE": "slr_no_ice",
    "NATURAL_SO2": "SN",
    "2000_SO2": "S0",
    "EMISSIONS_SO2": "SO2_emissions",
    "VOLCANIC_SO2": "SV",
    "ECS": "S",
    "GLOBAL_TEMP": "Tgav",
    "GLOBAL_TEMPEQ": "Tgaveq",
    "TGAV_CONSTRAIN": "tgav_constrain",
    "SO2D_B": "so2d_b",
    "SO2I_B": "so2i_b",
    "OC_B": "oc_b",
    "BC_B": "bc_b",
    "DIFFUSIVITY": "diff",
    "AERO_SCALE": "alpha",
    "VOLCANIC_SCALE": "volscl",
    "FLUX_MIXED": "flux_mixed",
    "FLUX_INTERIOR": "flux_interior",
    "HEAT_FLUX": "heatflux",
}
