"""Dictionary with default config."""

_default_config = {
    "C2F6_halocarbon": {"molarMass": 138.01, "rho": 0.00026, "tau": 10000.0},
    "CCl4_halocarbon": {"molarMass": 153.8, "rho": 0.00013, "tau": 26.0},
    "CF4_halocarbon": {
        "H0": (35.0, "pptv"),
        "molarMass": 88.0043,
        "rho": 8e-05,
        "tau": 50000.0,
    },
    "CFC113_halocarbon": {"molarMass": 187.35, "rho": 0.0003, "tau": 85.0},
    "CFC114_halocarbon": {"molarMass": 170.9, "rho": 0.00031, "tau": 300},
    "CFC115_halocarbon": {"molarMass": 154.45, "rho": 0.00018, "tau": 1700},
    "CFC11_halocarbon": {"molarMass": 137.35, "rho": 0.00025, "tau": 45.0},
    "CFC12_halocarbon": {"molarMass": 120.9, "rho": 0.00032, "tau": 100},
    "CH3Br_halocarbon": {"H0": 5.8, "molarMass": 94.9, "rho": 1e-05, "tau": 0.7},
    "CH3CCl3_halocarbon": {"molarMass": 133.35, "rho": 6e-05, "tau": 5.0},
    "CH3Cl_halocarbon": {"H0": 504.0, "molarMass": 50.45, "rho": 1e-05, "tau": 1.3},
    "CH4": {"CH4N": 300, "M0": 653, "Tsoil": 160, "Tstrat": 120, "UC_CH4": 2.78},
    "HCF141b_halocarbon": {"molarMass": 116.9, "rho": 0.00014, "tau": 9.3},
    "HCF142b_halocarbon": {"molarMass": 100.45, "rho": 0.0002, "tau": 17.9},
    "HCF22_halocarbon": {"molarMass": 86.45, "rho": 0.0002, "tau": 12.0},
    "HFC125_halocarbon": {"molarMass": 120.02, "rho": 0.00023, "tau": 29.0},
    "HFC134a_halocarbon": {"molarMass": 102.02, "rho": 0.00016, "tau": 14.0},
    "HFC143a_halocarbon": {"molarMass": 84.04, "rho": 0.00013, "tau": 52.0},
    "HFC227ea_halocarbon": {"molarMass": 170.03, "rho": 0.00026, "tau": 34.2},
    "HFC23_halocarbon": {"molarMass": 70.0, "rho": 0.00019, "tau": 270.0},
    "HFC245fa_halocarbon": {"molarMass": 134.0, "rho": 0.00028, "tau": 7.6},
    "HFC32_halocarbon": {"molarMass": 52.0, "rho": 0.00011, "tau": 4.9},
    "HFC4310_halocarbon": {"molarMass": 252.0, "rho": 0.0004, "tau": 15.9},
    "N2O": {
        "N0": 272.9596,
        "N2O_natural_emissions": [(1765, 11), (2000, 8), (2300, 8)],
        "TN2O0": 132,
        "UC_N2O": 4.8,
    },
    "OH": {
        "CCH4": -0.32,
        "CCO": -0.000105,
        "CNMVOC": -0.000315,
        "CNOX": 0.0042,
        "TOH0": 6.6,
    },
    "SF6_halocarbon": {"molarMass": 146.06, "rho": 0.00052, "tau": 3200.0},
    "carbon-cycle-solver": {
        "dt": 0.25,
        "eps_abs": 1e-06,
        "eps_rel": 1e-06,
        "eps_spinup": 0.001,
    },
    "core": {
        "do_spinup": True,
        "endDate": 2300,
        "max_spinup": 2000,
        "run_name": "pyhector-run",
        "startDate": 1745,
    },
    "forcing": {"baseyear": 1750},
    "halon1211_halocarbon": {"molarMass": 165.35, "rho": 3e-05, "tau": 16.0},
    "halon1301_halocarbon": {"molarMass": 148.9, "rho": 0.00032, "tau": 65.0},
    "halon2402_halocarbon": {"molarMass": 259.8, "rho": 0.00033, "tau": 20.0},
    "ocean": {
        "enabled": True,
        "spinup_chem": 0,
        "tid": 200000000,
        "tt": 72000000,
        "tu": 49000000,
        "twi": 12500000,
    },
    "onelineocean": {"enabled": False, "ocean_c": 38000},
    "ozone": {"PO3": 30.0},
    "simpleNbox": {
        "Ftalbedo": [(1750, 0.0), (1950, -0.2)],
        "atmos_c": 588.071,
        "beta": 0.36,
        "detritus_c": 55,
        "f_litterd": 0.98,
        "f_lucd": 0.01,
        "f_lucv": 0.1,
        "f_nppd": 0.6,
        "f_nppv": 0.35,
        "npp_flux0": 50.0,
        "q10_rh": 2.0,
        "soil_c": 1782,
        "veg_c": 550,
    },
    "so2": {
        "S0": 53841.2,
        "SN": 42000,
        "SV": [
            (1765, 0),
            (1766, 0.11622211),
            (1767, 0.23244422),
            (1768, 0.19744422),
            (1769, 0.13181922),
            (1770, 0.12744422),
            (1771, 0.17994422),
            (1772, 0.21494422),
            (1773, 0.22806922),
            (1774, 0.23244422),
            (1775, 0.23244422),
            (1776, 0.23244422),
            (1777, 0.23244422),
            (1778, 0.23244422),
            (1779, 0.23244422),
            (1780, 0.23244422),
            (1781, 0.23244422),
            (1782, 0.21056922),
            (1783, 0.11869422),
            (1784, 0.044319219),
            (1785, 0.10119422),
            (1786, 0.18869422),
            (1787, 0.22369422),
            (1788, 0.22806922),
            (1789, 0.12306922),
            (1790, -0.025680781),
            (1791, 0.009319219),
            (1792, 0.14056922),
            (1793, 0.20619422),
            (1794, 0.21494422),
            (1795, 0.19306922),
            (1796, 0.18869422),
            (1797, 0.21056922),
            (1798, 0.22806922),
            (1799, 0.23244422),
            (1800, 0.23244422),
            (1801, 0.23244422),
            (1802, 0.23244422),
            (1803, 0.23244422),
            (1804, 0.23244422),
            (1805, 0.23244422),
            (1806, 0.23244422),
            (1807, 0.23244422),
            (1808, -0.25755578),
            (1809, -1.3994308),
            (1810, -1.8019308),
            (1811, -1.0100558),
            (1812, -0.34068078),
            (1813, -0.14818078),
            (1814, -0.67755578),
            (1815, -2.1519308),
            (1816, -2.6638058),
            (1817, -1.4956808),
            (1818, -0.36255578),
            (1819, 0.092444219),
            (1820, 0.22369422),
            (1821, 0.23244422),
            (1822, 0.23244422),
            (1823, 0.23244422),
            (1824, 0.23244422),
            (1825, 0.23244422),
            (1826, 0.23244422),
            (1827, 0.23244422),
            (1828, 0.22806922),
            (1829, 0.19306922),
            (1830, -0.021305781),
            (1831, -0.39755578),
            (1832, -0.48505578),
            (1833, -0.18318078),
            (1834, -0.34505578),
            (1835, -0.98818078),
            (1836, -0.94880578),
            (1837, -0.34943078),
            (1838, 0.044319219),
            (1839, 0.17994422),
            (1840, 0.17994422),
            (1841, 0.17556922),
            (1842, 0.18869422),
            (1843, 0.16681922),
            (1844, 0.15369422),
            (1845, 0.18431922),
            (1846, 0.21494422),
            (1847, 0.22806922),
            (1848, 0.23244422),
            (1849, 0.21599422),
            (1850, 0.19200464),
            (1851, 0.19303276),
            (1852, 0.20879734),
            (1853, 0.2235338),
            (1854, 0.2317588),
            (1855, 0.10118693),
            (1856, -0.35667141),
            (1857, -0.61027557),
            (1858, -0.29772557),
            (1859, 0.028190052),
            (1860, 0.15053693),
            (1861, 0.13957026),
            (1862, 0.05526401),
            (1863, 0.06760151),
            (1864, 0.15087964),
            (1865, 0.19851609),
            (1866, 0.21907859),
            (1867, 0.22901714),
            (1868, 0.23107339),
            (1869, 0.22284839),
            (1870, 0.21873589),
            (1871, 0.2194213),
            (1872, 0.2070838),
            (1873, 0.19337547),
            (1874, 0.20125776),
            (1875, 0.19406089),
            (1876, 0.15293589),
            (1877, 0.14848068),
            (1878, 0.18035255),
            (1879, 0.20194318),
            (1880, 0.21565151),
            (1881, 0.22284839),
            (1882, 0.11112547),
            (1883, -0.80253495),
            (1884, -1.5373016),
            (1885, -0.94407349),
            (1886, -0.44851724),
            (1887, -0.32137245),
            (1888, -0.21102036),
            (1889, -0.27750578),
            (1890, -0.3316537),
            (1891, -0.2617412),
            (1892, -0.087645365),
            (1893, 0.060061927),
            (1894, 0.16938589),
            (1895, 0.1618463),
            (1896, 0.016537969),
            (1897, -0.064683906),
            (1898, 0.037785885),
            (1899, 0.15053693),
            (1900, 0.20194318),
            (1901, 0.19166193),
            (1902, -0.25694328),
            (1903, -0.65105786),
            (1904, -0.3563287),
            (1905, 0.002144219),
            (1906, 0.1001588),
            (1907, 0.076169219),
            (1908, 0.087821302),
            (1909, 0.15396401),
            (1910, 0.18892026),
            (1911, 0.19508901),
            (1912, -0.048576615),
            (1913, -0.15652974),
            (1914, 0.055606719),
            (1915, 0.15944734),
            (1916, 0.18754943),
            (1917, 0.19611714),
            (1918, 0.20194318),
            (1919, 0.1947463),
            (1920, 0.11078276),
            (1921, 0.095703594),
            (1922, 0.18103797),
            (1923, 0.20228589),
            (1924, 0.18926297),
            (1925, 0.18926297),
            (1926, 0.19714526),
            (1927, 0.19508901),
            (1928, 0.14573901),
            (1929, 0.096046302),
            (1930, 0.12174943),
            (1931, 0.14642443),
            (1932, 0.11489526),
            (1933, 0.12380568),
            (1934, 0.16218901),
            (1935, 0.16938589),
            (1936, 0.18069526),
            (1937, 0.17932443),
            (1938, 0.16321714),
            (1939, 0.16390255),
            (1940, 0.18377964),
            (1941, 0.19303276),
            (1942, 0.17144214),
            (1943, 0.16630151),
            (1944, 0.18926297),
            (1945, 0.19988693),
            (1946, 0.2070838),
            (1947, 0.1988588),
            (1948, 0.19680255),
            (1949, 0.18926297),
            (1950, 0.18686401),
            (1951, 0.1906338),
            (1952, 0.18446505),
            (1953, 0.17555464),
            (1954, 0.18069526),
            (1955, 0.2029713),
            (1956, 0.2153088),
            (1957, 0.22559005),
            (1958, 0.23073068),
            (1959, 0.22696089),
            (1960, 0.15190776),
            (1961, 0.060747344),
            (1962, -0.013963073),
            (1963, -0.49546828),
            (1964, -0.85325578),
            (1965, -0.53248078),
            (1966, -0.15001828),
            (1967, -0.021502656),
            (1968, -0.22027349),
            (1969, -0.29635474),
            (1970, -0.055430781),
            (1971, 0.11420984),
            (1972, 0.15327859),
            (1973, 0.10632755),
            (1974, -0.040694323),
            (1975, -0.14110786),
            (1976, -0.017390156),
            (1977, 0.13408693),
            (1978, 0.10906922),
            (1979, 0.093990052),
            (1980, 0.14813797),
            (1981, 0.079596302),
            (1982, -0.59142661),
            (1983, -0.87621724),
            (1984, -0.32000161),
            (1985, -0.023216198),
            (1986, 0.035044219),
            (1987, 0.065887969),
            (1988, 0.10598484),
            (1989, 0.12928901),
            (1990, 0.12654734),
            (1991, -0.81487245),
            (1992, -1.4197527),
            (1993, -0.68190161),
            (1994, -0.13151203),
            (1995, 0.058691094),
            (1996, 0.12380568),
            (1997, 0.15327859),
            (1998, 0.18754943),
            (1999, 0.21633693),
            (2000, 0.22867443),
            (2001, 0.23244422),
            (2002, 0.23244422),
            (2003, 0.23244422),
            (2004, 0.23244422),
            (2005, 0.18401834),
            (2006, 0.06779623),
            (2007, 0),
            (2008, 0),
            (2009, 0),
            (2010, 0),
        ],
    },
    "temperature": {
        "S": 3.0,
        "alpha": 1.0,
        "diff": 2.3,
        "enabled": True,
        "volscl": 1.0,
    },
}
