"""Hector output variables."""

output = {
    "C2F6_halocarbon.hc_concentration": {
        "component": "C2F6_halocarbon",
        "description": "C2F6 concentration",
        "unit": "pptv",
        "variable": "hc_concentration",
    },
    "CCl4_halocarbon.hc_concentration": {
        "component": "CCl4_halocarbon",
        "description": "CCl4 concentration",
        "unit": "pptv",
        "variable": "hc_concentration",
    },
    "CF4_halocarbon.hc_concentration": {
        "component": "CF4_halocarbon",
        "description": "CF4 concentration",
        "unit": "pptv",
        "variable": "hc_concentration",
    },
    "CFC113_halocarbon.hc_concentration": {
        "component": "CFC113_halocarbon",
        "description": "CFC113 concentration",
        "unit": "pptv",
        "variable": "hc_concentration",
    },
    "CFC114_halocarbon.hc_concentration": {
        "component": "CFC114_halocarbon",
        "description": "CFC114 concentration",
        "unit": "pptv",
        "variable": "hc_concentration",
    },
    "CFC115_halocarbon.hc_concentration": {
        "component": "CFC115_halocarbon",
        "description": "CFC115 concentration",
        "unit": "pptv",
        "variable": "hc_concentration",
    },
    "CFC11_halocarbon.hc_concentration": {
        "component": "CFC11_halocarbon",
        "description": "CFC11 concentration",
        "unit": "pptv",
        "variable": "hc_concentration",
    },
    "CFC12_halocarbon.hc_concentration": {
        "component": "CFC12_halocarbon",
        "description": "CFC12 concentration",
        "unit": "pptv",
        "variable": "hc_concentration",
    },
    "CH3Br_halocarbon.hc_concentration": {
        "component": "CH3Br_halocarbon",
        "description": "CH3Br concentration",
        "unit": "pptv",
        "variable": "hc_concentration",
    },
    "CH3CCl3_halocarbon.hc_concentration": {
        "component": "CH3CCl3_halocarbon",
        "description": "CH3CCl3 concentration",
        "unit": "pptv",
        "variable": "hc_concentration",
    },
    "CH3Cl_halocarbon.hc_concentration": {
        "component": "CH3Cl_halocarbon",
        "description": "CH3Cl concentration",
        "unit": "pptv",
        "variable": "hc_concentration",
    },
    "CH4.CH4": {
        "component": "CH4",
        "description": "CH4 concentration",
        "unit": "ppbv CH4",
        "needs_date": True,
        "variable": "CH4",
    },
    "HCF141b_halocarbon.hc_concentration": {
        "component": "HCF141b_halocarbon",
        "description": "HFC141b concentration",
        "unit": "pptv",
        "variable": "hc_concentration",
    },
    "HCF142b_halocarbon.hc_concentration": {
        "component": "HCF142b_halocarbon",
        "description": "HFC142b concentration",
        "unit": "pptv",
        "variable": "hc_concentration",
    },
    "HCF22_halocarbon.hc_concentration": {
        "component": "HCF22_halocarbon",
        "description": "HFC22 concentration",
        "unit": "pptv",
        "variable": "hc_concentration",
    },
    "HFC125_halocarbon.hc_concentration": {
        "component": "HFC125_halocarbon",
        "description": "HFC125 concentration",
        "unit": "pptv",
        "variable": "hc_concentration",
    },
    "HFC134a_halocarbon.hc_concentration": {
        "component": "HFC134a_halocarbon",
        "description": "HFC134a concentration",
        "unit": "pptv",
        "variable": "hc_concentration",
    },
    "HFC143a_halocarbon.hc_concentration": {
        "component": "HFC143a_halocarbon",
        "description": "HFC143a concentration",
        "unit": "pptv",
        "variable": "hc_concentration",
    },
    "HFC227ea_halocarbon.hc_concentration": {
        "component": "HFC227ea_halocarbon",
        "description": "HFC227ea " "concentration",
        "unit": "pptv",
        "variable": "hc_concentration",
    },
    "HFC23_halocarbon.hc_concentration": {
        "component": "HFC23_halocarbon",
        "description": "HFC23 concentration",
        "unit": "pptv",
        "variable": "hc_concentration",
    },
    "HFC245fa_halocarbon.hc_concentration": {
        "component": "HFC245fa_halocarbon",
        "description": "HFC245fa " "concentration",
        "unit": "pptv",
        "variable": "hc_concentration",
    },
    "HFC32_halocarbon.hc_concentration": {
        "component": "HFC32_halocarbon",
        "description": "HFC32 concentration",
        "unit": "pptv",
        "variable": "hc_concentration",
    },
    "HFC4310_halocarbon.hc_concentration": {
        "component": "HFC4310_halocarbon",
        "description": "HFC4310 concentration",
        "unit": "pptv",
        "variable": "hc_concentration",
    },
    "N2O.N2O": {
        "component": "N2O",
        "description": "N2O concentration",
        "unit": "ppbv N2O",
        "needs_date": True,
        "variable": "N2O",
    },
    "OH.TAU_OH": {
        "component": "OH",
        "description": "OH lifetime",
        "unit": "Years",
        "needs_date": True,
        "variable": "TAU_OH",
    },
    "SF6_halocarbon.hc_concentration": {
        "component": "SF6_halocarbon",
        "description": "SF6 concentration",
        "unit": "pptv",
        "variable": "hc_concentration",
    },
    "forcing.Ftot": {
        "component": "forcing",
        "description": "total global radiative forcing",
        "unit": "W/m2",
        "variable": "Ftot",
    },
    "forcing.FBC": {
        "component": "forcing",
        "description": "radiative forcing from BC",
        "unit": "W/m2",
        "variable": "FBC",
    },
    "forcing.FC2F6": {
        "component": "forcing",
        "description": "radiative forcing from C2F6",
        "unit": "W/m2",
        "variable": "FC2F6",
    },
    "forcing.FCCl4": {
        "component": "forcing",
        "description": "radiative forcing from CCl4",
        "unit": "W/m2",
        "variable": "FCCl4",
    },
    "forcing.FCF4": {
        "component": "forcing",
        "description": "radiative forcing from CF4",
        "unit": "W/m2",
        "variable": "FCF4",
    },
    "forcing.FCFC11": {
        "component": "forcing",
        "description": "radiative forcing from CFC11",
        "unit": "W/m2",
        "variable": "FCFC11",
    },
    "forcing.FCFC113": {
        "component": "forcing",
        "description": "radiative forcing from CFC113",
        "unit": "W/m2",
        "variable": "FCFC113",
    },
    "forcing.FCFC114": {
        "component": "forcing",
        "description": "radiative forcing from CFC114",
        "unit": "W/m2",
        "variable": "FCFC114",
    },
    "forcing.FCFC115": {
        "component": "forcing",
        "description": "radiative forcing from CFC115",
        "unit": "W/m2",
        "variable": "FCFC115",
    },
    "forcing.FCFC12": {
        "component": "forcing",
        "description": "radiative forcing from CFC12",
        "unit": "W/m2",
        "variable": "FCFC12",
    },
    "forcing.FCH3Br": {
        "component": "forcing",
        "description": "radiative forcing from CH3Br",
        "unit": "W/m2",
        "variable": "FCH3Br",
    },
    "forcing.FCH3CCl3": {
        "component": "forcing",
        "description": "radiative forcing from CH3CCl3",
        "unit": "W/m2",
        "variable": "FCH3CCl3",
    },
    "forcing.FCH3Cl": {
        "component": "forcing",
        "description": "radiative forcing from CH3Cl",
        "unit": "W/m2",
        "variable": "FCH3Cl",
    },
    "forcing.FCH4": {
        "component": "forcing",
        "description": "radiative forcing from CH4",
        "unit": "W/m2",
        "variable": "FCH4",
    },
    "forcing.FCO2": {
        "component": "forcing",
        "description": "radiative forcing from CO2",
        "unit": "W/m2",
        "variable": "FCO2",
    },
    "forcing.FH2O": {
        "component": "forcing",
        "description": "radiative forcing from H2O",
        "unit": "W/m2",
        "variable": "FH2O",
    },
    "forcing.FHCF141b": {
        "component": "forcing",
        "description": "radiative forcing from HCF141b",
        "unit": "W/m2",
        "variable": "FHCF141b",
    },
    "forcing.FHCF142b": {
        "component": "forcing",
        "description": "radiative forcing from HCF142b",
        "unit": "W/m2",
        "variable": "FHCF142b",
    },
    "forcing.FHCF22": {
        "component": "forcing",
        "description": "radiative forcing from HCF22",
        "unit": "W/m2",
        "variable": "FHCF22",
    },
    "forcing.FHFC125": {
        "component": "forcing",
        "description": "radiative forcing from HFC125",
        "unit": "W/m2",
        "variable": "FHFC125",
    },
    "forcing.FHFC134a": {
        "component": "forcing",
        "description": "radiative forcing from HFC134a",
        "unit": "W/m2",
        "variable": "FHFC134a",
    },
    "forcing.FHFC143a": {
        "component": "forcing",
        "description": "radiative forcing from HFC143a",
        "unit": "W/m2",
        "variable": "FHFC143a",
    },
    "forcing.FHFC227ea": {
        "component": "forcing",
        "description": "radiative forcing from HFC227ea",
        "unit": "W/m2",
        "variable": "FHFC227ea",
    },
    "forcing.FHFC23": {
        "component": "forcing",
        "description": "radiative forcing from HFC23",
        "unit": "W/m2",
        "variable": "FHFC23",
    },
    "forcing.FHFC245fa": {
        "component": "forcing",
        "description": "radiative forcing from HFC245fa",
        "unit": "W/m2",
        "variable": "FHFC245fa",
    },
    "forcing.FHFC32": {
        "component": "forcing",
        "description": "radiative forcing from HFC32",
        "unit": "W/m2",
        "variable": "FHFC32",
    },
    "forcing.FHFC4310": {
        "component": "forcing",
        "description": "radiative forcing from HFC4310",
        "unit": "W/m2",
        "variable": "FHFC4310",
    },
    "forcing.FN2O": {
        "component": "forcing",
        "description": "radiative forcing from N2O",
        "unit": "W/m2",
        "variable": "FN2O",
    },
    "forcing.FO3": {
        "component": "forcing",
        "description": "radiative forcing from O3",
        "unit": "W/m2",
        "variable": "FO3",
    },
    "forcing.FOC": {
        "component": "forcing",
        "description": "radiative forcing from OC",
        "unit": "W/m2",
        "variable": "FOC",
    },
    "forcing.FSF6": {
        "component": "forcing",
        "description": "radiative forcing from SF6",
        "unit": "W/m2",
        "variable": "FSF6",
    },
    "forcing.FSO2": {
        "component": "forcing",
        "description": "radiative forcing from SO2",
        "unit": "W/m2",
        "variable": "FSO2",
    },
    "forcing.FSO2d": {
        "component": "forcing",
        "description": "radiative forcing from SO2d",
        "unit": "W/m2",
        "variable": "FSO2d",
    },
    "forcing.FSO2i": {
        "component": "forcing",
        "description": "radiative forcing from SO2i",
        "unit": "W/m2",
        "variable": "FSO2i",
    },
    "forcing.Fhalon1211": {
        "component": "forcing",
        "description": "radiative forcing from halon1211",
        "unit": "W/m2",
        "variable": "Fhalon1211",
    },
    "forcing.Fhalon1301": {
        "component": "forcing",
        "description": "radiative forcing from halon1301",
        "unit": "W/m2",
        "variable": "Fhalon1301",
    },
    "forcing.Fhalon2402": {
        "component": "forcing",
        "description": "radiative forcing from halon2402",
        "unit": "W/m2",
        "variable": "Fhalon2402",
    },
    "forcing.Ftalbedo": {
        "component": "forcing",
        "description": "radiative forcing from terrestrial albedo forcing",
        "unit": "W/m2",
        "variable": "Ftalbedo",
    },
    "forcing.Fvol": {
        "component": "forcing",
        "description": "volcanic radiative forcing",
        "unit": "W/m2",
        "variable": "Fvol",
    },
    "halon1211_halocarbon.hc_concentration": {
        "component": "halon1211_halocarbon",
        "description": "halon1211 concentration",
        "unit": "pptv",
        "variable": "hc_concentration",
    },
    "halon1301_halocarbon.hc_concentration": {
        "component": "halon1301_halocarbon",
        "description": "halon1301 concentration",
        "unit": "pptv",
        "variable": "hc_concentration",
    },
    "halon2402_halocarbon.hc_concentration": {
        "component": "halon2402_halocarbon",
        "description": "halono2402 concentration",
        "unit": "pptv",
        "variable": "hc_concentration",
    },
    "ocean.CO3_HL": {
        "component": "ocean",
        "description": "carbonate ion - high latitude",
        "unit": "umol/kg",
        "variable": "CO3_HL",
    },
    "ocean.CO3_LL": {
        "component": "ocean",
        "description": "carbonate ion - low latitude",
        "unit": "umol/kg",
        "variable": "CO3_LL",
    },
    "ocean.DIC_HL": {
        "component": "ocean",
        "description": "dissolved inorganic carbon - high latitude",
        "unit": "umol/kg",
        "variable": "DIC_HL",
    },
    "ocean.DIC_LL": {
        "component": "ocean",
        "description": "dissolved inorganic carbon - low latitude",
        "unit": "umol/kg",
        "variable": "DIC_LL",
    },
    "ocean.HL_DO_Cflux": {
        "component": "ocean",
        "description": "flux of carbon from the high latitude " "to the deep ocean",
        "unit": "Pg C/yr",
        "variable": "HL_DO_Cflux",
    },
    "ocean.OmegaAr_HL": {
        "component": "ocean",
        "description": "aragnoite saturation - high latitude",
        "unit": "(unitless)",
        "variable": "OmegaAr_HL",
    },
    "ocean.OmegaAr_LL": {
        "component": "ocean",
        "description": "aragnoite saturation - low latitude",
        "unit": "(unitless)",
        "variable": "OmegaAr_LL",
    },
    "ocean.OmegaCa_HL": {
        "component": "ocean",
        "description": "calcite saturation - high latitude",
        "unit": "(unitless)",
        "variable": "OmegaCa_HL",
    },
    "ocean.OmegaCa_LL": {
        "component": "ocean",
        "description": "calcite saturation - low latitude",
        "unit": "(unitless)",
        "variable": "OmegaCa_LL",
    },
    "ocean.PCO2_HL": {
        "component": "ocean",
        "description": "partial pressure CO2 - high latitude",
        "unit": "uatm",
        "variable": "PCO2_HL",
    },
    "ocean.PCO2_LL": {
        "component": "ocean",
        "description": "partial pressure CO2 - low latitude",
        "unit": "uatm",
        "variable": "PCO2_LL",
    },
    "ocean.Revelle_HL": {
        "component": "ocean",
        "description": "Revelle factor - high latitude",
        "unit": "(unitless)",
        "variable": "Revelle_HL",
    },
    "ocean.Revelle_LL": {
        "component": "ocean",
        "description": "Revelle factor - low latitude",
        "unit": "(unitless)",
        "variable": "Revelle_LL",
    },
    "ocean.Temp_HL": {
        "component": "ocean",
        "description": "ocean surface temperature - high latitude",
        "unit": "degC",
        "variable": "Temp_HL",
    },
    "ocean.Temp_LL": {
        "component": "ocean",
        "description": "ocean surface temperature - low latitude",
        "unit": "degC",
        "variable": "Temp_LL",
    },
    "ocean.atm_ocean_flux": {
        "component": "ocean",
        "description": "total atmosphere ocean flux",
        "unit": "Pg C/yr",
        "variable": "atm_ocean_flux",
    },
    "ocean.atm_ocean_flux_HL": {
        "component": "ocean",
        "description": "flux of carbon between the atmosphere and high "
        "latitude surface box",
        "unit": "Pg C/yr",
        "variable": "atm_ocean_flux_HL",
    },
    "ocean.atm_ocean_flux_LL": {
        "component": "ocean",
        "description": "flux of carbon between the "
        "atmosphere and low latitude surface box",
        "unit": "Pg C/yr",
        "variable": "atm_ocean_flux_LL",
    },
    "ocean.carbon_DO": {
        "component": "ocean",
        "description": "carbon pool - deep ocean",
        "unit": "Pg C",
        "variable": "carbon_DO",
    },
    "ocean.carbon_HL": {
        "component": "ocean",
        "description": "carbon pool - high latitude surface ocean",
        "unit": "Pg C",
        "variable": "carbon_HL",
    },
    "ocean.carbon_IO": {
        "component": "ocean",
        "description": "carbon pool - intermediate ocean",
        "unit": "Pg C",
        "variable": "carbon_IO",
    },
    "ocean.carbon_LL": {
        "component": "ocean",
        "description": "carbon pool - low latitude surface ocean",
        "unit": "Pg C",
        "variable": "carbon_LL",
    },
    "ocean.ocean_c": {
        "component": "ocean",
        "description": "total ocean carbon pool",
        "unit": "Pg C",
        "variable": "ocean_c",
    },
    "ocean.ocean_timesteps": {
        "component": "ocean",
        "description": "time step the ocean operates on",
        "unit": "(unitless)",
        "variable": "ocean_timesteps",
    },
    "ocean.pH_HL": {
        "component": "ocean",
        "description": "pH - high latitude",
        "unit": "pH",
        "variable": "pH_HL",
    },
    "ocean.pH_LL": {
        "component": "ocean",
        "description": "pH - low latitude",
        "unit": "pH",
        "variable": "pH_LL",
    },
    "ozone.O3": {
        "component": "ozone",
        "description": "tropospheric ozone concentration",
        "unit": "DU O3",
        "needs_date": True,
        "variable": "O3",
    },
    "simpleNbox.Ca": {
        "component": "simpleNbox",
        "description": "atmospheric CO2 concentration",
        "unit": "ppmv CO2",
        "variable": "Ca",
    },
    "simpleNbox.atm_land_flux": {
        "component": "simpleNbox",
        "description": "flux of carbon between the " "atmosphere and the ocean",
        "unit": "Pg C/yr",
        "variable": "atm_land_flux",
    },
    "simpleNbox.atmos_c": {
        "component": "simpleNbox",
        "description": "total atmospheric carbon pool",
        "unit": "Pg C",
        "variable": "atmos_c",
    },
    "simpleNbox.atmos_c_residual": {
        "component": "simpleNbox",
        "description": "the difference between calculated CO2 and and "
        "prescribed CO2 when running with prescribed CO2 "
        "concentrations",
        "unit": "Pg C",
        "variable": "atmos_c_residual",
    },
    "simpleNbox.detritus_c": {
        "component": "simpleNbox",
        "description": "total detritus carbon pool",
        "unit": "Pg C",
        "variable": "detritus_c",
    },
    "simpleNbox.earth_c": {
        "component": "simpleNbox",
        "description": "total carbon pool - used a mass " "balance check",
        "unit": "Pg C",
        "variable": "earth_c",
    },
    "simpleNbox.npp": {
        "component": "simpleNbox",
        "description": "net primary production (land)",
        "unit": "Pg C/yr",
        "variable": "npp",
    },
    "simpleNbox.rh": {
        "component": "simpleNbox",
        "description": "heterotrophic respiration (land)",
        "unit": "Pg C/yr",
        "variable": "rh",
    },
    "simpleNbox.soil_c": {
        "component": "simpleNbox",
        "description": "total soil carbon pool",
        "unit": "Pg C",
        "variable": "soil_c",
    },
    "simpleNbox.veg_c": {
        "component": "simpleNbox",
        "description": "total vegetation carbon pool",
        "unit": "Pg C",
        "variable": "veg_c",
    },
    "temperature.Tgav": {
        "component": "temperature",
        "description": "global atmospheric temperature anomaly",
        "unit": "degC",
        "variable": "Tgav",
    },
    "temperature.Tgaveq": {
        "component": "temperature",
        "description": "temperature change without accounting " "for ocean heat uptake",
        "unit": "degC",
        "variable": "Tgaveq",
    },
}
