import typing, clr, abc
from System import Attribute, Array_1, ReadOnlySpan_1, Exception, TimeSpan
from System.Reflection import MethodBase

class ConditionalAttribute(Attribute):
    def __init__(self, conditionString: str) -> None: ...
    @property
    def ConditionString(self) -> str: ...
    @property
    def TypeId(self) -> typing.Any: ...


class Debug(abc.ABC):
    @classmethod
    @property
    def AutoFlush(cls) -> bool: ...
    @classmethod
    @AutoFlush.setter
    def AutoFlush(cls, value: bool) -> bool: ...
    @classmethod
    @property
    def IndentLevel(cls) -> int: ...
    @classmethod
    @IndentLevel.setter
    def IndentLevel(cls, value: int) -> int: ...
    @classmethod
    @property
    def IndentSize(cls) -> int: ...
    @classmethod
    @IndentSize.setter
    def IndentSize(cls, value: int) -> int: ...
    @staticmethod
    def Close() -> None: ...
    @staticmethod
    def Flush() -> None: ...
    @staticmethod
    def Indent() -> None: ...
    @staticmethod
    def SetProvider(provider: DebugProvider) -> DebugProvider: ...
    @staticmethod
    def Unindent() -> None: ...
    # Skipped Assert due to it being static, abstract and generic.

    Assert : Assert_MethodGroup
    class Assert_MethodGroup:
        @typing.overload
        def __call__(self, condition: bool) -> None:...
        @typing.overload
        def __call__(self, condition: bool, message: str) -> None:...
        @typing.overload
        def __call__(self, condition: bool, message: clr.Reference[Debug.AssertInterpolatedStringHandler]) -> None:...
        @typing.overload
        def __call__(self, condition: bool, message: str, detailMessage: str) -> None:...
        @typing.overload
        def __call__(self, condition: bool, message: clr.Reference[Debug.AssertInterpolatedStringHandler], detailMessage: clr.Reference[Debug.AssertInterpolatedStringHandler]) -> None:...
        @typing.overload
        def __call__(self, condition: bool, message: str, detailMessageFormat: str, args: Array_1[typing.Any]) -> None:...

    # Skipped Fail due to it being static, abstract and generic.

    Fail : Fail_MethodGroup
    class Fail_MethodGroup:
        @typing.overload
        def __call__(self, message: str) -> None:...
        @typing.overload
        def __call__(self, message: str, detailMessage: str) -> None:...

    # Skipped Print due to it being static, abstract and generic.

    Print : Print_MethodGroup
    class Print_MethodGroup:
        @typing.overload
        def __call__(self, message: str) -> None:...
        @typing.overload
        def __call__(self, format: str, args: Array_1[typing.Any]) -> None:...

    # Skipped Write due to it being static, abstract and generic.

    Write : Write_MethodGroup
    class Write_MethodGroup:
        @typing.overload
        def __call__(self, message: str) -> None:...
        @typing.overload
        def __call__(self, value: typing.Any) -> None:...
        @typing.overload
        def __call__(self, message: str, category: str) -> None:...
        @typing.overload
        def __call__(self, value: typing.Any, category: str) -> None:...

    # Skipped WriteIf due to it being static, abstract and generic.

    WriteIf : WriteIf_MethodGroup
    class WriteIf_MethodGroup:
        @typing.overload
        def __call__(self, condition: bool, message: str) -> None:...
        @typing.overload
        def __call__(self, condition: bool, message: clr.Reference[Debug.WriteIfInterpolatedStringHandler]) -> None:...
        @typing.overload
        def __call__(self, condition: bool, value: typing.Any) -> None:...
        @typing.overload
        def __call__(self, condition: bool, message: str, category: str) -> None:...
        @typing.overload
        def __call__(self, condition: bool, message: clr.Reference[Debug.WriteIfInterpolatedStringHandler], category: str) -> None:...
        @typing.overload
        def __call__(self, condition: bool, value: typing.Any, category: str) -> None:...

    # Skipped WriteLine due to it being static, abstract and generic.

    WriteLine : WriteLine_MethodGroup
    class WriteLine_MethodGroup:
        @typing.overload
        def __call__(self, message: str) -> None:...
        @typing.overload
        def __call__(self, value: typing.Any) -> None:...
        @typing.overload
        def __call__(self, format: str, args: Array_1[typing.Any]) -> None:...
        @typing.overload
        def __call__(self, message: str, category: str) -> None:...
        @typing.overload
        def __call__(self, value: typing.Any, category: str) -> None:...

    # Skipped WriteLineIf due to it being static, abstract and generic.

    WriteLineIf : WriteLineIf_MethodGroup
    class WriteLineIf_MethodGroup:
        @typing.overload
        def __call__(self, condition: bool, message: str) -> None:...
        @typing.overload
        def __call__(self, condition: bool, message: clr.Reference[Debug.WriteIfInterpolatedStringHandler]) -> None:...
        @typing.overload
        def __call__(self, condition: bool, value: typing.Any) -> None:...
        @typing.overload
        def __call__(self, condition: bool, message: str, category: str) -> None:...
        @typing.overload
        def __call__(self, condition: bool, message: clr.Reference[Debug.WriteIfInterpolatedStringHandler], category: str) -> None:...
        @typing.overload
        def __call__(self, condition: bool, value: typing.Any, category: str) -> None:...


    class AssertInterpolatedStringHandler:
        def __init__(self, literalLength: int, formattedCount: int, condition: bool, shouldAppend: clr.Reference[bool]) -> None: ...
        def AppendLiteral(self, value: str) -> None: ...
        # Skipped AppendFormatted due to it being static, abstract and generic.

        AppendFormatted : AppendFormatted_MethodGroup
        class AppendFormatted_MethodGroup:
            def __getitem__(self, t:typing.Type[AppendFormatted_1_T1]) -> AppendFormatted_1[AppendFormatted_1_T1]: ...

            AppendFormatted_1_T1 = typing.TypeVar('AppendFormatted_1_T1')
            class AppendFormatted_1(typing.Generic[AppendFormatted_1_T1]):
                AppendFormatted_1_T = Debug.AssertInterpolatedStringHandler.AppendFormatted_MethodGroup.AppendFormatted_1_T1
                @typing.overload
                def __call__(self, value: AppendFormatted_1_T) -> None:...
                @typing.overload
                def __call__(self, value: AppendFormatted_1_T, alignment: int) -> None:...
                @typing.overload
                def __call__(self, value: AppendFormatted_1_T, format: str) -> None:...
                @typing.overload
                def __call__(self, value: AppendFormatted_1_T, alignment: int, format: str) -> None:...

            @typing.overload
            def __call__(self, value: ReadOnlySpan_1[str]) -> None:...
            @typing.overload
            def __call__(self, value: str) -> None:...
            @typing.overload
            def __call__(self, value: ReadOnlySpan_1[str], alignment: int = ..., format: str = ...) -> None:...
            @typing.overload
            def __call__(self, value: str, alignment: int = ..., format: str = ...) -> None:...
            @typing.overload
            def __call__(self, value: typing.Any, alignment: int = ..., format: str = ...) -> None:...



    class WriteIfInterpolatedStringHandler:
        def __init__(self, literalLength: int, formattedCount: int, condition: bool, shouldAppend: clr.Reference[bool]) -> None: ...
        def AppendLiteral(self, value: str) -> None: ...
        # Skipped AppendFormatted due to it being static, abstract and generic.

        AppendFormatted : AppendFormatted_MethodGroup
        class AppendFormatted_MethodGroup:
            def __getitem__(self, t:typing.Type[AppendFormatted_1_T1]) -> AppendFormatted_1[AppendFormatted_1_T1]: ...

            AppendFormatted_1_T1 = typing.TypeVar('AppendFormatted_1_T1')
            class AppendFormatted_1(typing.Generic[AppendFormatted_1_T1]):
                AppendFormatted_1_T = Debug.WriteIfInterpolatedStringHandler.AppendFormatted_MethodGroup.AppendFormatted_1_T1
                @typing.overload
                def __call__(self, value: AppendFormatted_1_T) -> None:...
                @typing.overload
                def __call__(self, value: AppendFormatted_1_T, alignment: int) -> None:...
                @typing.overload
                def __call__(self, value: AppendFormatted_1_T, format: str) -> None:...
                @typing.overload
                def __call__(self, value: AppendFormatted_1_T, alignment: int, format: str) -> None:...

            @typing.overload
            def __call__(self, value: ReadOnlySpan_1[str]) -> None:...
            @typing.overload
            def __call__(self, value: str) -> None:...
            @typing.overload
            def __call__(self, value: ReadOnlySpan_1[str], alignment: int = ..., format: str = ...) -> None:...
            @typing.overload
            def __call__(self, value: str, alignment: int = ..., format: str = ...) -> None:...
            @typing.overload
            def __call__(self, value: typing.Any, alignment: int = ..., format: str = ...) -> None:...




class DebuggableAttribute(Attribute):
    @typing.overload
    def __init__(self, isJITTrackingEnabled: bool, isJITOptimizerDisabled: bool) -> None: ...
    @typing.overload
    def __init__(self, modes: DebuggableAttribute.DebuggingModes) -> None: ...
    @property
    def DebuggingFlags(self) -> DebuggableAttribute.DebuggingModes: ...
    @property
    def IsJITOptimizerDisabled(self) -> bool: ...
    @property
    def IsJITTrackingEnabled(self) -> bool: ...
    @property
    def TypeId(self) -> typing.Any: ...

    class DebuggingModes(typing.SupportsInt):
        @typing.overload
        def __init__(self, value : int) -> None: ...
        @typing.overload
        def __init__(self, value : int, force_if_true: bool) -> None: ...
        def __int__(self) -> int: ...
        
        # Values:
        None_ : DebuggableAttribute.DebuggingModes # 0
        Default : DebuggableAttribute.DebuggingModes # 1
        IgnoreSymbolStoreSequencePoints : DebuggableAttribute.DebuggingModes # 2
        EnableEditAndContinue : DebuggableAttribute.DebuggingModes # 4
        DisableOptimizations : DebuggableAttribute.DebuggingModes # 256



class Debugger(abc.ABC):
    DefaultCategory : str
    @classmethod
    @property
    def IsAttached(cls) -> bool: ...
    @staticmethod
    def Break() -> None: ...
    @staticmethod
    def IsLogging() -> bool: ...
    @staticmethod
    def Launch() -> bool: ...
    @staticmethod
    def Log(level: int, category: str, message: str) -> None: ...
    @staticmethod
    def NotifyOfCrossThreadDependency() -> None: ...


class DebuggerBrowsableAttribute(Attribute):
    def __init__(self, state: DebuggerBrowsableState) -> None: ...
    @property
    def State(self) -> DebuggerBrowsableState: ...
    @property
    def TypeId(self) -> typing.Any: ...


class DebuggerBrowsableState(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    Never : DebuggerBrowsableState # 0
    Collapsed : DebuggerBrowsableState # 2
    RootHidden : DebuggerBrowsableState # 3


class DebuggerDisplayAttribute(Attribute):
    def __init__(self, value: str) -> None: ...
    @property
    def Name(self) -> str: ...
    @Name.setter
    def Name(self, value: str) -> str: ...
    @property
    def Target(self) -> typing.Type[typing.Any]: ...
    @Target.setter
    def Target(self, value: typing.Type[typing.Any]) -> typing.Type[typing.Any]: ...
    @property
    def TargetTypeName(self) -> str: ...
    @TargetTypeName.setter
    def TargetTypeName(self, value: str) -> str: ...
    @property
    def Type(self) -> str: ...
    @Type.setter
    def Type(self, value: str) -> str: ...
    @property
    def TypeId(self) -> typing.Any: ...
    @property
    def Value(self) -> str: ...


class DebuggerHiddenAttribute(Attribute):
    def __init__(self) -> None: ...
    @property
    def TypeId(self) -> typing.Any: ...


class DebuggerNonUserCodeAttribute(Attribute):
    def __init__(self) -> None: ...
    @property
    def TypeId(self) -> typing.Any: ...


class DebuggerStepperBoundaryAttribute(Attribute):
    def __init__(self) -> None: ...
    @property
    def TypeId(self) -> typing.Any: ...


class DebuggerStepThroughAttribute(Attribute):
    def __init__(self) -> None: ...
    @property
    def TypeId(self) -> typing.Any: ...


class DebuggerTypeProxyAttribute(Attribute):
    @typing.overload
    def __init__(self, type: typing.Type[typing.Any]) -> None: ...
    @typing.overload
    def __init__(self, typeName: str) -> None: ...
    @property
    def ProxyTypeName(self) -> str: ...
    @property
    def Target(self) -> typing.Type[typing.Any]: ...
    @Target.setter
    def Target(self, value: typing.Type[typing.Any]) -> typing.Type[typing.Any]: ...
    @property
    def TargetTypeName(self) -> str: ...
    @TargetTypeName.setter
    def TargetTypeName(self, value: str) -> str: ...
    @property
    def TypeId(self) -> typing.Any: ...


class DebuggerVisualizerAttribute(Attribute):
    @typing.overload
    def __init__(self, visualizer: typing.Type[typing.Any]) -> None: ...
    @typing.overload
    def __init__(self, visualizer: typing.Type[typing.Any], visualizerObjectSource: typing.Type[typing.Any]) -> None: ...
    @typing.overload
    def __init__(self, visualizer: typing.Type[typing.Any], visualizerObjectSourceTypeName: str) -> None: ...
    @typing.overload
    def __init__(self, visualizerTypeName: str) -> None: ...
    @typing.overload
    def __init__(self, visualizerTypeName: str, visualizerObjectSource: typing.Type[typing.Any]) -> None: ...
    @typing.overload
    def __init__(self, visualizerTypeName: str, visualizerObjectSourceTypeName: str) -> None: ...
    @property
    def Description(self) -> str: ...
    @Description.setter
    def Description(self, value: str) -> str: ...
    @property
    def Target(self) -> typing.Type[typing.Any]: ...
    @Target.setter
    def Target(self, value: typing.Type[typing.Any]) -> typing.Type[typing.Any]: ...
    @property
    def TargetTypeName(self) -> str: ...
    @TargetTypeName.setter
    def TargetTypeName(self, value: str) -> str: ...
    @property
    def TypeId(self) -> typing.Any: ...
    @property
    def VisualizerObjectSourceTypeName(self) -> str: ...
    @property
    def VisualizerTypeName(self) -> str: ...


class DebugProvider:
    def __init__(self) -> None: ...
    def Fail(self, message: str, detailMessage: str) -> None: ...
    @staticmethod
    def FailCore(stackTrace: str, message: str, detailMessage: str, errorSource: str) -> None: ...
    def OnIndentLevelChanged(self, indentLevel: int) -> None: ...
    def OnIndentSizeChanged(self, indentSize: int) -> None: ...
    def Write(self, message: str) -> None: ...
    @staticmethod
    def WriteCore(message: str) -> None: ...
    def WriteLine(self, message: str) -> None: ...


class StackFrame:
    # Constructor .ctor(skipFrames : Int32) was skipped since it collides with above method
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, fileName: str, lineNumber: int) -> None: ...
    @typing.overload
    def __init__(self, fileName: str, lineNumber: int, colNumber: int) -> None: ...
    @typing.overload
    def __init__(self, needFileInfo: bool) -> None: ...
    @typing.overload
    def __init__(self, skipFrames: int, needFileInfo: bool) -> None: ...
    OFFSET_UNKNOWN : int
    def GetFileColumnNumber(self) -> int: ...
    def GetFileLineNumber(self) -> int: ...
    def GetFileName(self) -> str: ...
    def GetILOffset(self) -> int: ...
    def GetMethod(self) -> MethodBase: ...
    def GetNativeOffset(self) -> int: ...
    def ToString(self) -> str: ...


class StackFrameExtensions(abc.ABC):
    @staticmethod
    def GetNativeImageBase(stackFrame: StackFrame) -> int: ...
    @staticmethod
    def GetNativeIP(stackFrame: StackFrame) -> int: ...
    @staticmethod
    def HasILOffset(stackFrame: StackFrame) -> bool: ...
    @staticmethod
    def HasMethod(stackFrame: StackFrame) -> bool: ...
    @staticmethod
    def HasNativeImage(stackFrame: StackFrame) -> bool: ...
    @staticmethod
    def HasSource(stackFrame: StackFrame) -> bool: ...


class StackTrace:
    # Constructor .ctor(e : Exception, skipFrames : Int32) was skipped since it collides with above method
    # Constructor .ctor(skipFrames : Int32) was skipped since it collides with above method
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, e: Exception) -> None: ...
    @typing.overload
    def __init__(self, e: Exception, fNeedFileInfo: bool) -> None: ...
    @typing.overload
    def __init__(self, e: Exception, skipFrames: int, fNeedFileInfo: bool) -> None: ...
    @typing.overload
    def __init__(self, fNeedFileInfo: bool) -> None: ...
    @typing.overload
    def __init__(self, frame: StackFrame) -> None: ...
    @typing.overload
    def __init__(self, skipFrames: int, fNeedFileInfo: bool) -> None: ...
    METHODS_TO_SKIP : int
    @property
    def FrameCount(self) -> int: ...
    def GetFrame(self, index: int) -> StackFrame: ...
    def GetFrames(self) -> Array_1[StackFrame]: ...
    def ToString(self) -> str: ...


class StackTraceHiddenAttribute(Attribute):
    def __init__(self) -> None: ...
    @property
    def TypeId(self) -> typing.Any: ...


class Stopwatch:
    def __init__(self) -> None: ...
    Frequency : int
    IsHighResolution : bool
    @property
    def Elapsed(self) -> TimeSpan: ...
    @property
    def ElapsedMilliseconds(self) -> int: ...
    @property
    def ElapsedTicks(self) -> int: ...
    @property
    def IsRunning(self) -> bool: ...
    @staticmethod
    def GetTimestamp() -> int: ...
    def Reset(self) -> None: ...
    def Restart(self) -> None: ...
    def Start(self) -> None: ...
    @staticmethod
    def StartNew() -> Stopwatch: ...
    def Stop(self) -> None: ...

