import typing, clr, abc
from System import IDisposable, SystemException, Exception, Attribute, Array_1
from System.Collections import IEnumerable, IDictionaryEnumerator, IDictionary
from System.Reflection import MethodBase, Assembly
from System.Globalization import CultureInfo
from System.IO import UnmanagedMemoryStream, Stream

class IResourceReader(IDisposable, IEnumerable, typing.Protocol):
    @abc.abstractmethod
    def Close(self) -> None: ...
    @abc.abstractmethod
    def GetEnumerator(self) -> IDictionaryEnumerator: ...


class MissingManifestResourceException(SystemException):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, message: str) -> None: ...
    @typing.overload
    def __init__(self, message: str, inner: Exception) -> None: ...
    @property
    def Data(self) -> IDictionary: ...
    @property
    def HelpLink(self) -> str: ...
    @HelpLink.setter
    def HelpLink(self, value: str) -> str: ...
    @property
    def HResult(self) -> int: ...
    @HResult.setter
    def HResult(self, value: int) -> int: ...
    @property
    def InnerException(self) -> Exception: ...
    @property
    def Message(self) -> str: ...
    @property
    def Source(self) -> str: ...
    @Source.setter
    def Source(self, value: str) -> str: ...
    @property
    def StackTrace(self) -> str: ...
    @property
    def TargetSite(self) -> MethodBase: ...


class MissingSatelliteAssemblyException(SystemException):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, message: str) -> None: ...
    @typing.overload
    def __init__(self, message: str, cultureName: str) -> None: ...
    @typing.overload
    def __init__(self, message: str, inner: Exception) -> None: ...
    @property
    def CultureName(self) -> str: ...
    @property
    def Data(self) -> IDictionary: ...
    @property
    def HelpLink(self) -> str: ...
    @HelpLink.setter
    def HelpLink(self, value: str) -> str: ...
    @property
    def HResult(self) -> int: ...
    @HResult.setter
    def HResult(self, value: int) -> int: ...
    @property
    def InnerException(self) -> Exception: ...
    @property
    def Message(self) -> str: ...
    @property
    def Source(self) -> str: ...
    @Source.setter
    def Source(self, value: str) -> str: ...
    @property
    def StackTrace(self) -> str: ...
    @property
    def TargetSite(self) -> MethodBase: ...


class NeutralResourcesLanguageAttribute(Attribute):
    @typing.overload
    def __init__(self, cultureName: str) -> None: ...
    @typing.overload
    def __init__(self, cultureName: str, location: UltimateResourceFallbackLocation) -> None: ...
    @property
    def CultureName(self) -> str: ...
    @property
    def Location(self) -> UltimateResourceFallbackLocation: ...
    @property
    def TypeId(self) -> typing.Any: ...


class ResourceManager:
    @typing.overload
    def __init__(self, baseName: str, assembly: Assembly) -> None: ...
    @typing.overload
    def __init__(self, baseName: str, assembly: Assembly, usingResourceSet: typing.Type[typing.Any]) -> None: ...
    @typing.overload
    def __init__(self, resourceSource: typing.Type[typing.Any]) -> None: ...
    HeaderVersionNumber : int
    MagicNumber : int
    @property
    def BaseName(self) -> str: ...
    @property
    def IgnoreCase(self) -> bool: ...
    @IgnoreCase.setter
    def IgnoreCase(self, value: bool) -> bool: ...
    @property
    def ResourceSetType(self) -> typing.Type[typing.Any]: ...
    @staticmethod
    def CreateFileBasedResourceManager(baseName: str, resourceDir: str, usingResourceSet: typing.Type[typing.Any]) -> ResourceManager: ...
    def GetResourceSet(self, culture: CultureInfo, createIfNotExists: bool, tryParents: bool) -> ResourceSet: ...
    def ReleaseAllResources(self) -> None: ...
    # Skipped GetObject due to it being static, abstract and generic.

    GetObject : GetObject_MethodGroup
    class GetObject_MethodGroup:
        @typing.overload
        def __call__(self, name: str) -> typing.Any:...
        @typing.overload
        def __call__(self, name: str, culture: CultureInfo) -> typing.Any:...

    # Skipped GetStream due to it being static, abstract and generic.

    GetStream : GetStream_MethodGroup
    class GetStream_MethodGroup:
        @typing.overload
        def __call__(self, name: str) -> UnmanagedMemoryStream:...
        @typing.overload
        def __call__(self, name: str, culture: CultureInfo) -> UnmanagedMemoryStream:...

    # Skipped GetString due to it being static, abstract and generic.

    GetString : GetString_MethodGroup
    class GetString_MethodGroup:
        @typing.overload
        def __call__(self, name: str) -> str:...
        @typing.overload
        def __call__(self, name: str, culture: CultureInfo) -> str:...



class ResourceReader(IResourceReader):
    @typing.overload
    def __init__(self, fileName: str) -> None: ...
    @typing.overload
    def __init__(self, stream: Stream) -> None: ...
    def Close(self) -> None: ...
    def Dispose(self) -> None: ...
    def GetEnumerator(self) -> IDictionaryEnumerator: ...
    def GetResourceData(self, resourceName: str, resourceType: clr.Reference[str], resourceData: clr.Reference[Array_1[int]]) -> None: ...


class ResourceSet(IEnumerable, IDisposable):
    @typing.overload
    def __init__(self, fileName: str) -> None: ...
    @typing.overload
    def __init__(self, reader: IResourceReader) -> None: ...
    @typing.overload
    def __init__(self, stream: Stream) -> None: ...
    def Close(self) -> None: ...
    def Dispose(self) -> None: ...
    def GetDefaultReader(self) -> typing.Type[typing.Any]: ...
    def GetDefaultWriter(self) -> typing.Type[typing.Any]: ...
    def GetEnumerator(self) -> IDictionaryEnumerator: ...
    # Skipped GetObject due to it being static, abstract and generic.

    GetObject : GetObject_MethodGroup
    class GetObject_MethodGroup:
        @typing.overload
        def __call__(self, name: str) -> typing.Any:...
        @typing.overload
        def __call__(self, name: str, ignoreCase: bool) -> typing.Any:...

    # Skipped GetString due to it being static, abstract and generic.

    GetString : GetString_MethodGroup
    class GetString_MethodGroup:
        @typing.overload
        def __call__(self, name: str) -> str:...
        @typing.overload
        def __call__(self, name: str, ignoreCase: bool) -> str:...



class SatelliteContractVersionAttribute(Attribute):
    def __init__(self, version: str) -> None: ...
    @property
    def TypeId(self) -> typing.Any: ...
    @property
    def Version(self) -> str: ...


class UltimateResourceFallbackLocation(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    MainAssembly : UltimateResourceFallbackLocation # 0
    Satellite : UltimateResourceFallbackLocation # 1

