import typing, abc
from System import Func_1, Array_1, Func_2
from System.Collections.Generic import List_1
from System.Numerics import Vector3

class BoolObservation(Observation):
    def __init__(self, parent: Observation, perceive: Func_1[bool], name: str = ...) -> None: ...
    @property
    def Name(self) -> str: ...
    @property
    def ObservationCount(self) -> int: ...
    @property
    def Parent(self) -> Observation: ...
    def Perceive(self, buffer: ObservationBuffer) -> None: ...


class CompositeObservation(Observation):
    @property
    def InnerObservations(self) -> Array_1[Observation]: ...
    @property
    def Name(self) -> str: ...
    @property
    def ObservationCount(self) -> int: ...
    @property
    def Parent(self) -> Observation: ...
    def Perceive(self, buffer: ObservationBuffer) -> None: ...
    def Prepare(self) -> None: ...


class FloatObservation(Observation):
    def __init__(self, parent: Observation, perceive: Func_1[float], name: str = ...) -> None: ...
    @property
    def Name(self) -> str: ...
    @property
    def ObservationCount(self) -> int: ...
    @property
    def Parent(self) -> Observation: ...
    def Perceive(self, buffer: ObservationBuffer) -> None: ...


class Observation(abc.ABC):
    @property
    def Name(self) -> str: ...
    @property
    def ObservationCount(self) -> int: ...
    @property
    def Parent(self) -> Observation: ...
    def GetParentChain(self) -> List_1[Observation]: ...
    def GetPath(self) -> str: ...
    @abc.abstractmethod
    def Perceive(self, buffer: ObservationBuffer) -> None: ...


class ObservationBuffer:
    def __init__(self, size: int) -> None: ...
    Observations : Array_1[float]
    Sources : Array_1[Observation]
    @property
    def Offset(self) -> int: ...
    @Offset.setter
    def Offset(self, value: int) -> int: ...
    def Reset(self) -> None: ...
    def Write(self, source: Observation, f: float) -> None: ...


class OneHotObservation_GenericClasses(abc.ABCMeta):
    Generic_OneHotObservation_GenericClasses_OneHotObservation_1_T = typing.TypeVar('Generic_OneHotObservation_GenericClasses_OneHotObservation_1_T')
    def __getitem__(self, types : typing.Type[Generic_OneHotObservation_GenericClasses_OneHotObservation_1_T]) -> typing.Type[OneHotObservation_1[Generic_OneHotObservation_GenericClasses_OneHotObservation_1_T]]: ...

OneHotObservation : OneHotObservation_GenericClasses

OneHotObservation_1_T = typing.TypeVar('OneHotObservation_1_T')
class OneHotObservation_1(typing.Generic[OneHotObservation_1_T], CompositeObservation):
    def __init__(self, parent: Observation, name: str, perceive: Func_1[OneHotObservation_1_T], options: Array_1[OneHotObservation_1_T], labels: Array_1[str]) -> None: ...
    @property
    def InnerObservations(self) -> Array_1[Observation]: ...
    @property
    def Name(self) -> str: ...
    @property
    def ObservationCount(self) -> int: ...
    @property
    def Parent(self) -> Observation: ...
    def Prepare(self) -> None: ...


class OrBoolObservation(Observation):
    def __init__(self, parent: Observation, count: Func_1[int], perceive: Func_2[int, bool], name: str = ...) -> None: ...
    @property
    def Name(self) -> str: ...
    @property
    def ObservationCount(self) -> int: ...
    @property
    def Parent(self) -> Observation: ...
    def Perceive(self, buffer: ObservationBuffer) -> None: ...


class Vector3Observation(CompositeObservation):
    def __init__(self, parent: Observation, perceive: Func_1[Vector3], name: str = ...) -> None: ...
    @property
    def InnerObservations(self) -> Array_1[Observation]: ...
    @property
    def Name(self) -> str: ...
    @property
    def ObservationCount(self) -> int: ...
    @property
    def Parent(self) -> Observation: ...
    def Prepare(self) -> None: ...

