import typing, abc
from System import MulticastDelegate, IAsyncResult, AsyncCallback, Enum, Array_1, Predicate_1, IEquatable_1
from System.Reflection import MethodInfo
from TransformsAI.Animo.Objects import Character, TypeIds
from TransformsAI.Animo.Simulation.Events import SimulationEvent
from TransformsAI.Animo.Grid import GroundMaterials
from TransformsAI.Animo.Objects.Items import ObjectInfo
from System.Collections.Generic import IReadOnlyList_1, List_1, IEnumerator_1

class ActionInteractions(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    Hold : ActionInteractions # 0
    Pickup : ActionInteractions # 1
    Drop : ActionInteractions # 2
    Destroy : ActionInteractions # 3
    Talk : ActionInteractions # 4
    PickupFail : ActionInteractions # 5
    DropFail : ActionInteractions # 6
    UseFail : ActionInteractions # 7


class CharacterStates(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    None_ : CharacterStates # 0
    Ok : CharacterStates # 1
    InDeepWater : CharacterStates # 2
    Stunned : CharacterStates # 3
    Hypnotized : CharacterStates # 4


class EvaluateFunction(MulticastDelegate):
    def __init__(self, object: typing.Any, method: int) -> None: ...
    @property
    def Method(self) -> MethodInfo: ...
    @property
    def Target(self) -> typing.Any: ...
    def BeginInvoke(self, character: Character, ev: SimulationEvent, targetTypeId: TypeIds, callback: AsyncCallback, object: typing.Any) -> IAsyncResult: ...
    def EndInvoke(self, result: IAsyncResult) -> bool: ...
    def Invoke(self, character: Character, ev: SimulationEvent, targetTypeId: TypeIds) -> bool: ...


class Interaction_GenericClasses(abc.ABCMeta):
    Generic_Interaction_GenericClasses_Interaction_1_T = typing.TypeVar('Generic_Interaction_GenericClasses_Interaction_1_T')
    def __getitem__(self, types : typing.Type[Generic_Interaction_GenericClasses_Interaction_1_T]) -> typing.Type[Interaction_1[Generic_Interaction_GenericClasses_Interaction_1_T]]: ...

class Interaction(Interaction_0, metaclass =Interaction_GenericClasses): ...

class Interaction_0:
    @typing.overload
    def __init__(self, id: Enum, supportedItems: Array_1[TypeIds], targets: Array_1[InteractionTargets]) -> None: ...
    @typing.overload
    def __init__(self, id: Enum, targets: Array_1[InteractionTargets]) -> None: ...
    InteractionEnumType : typing.Type[typing.Any]
    IntId : int
    Targets : Array_1[InteractionTargets]
    @property
    def CanTargetSelfFilter(self) -> bool: ...
    @CanTargetSelfFilter.setter
    def CanTargetSelfFilter(self, value: bool) -> bool: ...
    @property
    def GroundMaterialFilter(self) -> Predicate_1[GroundMaterials]: ...
    @GroundMaterialFilter.setter
    def GroundMaterialFilter(self, value: Predicate_1[GroundMaterials]) -> Predicate_1[GroundMaterials]: ...
    @property
    def HasTarget(self) -> bool: ...
    @property
    def HeightFilter(self) -> Predicate_1[int]: ...
    @HeightFilter.setter
    def HeightFilter(self, value: Predicate_1[int]) -> Predicate_1[int]: ...
    @property
    def ItemFilter(self) -> Predicate_1[ObjectInfo]: ...
    @ItemFilter.setter
    def ItemFilter(self, value: Predicate_1[ObjectInfo]) -> Predicate_1[ObjectInfo]: ...
    @staticmethod
    def AllGroundMaterialFilter(_: GroundMaterials) -> bool: ...
    @staticmethod
    def AllHeightsFilter(_: int) -> bool: ...
    @staticmethod
    def AllItemsFilter(_: ObjectInfo) -> bool: ...
    def ToString(self) -> str: ...


Interaction_1_T = typing.TypeVar('Interaction_1_T')
class Interaction_1(typing.Generic[Interaction_1_T], Interaction_0):
    @typing.overload
    def __init__(self, id: Interaction_1_T, supportedItems: Array_1[TypeIds], targets: Array_1[InteractionTargets]) -> None: ...
    @typing.overload
    def __init__(self, id: Interaction_1_T, targets: Array_1[InteractionTargets]) -> None: ...
    InteractionEnumType : typing.Type[typing.Any]
    IntId : int
    Targets : Array_1[InteractionTargets]
    @property
    def CanTargetSelfFilter(self) -> bool: ...
    @CanTargetSelfFilter.setter
    def CanTargetSelfFilter(self, value: bool) -> bool: ...
    @property
    def GroundMaterialFilter(self) -> Predicate_1[GroundMaterials]: ...
    @GroundMaterialFilter.setter
    def GroundMaterialFilter(self, value: Predicate_1[GroundMaterials]) -> Predicate_1[GroundMaterials]: ...
    @property
    def HasTarget(self) -> bool: ...
    @property
    def HeightFilter(self) -> Predicate_1[int]: ...
    @HeightFilter.setter
    def HeightFilter(self, value: Predicate_1[int]) -> Predicate_1[int]: ...
    @property
    def Id(self) -> Interaction_1_T: ...
    @property
    def ItemFilter(self) -> Predicate_1[ObjectInfo]: ...
    @ItemFilter.setter
    def ItemFilter(self, value: Predicate_1[ObjectInfo]) -> Predicate_1[ObjectInfo]: ...


class InteractionHolder_GenericClasses(abc.ABCMeta):
    Generic_InteractionHolder_GenericClasses_InteractionHolder_1_T = typing.TypeVar('Generic_InteractionHolder_GenericClasses_InteractionHolder_1_T')
    def __getitem__(self, types : typing.Type[Generic_InteractionHolder_GenericClasses_InteractionHolder_1_T]) -> typing.Type[InteractionHolder_1[Generic_InteractionHolder_GenericClasses_InteractionHolder_1_T]]: ...

class InteractionHolder(InteractionHolder_0, metaclass =InteractionHolder_GenericClasses): ...

class InteractionHolder_0(IReadOnlyList_1[Interaction]):
    def __init__(self, interactionEnumType: typing.Type[typing.Any]) -> None: ...
    InteractionEnumType : typing.Type[typing.Any]
    Interactions : List_1[Interaction]
    @property
    def Count(self) -> int: ...
    @property
    def Item(self) -> Interaction: ...
    def Allows(self, value: Interaction) -> bool: ...
    def Contains(self, interaction: Interaction) -> bool: ...
    def GetEnumerator(self) -> IEnumerator_1[Interaction]: ...
    # Skipped Get due to it being static, abstract and generic.

    Get : Get_MethodGroup
    class Get_MethodGroup:
        def __getitem__(self, t:typing.Type[Get_1_T1]) -> Get_1[Get_1_T1]: ...

        Get_1_T1 = typing.TypeVar('Get_1_T1')
        class Get_1(typing.Generic[Get_1_T1]):
            Get_1_TKey = InteractionHolder_0.Get_MethodGroup.Get_1_T1
            def __call__(self, interactionId: Get_1_TKey) -> Interaction:...

        def __call__(self, interactionId: typing.Optional[int]) -> Interaction:...



InteractionHolder_1_T = typing.TypeVar('InteractionHolder_1_T')
class InteractionHolder_1(typing.Generic[InteractionHolder_1_T], InteractionHolder_0):
    def __init__(self) -> None: ...
    InteractionEnumType : typing.Type[typing.Any]
    Interactions : List_1[Interaction]
    @property
    def Count(self) -> int: ...
    @property
    def Item(self) -> Interaction: ...
    def Add(self, interaction: Interaction_1[InteractionHolder_1_T]) -> None: ...
    def Get(self, id: InteractionHolder_1_T) -> Interaction_1[InteractionHolder_1_T]: ...


class Interactions:
    def __init__(self) -> None: ...


class InteractionTargets(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    Anything : InteractionTargets # 0
    Items : InteractionTargets # 1
    GroundTargets : InteractionTargets # 2
    Characters : InteractionTargets # 3
    Block : InteractionTargets # 4
    States : InteractionTargets # 5
    Heights : InteractionTargets # 6
    Nothing : InteractionTargets # 7


class IntrinsicCategories(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    None_ : IntrinsicCategories # 0
    Movement : IntrinsicCategories # 1
    Actions : IntrinsicCategories # 2
    State : IntrinsicCategories # 3


class MovementInteractions(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    MoveTowards : MovementInteractions # 0
    MoveAway : MovementInteractions # 1
    MoveUp : MovementInteractions # 2
    MoveDown : MovementInteractions # 3
    StepOn : MovementInteractions # 4
    StepOff : MovementInteractions # 5
    StandingOn : MovementInteractions # 6
    StandingStill : MovementInteractions # 7
    BeingCloseTo : MovementInteractions # 8
    Facing : MovementInteractions # 9
    MoveFail : MovementInteractions # 10


class NewReward(IEquatable_1[NewReward]):
    @property
    def Interaction(self) -> Interaction: ...
    @Interaction.setter
    def Interaction(self, value: Interaction) -> Interaction: ...
    @property
    def InteractionId(self) -> typing.Optional[int]: ...
    @InteractionId.setter
    def InteractionId(self, value: typing.Optional[int]) -> typing.Optional[int]: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def RewardAmount(self) -> RewardAmounts: ...
    @RewardAmount.setter
    def RewardAmount(self, value: RewardAmounts) -> RewardAmounts: ...
    @property
    def Scale(self) -> int: ...
    @property
    def Source(self) -> RewardSource: ...
    @Source.setter
    def Source(self, value: RewardSource) -> RewardSource: ...
    @property
    def Target(self) -> typing.Optional[RewardTarget]: ...
    @Target.setter
    def Target(self, value: typing.Optional[RewardTarget]) -> typing.Optional[RewardTarget]: ...
    def GetHashCode(self) -> int: ...
    def __eq__(self, left: NewReward, right: NewReward) -> bool: ...
    def __ne__(self, left: NewReward, right: NewReward) -> bool: ...
    def ToString(self) -> str: ...
    # Skipped Equals due to it being static, abstract and generic.

    Equals : Equals_MethodGroup
    class Equals_MethodGroup:
        @typing.overload
        def __call__(self, other: NewReward) -> bool:...
        @typing.overload
        def __call__(self, obj: typing.Any) -> bool:...

    # Skipped Evaluate due to it being static, abstract and generic.

    Evaluate : Evaluate_MethodGroup
    class Evaluate_MethodGroup:
        @typing.overload
        def __call__(self, character: Character) -> bool:...
        @typing.overload
        def __call__(self, character: Character, simEvent: SimulationEvent) -> bool:...



class Reward:
    AllRewards : Array_1[Reward]
    Empty : Reward
    @property
    def DefaultScale(self) -> int: ...
    @DefaultScale.setter
    def DefaultScale(self, value: int) -> int: ...
    @property
    def Description(self) -> str: ...
    @Description.setter
    def Description(self, value: str) -> str: ...
    @property
    def Evaluate(self) -> EvaluateFunction: ...
    @Evaluate.setter
    def Evaluate(self, value: EvaluateFunction) -> EvaluateFunction: ...
    @property
    def Id(self) -> RewardIds: ...
    @Id.setter
    def Id(self, value: RewardIds) -> RewardIds: ...
    @property
    def IsTargetable(self) -> bool: ...
    @property
    def Label(self) -> str: ...
    @Label.setter
    def Label(self, value: str) -> str: ...
    @property
    def TargetFilter(self) -> Predicate_1[ObjectInfo]: ...
    @TargetFilter.setter
    def TargetFilter(self, value: Predicate_1[ObjectInfo]) -> Predicate_1[ObjectInfo]: ...
    @property
    def Tip(self) -> str: ...
    @Tip.setter
    def Tip(self, value: str) -> str: ...
    @staticmethod
    def GetReward(functionId: RewardIds) -> Reward: ...


class RewardAmounts(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    None_ : RewardAmounts # 0
    Plus1 : RewardAmounts # 1
    Plus10 : RewardAmounts # 10
    Plus100 : RewardAmounts # 100
    Minus100 : RewardAmounts # -100
    Minus10 : RewardAmounts # -10
    Minus1 : RewardAmounts # -1


class RewardIds(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    None_ : RewardIds # 0
    GotCloser : RewardIds # 1
    GotFarther : RewardIds # 2
    GotHigher : RewardIds # 3
    GotLower : RewardIds # 4
    FellInDeepWater : RewardIds # 5
    Held : RewardIds # 6
    Used : RewardIds # 7
    DestroyedObject : RewardIds # 8
    DestroyedBlock : RewardIds # 9
    SteppedOnto : RewardIds # 10
    StoodOn : RewardIds # 11
    Collected : RewardIds # 12
    StunnedOther : RewardIds # 13
    IsStunned : RewardIds # 14
    SpendingTime : RewardIds # 15
    Created : RewardIds # 16
    CreatedBlock : RewardIds # 17
    StayedOnSameBlock : RewardIds # 18
    Planted : RewardIds # 19
    Ignited : RewardIds # 20
    HitWithBat : RewardIds # 21
    SprayedWaterOn : RewardIds # 22
    Kicked : RewardIds # 23
    Threw : RewardIds # 24
    HitWithBall : RewardIds # 25
    Hurt : RewardIds # 26
    MoveCloserToOtherAgents : RewardIds # 27
    UseItemOnAgent : RewardIds # 28
    PushFail : RewardIds # 29
    HitWithSnowball : RewardIds # 30


class RewardSource(IEquatable_1[RewardSource]):
    def __init__(self, type: RewardSources, id: int) -> None: ...
    @property
    def CharacterSource(self) -> int: ...
    @property
    def Id(self) -> int: ...
    @property
    def IntrinsicSource(self) -> IntrinsicCategories: ...
    @property
    def ItemSource(self) -> TypeIds: ...
    @property
    def SupportedInteractions(self) -> InteractionHolder: ...
    @property
    def Type(self) -> RewardSources: ...
    @staticmethod
    def Character(characterId: int) -> RewardSource: ...
    def GetHashCode(self) -> int: ...
    @staticmethod
    def Intrinsic(category: IntrinsicCategories) -> RewardSource: ...
    @staticmethod
    def Item(itemId: TypeIds) -> RewardSource: ...
    def __eq__(self, left: RewardSource, right: RewardSource) -> bool: ...
    def __ne__(self, left: RewardSource, right: RewardSource) -> bool: ...
    def Supports(self, interaction: Interaction) -> bool: ...
    def ToString(self) -> str: ...
    # Skipped Equals due to it being static, abstract and generic.

    Equals : Equals_MethodGroup
    class Equals_MethodGroup:
        @typing.overload
        def __call__(self, other: RewardSource) -> bool:...
        @typing.overload
        def __call__(self, obj: typing.Any) -> bool:...



class RewardSources(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    None_ : RewardSources # 0
    Intrinsic : RewardSources # 1
    Item : RewardSources # 2
    Character : RewardSources # 3


class RewardTarget(IEquatable_1[RewardTarget]):
    def __init__(self, type: InteractionTargets, id: int) -> None: ...
    @property
    def CharacterTarget(self) -> int: ...
    @property
    def GroundTarget(self) -> GroundMaterials: ...
    @property
    def HeightTarget(self) -> int: ...
    @property
    def Id(self) -> int: ...
    @property
    def ItemTarget(self) -> TypeIds: ...
    @property
    def StateTarget(self) -> CharacterStates: ...
    @property
    def Type(self) -> InteractionTargets: ...
    @staticmethod
    def Anything() -> RewardTarget: ...
    @staticmethod
    def Block() -> RewardTarget: ...
    @staticmethod
    def Character(characterId: int) -> RewardTarget: ...
    def GetHashCode(self) -> int: ...
    @staticmethod
    def Ground(ground: GroundMaterials) -> RewardTarget: ...
    @staticmethod
    def Height(height: int) -> RewardTarget: ...
    @staticmethod
    def Item(itemId: TypeIds) -> RewardTarget: ...
    @staticmethod
    def Nothing() -> RewardTarget: ...
    def __eq__(self, left: RewardTarget, right: RewardTarget) -> bool: ...
    def __ne__(self, left: RewardTarget, right: RewardTarget) -> bool: ...
    @staticmethod
    def State(state: CharacterStates) -> RewardTarget: ...
    def ToString(self) -> str: ...
    # Skipped Equals due to it being static, abstract and generic.

    Equals : Equals_MethodGroup
    class Equals_MethodGroup:
        @typing.overload
        def __call__(self, other: RewardTarget) -> bool:...
        @typing.overload
        def __call__(self, obj: typing.Any) -> bool:...



class StateInteractions(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    BecomeState : StateInteractions # 0
    BeState : StateInteractions # 1

