import typing, clr
from TransformsAI.Animo.Objects import Item, IAgent, Character, TypeIds
from System import Array_1, Guid
from TransformsAI.Animo.Numerics import Vector3Int
from TransformsAI.Animo.Objects.Items import ObjectInfo, AppleItem
from TransformsAI.Animo.Grid import VoxelGrid, GridObject, GridTransform
from System.Collections.Generic import IReadOnlyList_1, List_1, IEnumerable_1
from TransformsAI.Animo.Simulation.Intents import Intent, CharacterIntent

class DogInteractions(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    Pet : DogInteractions # 0
    Destroy : DogInteractions # 1


class DogItem(Item, IAgent):
    def __init__(self) -> None: ...
    DecisionOverride : Array_1[DogItem.Decision]
    DidWalkFail : bool
    FetchState : DogItem.FetchStates
    ForceMoveTarget : Vector3Int
    ForceMoveWillRun : bool
    Info : ObjectInfo
    IsDecisionOverriden : bool
    OldPosition : Vector3Int
    PetState : DogItem.PetStates
    State : DogItem.States
    @property
    def BeingUsedBy(self) -> Character: ...
    @BeingUsedBy.setter
    def BeingUsedBy(self, value: Character) -> Character: ...
    @property
    def BurnAmount(self) -> int: ...
    @property
    def CanBeOnGrid(self) -> bool: ...
    @property
    def DidStopUsing(self) -> bool: ...
    @DidStopUsing.setter
    def DidStopUsing(self, value: bool) -> bool: ...
    @property
    def Direction(self) -> Vector3Int: ...
    @property
    def Grid(self) -> VoxelGrid: ...
    @property
    def HeldItem(self) -> Item: ...
    @HeldItem.setter
    def HeldItem(self, value: Item) -> Item: ...
    @property
    def Holder(self) -> GridObject: ...
    @Holder.setter
    def Holder(self, value: GridObject) -> GridObject: ...
    @property
    def InstanceId(self) -> Guid: ...
    @property
    def IsBeingHeld(self) -> bool: ...
    @property
    def IsBeingUsed(self) -> bool: ...
    @property
    def IsDestroyed(self) -> bool: ...
    @property
    def IsOnFire(self) -> bool: ...
    @property
    def IsOnGrid(self) -> bool: ...
    @property
    def IsStoodUpon(self) -> bool: ...
    @property
    def LatestDecisions(self) -> IReadOnlyList_1[DogItem.Decision]: ...
    @property
    def PetStage(self) -> int: ...
    @property
    def Position(self) -> Vector3Int: ...
    @property
    def PushedPosition(self) -> typing.Optional[Vector3Int]: ...
    @PushedPosition.setter
    def PushedPosition(self, value: typing.Optional[Vector3Int]) -> typing.Optional[Vector3Int]: ...
    @property
    def Transform(self) -> GridTransform: ...
    @property
    def TransformOnGrid(self) -> typing.Optional[GridTransform]: ...
    @property
    def TypeId(self) -> TypeIds: ...
    @property
    def VariantId(self) -> int: ...
    @VariantId.setter
    def VariantId(self, value: int) -> int: ...
    @property
    def WasUsed(self) -> bool: ...
    @property
    def WasUsedBy(self) -> Character: ...
    @WasUsedBy.setter
    def WasUsedBy(self, value: Character) -> Character: ...
    def CanMoveWhileUsing(self, positionOffset: Vector3Int, positionTarget: Vector3Int) -> bool: ...
    def CanTurnWhileUsing(self, rotationOffset: Vector3Int, rotationTarget: Vector3Int) -> bool: ...
    def ExecuteIntent(self, intent: Intent, toRecalculate: List_1[GridObject]) -> None: ...
    def ForceMove(self, target: Vector3Int, willRun: bool) -> None: ...
    def GetUseIntentGrid(self, user: Character) -> CharacterIntent: ...
    def GrabItem(self) -> bool: ...
    def HandleConflictUse(self, user: Character, intent: CharacterIntent, conflicts: IEnumerable_1[Intent], toRecalculate: List_1[GridObject], willContinueUsing: clr.Reference[bool]) -> None: ...
    def ReleaseItem(self, placeOff: bool) -> bool: ...
    def Reset(self) -> None: ...
    def StartUsing(self, user: Character, intent: CharacterIntent, toRecalculate: List_1[GridObject], willContinueUsing: clr.Reference[bool]) -> None: ...
    def TryStopUsing(self, willForce: bool) -> bool: ...

    class Decision(typing.SupportsInt):
        @typing.overload
        def __init__(self, value : int) -> None: ...
        @typing.overload
        def __init__(self, value : int, force_if_true: bool) -> None: ...
        def __int__(self) -> int: ...
        
        # Values:
        Wait : DogItem.Decision # 0
        MoveForward : DogItem.Decision # 1
        TurnRight : DogItem.Decision # 2
        TurnLeft : DogItem.Decision # 3
        TurnAround : DogItem.Decision # 4
        Grab : DogItem.Decision # 5
        Drop : DogItem.Decision # 6


    class FetchStates(typing.SupportsInt):
        @typing.overload
        def __init__(self, value : int) -> None: ...
        @typing.overload
        def __init__(self, value : int, force_if_true: bool) -> None: ...
        def __int__(self) -> int: ...
        
        # Values:
        GetBall : DogItem.FetchStates # 0
        ReturnBall : DogItem.FetchStates # 1


    class PetStates(typing.SupportsInt):
        @typing.overload
        def __init__(self, value : int) -> None: ...
        @typing.overload
        def __init__(self, value : int, force_if_true: bool) -> None: ...
        def __int__(self) -> int: ...
        
        # Values:
        Wait : DogItem.PetStates # 0
        BeingPet : DogItem.PetStates # 1
        MovingAfterPet : DogItem.PetStates # 2


    class States(typing.SupportsInt):
        @typing.overload
        def __init__(self, value : int) -> None: ...
        @typing.overload
        def __init__(self, value : int, force_if_true: bool) -> None: ...
        def __int__(self) -> int: ...
        
        # Values:
        Stay : DogItem.States # 0
        ForceMove : DogItem.States # 1
        MoveWhenPet : DogItem.States # 2
        Fetch : DogItem.States # 3
        MoveRandomly : DogItem.States # 4



class SalamanderInteractions(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    Pet : SalamanderInteractions # 0
    Feed : SalamanderInteractions # 1
    Destroy : SalamanderInteractions # 2


class SalamanderItem(Item):
    def __init__(self) -> None: ...
    DecisionOverride : SalamanderItem.Decision
    DidSpit : bool
    DidWalkFail : bool
    HasBeenFed : bool
    Info : ObjectInfo
    IsDecisionOverriden : bool
    RemainingSilence : int
    RemainingStun : int
    @property
    def BeingUsedBy(self) -> Character: ...
    @BeingUsedBy.setter
    def BeingUsedBy(self, value: Character) -> Character: ...
    @property
    def BurnAmount(self) -> int: ...
    @property
    def CanBeOnGrid(self) -> bool: ...
    @property
    def DidStopUsing(self) -> bool: ...
    @DidStopUsing.setter
    def DidStopUsing(self, value: bool) -> bool: ...
    @property
    def Direction(self) -> Vector3Int: ...
    @property
    def Grid(self) -> VoxelGrid: ...
    @property
    def Holder(self) -> GridObject: ...
    @Holder.setter
    def Holder(self, value: GridObject) -> GridObject: ...
    @property
    def InstanceId(self) -> Guid: ...
    @property
    def IsBeingHeld(self) -> bool: ...
    @property
    def IsBeingUsed(self) -> bool: ...
    @property
    def IsDestroyed(self) -> bool: ...
    @property
    def IsOnFire(self) -> bool: ...
    @property
    def IsOnGrid(self) -> bool: ...
    @property
    def IsStoodUpon(self) -> bool: ...
    @property
    def Position(self) -> Vector3Int: ...
    @property
    def PushedPosition(self) -> typing.Optional[Vector3Int]: ...
    @PushedPosition.setter
    def PushedPosition(self, value: typing.Optional[Vector3Int]) -> typing.Optional[Vector3Int]: ...
    @property
    def Transform(self) -> GridTransform: ...
    @property
    def TransformOnGrid(self) -> typing.Optional[GridTransform]: ...
    @property
    def TypeId(self) -> TypeIds: ...
    @property
    def VariantId(self) -> int: ...
    @VariantId.setter
    def VariantId(self, value: int) -> int: ...
    @property
    def WasUsed(self) -> bool: ...
    @property
    def WasUsedBy(self) -> Character: ...
    @WasUsedBy.setter
    def WasUsedBy(self, value: Character) -> Character: ...
    def ExecuteIntent(self, intent: Intent, toRecalculate: List_1[GridObject]) -> None: ...
    def Feed(self, source: Character, apple: AppleItem) -> None: ...
    def GetUseIntentGrid(self, user: Character) -> CharacterIntent: ...
    def OnSlashed(self, source: GridObject, causer: Character) -> bool: ...
    def OnSplashed(self, source: GridObject, causer: Character) -> bool: ...
    def Reset(self) -> None: ...
    def Silence(self, source: Character, duration: int) -> None: ...
    def Stun(self, source: Character, duration: int) -> None: ...

    class Decision(typing.SupportsInt):
        @typing.overload
        def __init__(self, value : int) -> None: ...
        @typing.overload
        def __init__(self, value : int, force_if_true: bool) -> None: ...
        def __int__(self) -> int: ...
        
        # Values:
        Wait : SalamanderItem.Decision # 0
        Eat : SalamanderItem.Decision # 1
        Move : SalamanderItem.Decision # 2
        Spit : SalamanderItem.Decision # 3



class SnowPalInteractions(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    Hug : SnowPalInteractions # 0
    Make : SnowPalInteractions # 1
    Damage : SnowPalInteractions # 2
    Destroy : SnowPalInteractions # 3


class SnowPalItem(Item):
    def __init__(self) -> None: ...
    Damage : int
    DamageToDestroy : int
    DecisionOverride : SnowPalItem.Decision
    DidWalkFail : bool
    ForceMoveTarget : Vector3Int
    Info : ObjectInfo
    IsDecisionOverriden : bool
    OldPosition : Vector3Int
    State : SnowPalItem.States
    ThrowRange : int
    WasHit : bool
    @property
    def BeingUsedBy(self) -> Character: ...
    @BeingUsedBy.setter
    def BeingUsedBy(self, value: Character) -> Character: ...
    @property
    def BurnAmount(self) -> int: ...
    @property
    def CanBeOnGrid(self) -> bool: ...
    @property
    def DidStopUsing(self) -> bool: ...
    @DidStopUsing.setter
    def DidStopUsing(self, value: bool) -> bool: ...
    @property
    def Direction(self) -> Vector3Int: ...
    @property
    def Grid(self) -> VoxelGrid: ...
    @property
    def Holder(self) -> GridObject: ...
    @Holder.setter
    def Holder(self, value: GridObject) -> GridObject: ...
    @property
    def InstanceId(self) -> Guid: ...
    @property
    def IsBeingHeld(self) -> bool: ...
    @property
    def IsBeingUsed(self) -> bool: ...
    @property
    def IsDestroyed(self) -> bool: ...
    @property
    def IsOnFire(self) -> bool: ...
    @property
    def IsOnGrid(self) -> bool: ...
    @property
    def IsStoodUpon(self) -> bool: ...
    @property
    def LatestDecision(self) -> SnowPalItem.Decision: ...
    @LatestDecision.setter
    def LatestDecision(self, value: SnowPalItem.Decision) -> SnowPalItem.Decision: ...
    @property
    def Position(self) -> Vector3Int: ...
    @property
    def PushedPosition(self) -> typing.Optional[Vector3Int]: ...
    @PushedPosition.setter
    def PushedPosition(self, value: typing.Optional[Vector3Int]) -> typing.Optional[Vector3Int]: ...
    @property
    def Transform(self) -> GridTransform: ...
    @property
    def TransformOnGrid(self) -> typing.Optional[GridTransform]: ...
    @property
    def TypeId(self) -> TypeIds: ...
    @property
    def VariantId(self) -> int: ...
    @VariantId.setter
    def VariantId(self, value: int) -> int: ...
    @property
    def WasUsed(self) -> bool: ...
    @property
    def WasUsedBy(self) -> Character: ...
    @WasUsedBy.setter
    def WasUsedBy(self, value: Character) -> Character: ...
    def ExecuteIntent(self, intent: Intent, toRecalculate: List_1[GridObject]) -> None: ...
    def ForceMove(self, target: Vector3Int) -> None: ...
    def GetUseIntentGrid(self, user: Character) -> CharacterIntent: ...
    def HandleConflict(self, conflicts: IEnumerable_1[Intent], intent: Intent, toRecalculate: List_1[GridObject]) -> None: ...
    def OnReceiveHit(self, source: GridObject) -> None: ...
    def Reset(self) -> None: ...

    class Decision(typing.SupportsInt):
        @typing.overload
        def __init__(self, value : int) -> None: ...
        @typing.overload
        def __init__(self, value : int, force_if_true: bool) -> None: ...
        def __int__(self) -> int: ...
        
        # Values:
        Wait : SnowPalItem.Decision # 0
        MoveForward : SnowPalItem.Decision # 1
        TurnRight : SnowPalItem.Decision # 2
        TurnLeft : SnowPalItem.Decision # 3
        TurnAround : SnowPalItem.Decision # 4
        ThrowSnowball : SnowPalItem.Decision # 5


    class States(typing.SupportsInt):
        @typing.overload
        def __init__(self, value : int) -> None: ...
        @typing.overload
        def __init__(self, value : int, force_if_true: bool) -> None: ...
        def __int__(self) -> int: ...
        
        # Values:
        Idle : SnowPalItem.States # 0
        Wander : SnowPalItem.States # 1
        Aim : SnowPalItem.States # 2
        Throw : SnowPalItem.States # 3
        ForceMove : SnowPalItem.States # 4
        Asleep : SnowPalItem.States # 5
        Flee : SnowPalItem.States # 6


