import typing, clr, abc
from TransformsAI.Animo.Grid import GridObject, VoxelGrid, GridTransform, GroundMaterials
from TransformsAI.Animo.Objects.Items import ObjectInfo
from System.Collections.Generic import List_1, IEnumerable_1
from TransformsAI.Animo.Learning.Observations import AffinityData, AgentObservations
from TransformsAI.Animo.Numerics import Vector3Int
from System import Guid
from TransformsAI.Animo.Learning.Rewards import CharacterStates
from TransformsAI.Animo.Simulation.Intents import Intent, CharacterIntent

class Character(GridObject, IAgent):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, characterId: int) -> None: ...
    DidDropFail : bool
    DidGrabFail : bool
    DidUseFail : bool
    DidWalkFail : bool
    Info : ObjectInfo
    MaxStepHeight : int
    NextAction : CharacterActions
    @property
    def ActionTaken(self) -> CharacterActions: ...
    @ActionTaken.setter
    def ActionTaken(self, value: CharacterActions) -> CharacterActions: ...
    @property
    def AffinitySlots(self) -> List_1[AffinityData]: ...
    @AffinitySlots.setter
    def AffinitySlots(self, value: List_1[AffinityData]) -> List_1[AffinityData]: ...
    @property
    def CanBeOnGrid(self) -> bool: ...
    @property
    def CharacterId(self) -> int: ...
    @CharacterId.setter
    def CharacterId(self, value: int) -> int: ...
    @property
    def CharacterUsedThisTurn(self) -> Character: ...
    @CharacterUsedThisTurn.setter
    def CharacterUsedThisTurn(self, value: Character) -> Character: ...
    @property
    def Direction(self) -> Vector3Int: ...
    @property
    def Grid(self) -> VoxelGrid: ...
    @property
    def HeldItem(self) -> Item: ...
    @HeldItem.setter
    def HeldItem(self, value: Item) -> Item: ...
    @property
    def InstanceId(self) -> Guid: ...
    @property
    def IsDestroyed(self) -> bool: ...
    @property
    def IsInDeepWater(self) -> bool: ...
    @property
    def IsInShallowWater(self) -> bool: ...
    @property
    def IsOnGrid(self) -> bool: ...
    @property
    def IsStunned(self) -> bool: ...
    @property
    def ItemInUse(self) -> Item: ...
    @ItemInUse.setter
    def ItemInUse(self, value: Item) -> Item: ...
    @property
    def ItemUsedThisTurn(self) -> Item: ...
    @ItemUsedThisTurn.setter
    def ItemUsedThisTurn(self, value: Item) -> Item: ...
    @property
    def Observation(self) -> AgentObservations: ...
    @Observation.setter
    def Observation(self, value: AgentObservations) -> AgentObservations: ...
    @property
    def Position(self) -> Vector3Int: ...
    @property
    def State(self) -> CharacterStates: ...
    @property
    def StepCount(self) -> int: ...
    @StepCount.setter
    def StepCount(self, value: int) -> int: ...
    @property
    def StunDuration(self) -> int: ...
    @StunDuration.setter
    def StunDuration(self, value: int) -> int: ...
    @property
    def Transform(self) -> GridTransform: ...
    @property
    def TransformOnGrid(self) -> typing.Optional[GridTransform]: ...
    @property
    def TypeId(self) -> TypeIds: ...
    @property
    def VariantId(self) -> int: ...
    @VariantId.setter
    def VariantId(self, value: int) -> int: ...
    def Ate(self, item: Item) -> None: ...
    def BouncedOn(self, source: Item, target: GridObject) -> None: ...
    def CalculateIntent(self) -> Intent: ...
    def CausedStateChange(self, other: Character) -> None: ...
    def Collect(self, item: Item) -> None: ...
    def CreateBlockFailed(self) -> None: ...
    def CreatedBlock(self, blockPosition: Vector3Int, materialBeforeCreation: GroundMaterials) -> None: ...
    def Destroy(self) -> None: ...
    def DestroyedBlock(self, blockPosition: Vector3Int) -> None: ...
    def DestroyedObject(self, gridObject: GridObject, position: Vector3Int) -> None: ...
    def DiesIfMovedTo(self, gridPosition: Vector3Int) -> bool: ...
    def DropFailed(self) -> None: ...
    def Dropped(self, gridObject: GridObject) -> None: ...
    def ExecuteIntent(self, intent: Intent, toRecalculate: List_1[GridObject]) -> None: ...
    def Fed(self, other: GridObject) -> None: ...
    def FellInDeepWater(self) -> None: ...
    def GrabItem(self, itemToHold: Item) -> bool: ...
    def HandleConflict(self, conflicts: IEnumerable_1[Intent], intent: Intent, toRecalculate: List_1[GridObject]) -> None: ...
    def HasAffinityFor(self, item: GridObject) -> bool: ...
    def HitWithBat(self, item: GridObject) -> None: ...
    def HitWithSnowball(self, item: GridObject) -> None: ...
    def Hurt(self, gridObject: GridObject) -> None: ...
    def Ignited(self, item: Item) -> None: ...
    def IsTraversable(self, gridPosition: Vector3Int) -> bool: ...
    def Kicked(self, item: Item) -> None: ...
    def MadeGrow(self, target: Item) -> None: ...
    def MovedObject(self, gridObject: GridObject, oldPosition: Vector3Int) -> None: ...
    def MovedSelf(self, oldPosition: Vector3Int) -> None: ...
    def MoveSelfFailed(self) -> None: ...
    def OnSlashed(self, source: GridObject, causer: Character) -> bool: ...
    def OnStepPerformed(self) -> None: ...
    def OnTransformUpdate(self, oldTransform: GridTransform, newTransform: GridTransform) -> None: ...
    def PaintFailed(self, target: Item) -> None: ...
    def PickedUp(self, gridObject: GridObject) -> None: ...
    def PickupFailed(self) -> None: ...
    def Planted(self, item: Item, position: Vector3Int) -> None: ...
    def PushFailed(self, item: Item) -> None: ...
    def ReceiveDamage(self, amount: int, source: GridObject) -> None: ...
    def ReleaseItem(self, placeOff: bool) -> bool: ...
    def Reset(self) -> None: ...
    def Silenced(self, other: GridObject) -> None: ...
    def SprayedWaterOn(self, item: GridObject) -> None: ...
    def StateChanged(self) -> None: ...
    def StayedOnSameBlock(self) -> None: ...
    def Stun(self, source: Character, duration: int) -> None: ...
    def StunnedOther(self, other: GridObject) -> None: ...
    def Threw(self, item: Item) -> None: ...
    def TurnedSelf(self, oldDirection: Vector3Int) -> None: ...
    def TurnPassed(self) -> None: ...
    def UsedCharacter(self, target: Character) -> None: ...
    def UseFailed(self) -> None: ...
    def Wilted(self, target: Item) -> None: ...
    # Skipped CreatedObject due to it being static, abstract and generic.

    CreatedObject : CreatedObject_MethodGroup
    class CreatedObject_MethodGroup:
        @typing.overload
        def __call__(self, gridObject: GridObject) -> None:...
        @typing.overload
        def __call__(self, gridObject: GridObject, position: Vector3Int) -> None:...

    # Skipped HitWithProjectile due to it being static, abstract and generic.

    HitWithProjectile : HitWithProjectile_MethodGroup
    class HitWithProjectile_MethodGroup:
        @typing.overload
        def __call__(self, source: Item, blockPosition: Vector3Int) -> None:...
        @typing.overload
        def __call__(self, source: Item, target: GridObject) -> None:...

    # Skipped Landed due to it being static, abstract and generic.

    Landed : Landed_MethodGroup
    class Landed_MethodGroup:
        @typing.overload
        def __call__(self, source: Item, target: GroundMaterials) -> None:...
        @typing.overload
        def __call__(self, source: Item, target: GridObject) -> None:...

    # Skipped SteppedOff due to it being static, abstract and generic.

    SteppedOff : SteppedOff_MethodGroup
    class SteppedOff_MethodGroup:
        @typing.overload
        def __call__(self, target: GroundMaterials) -> None:...
        @typing.overload
        def __call__(self, obj: GridObject) -> None:...

    # Skipped SteppedOnto due to it being static, abstract and generic.

    SteppedOnto : SteppedOnto_MethodGroup
    class SteppedOnto_MethodGroup:
        @typing.overload
        def __call__(self, target: GroundMaterials) -> None:...
        @typing.overload
        def __call__(self, obj: GridObject) -> None:...

    # Skipped UsedItem due to it being static, abstract and generic.

    UsedItem : UsedItem_MethodGroup
    class UsedItem_MethodGroup:
        @typing.overload
        def __call__(self, item: Item, vectorData: Vector3Int, didTargetBlock: bool = ...) -> None:...
        @typing.overload
        def __call__(self, item: Item, target: GridObject = ..., targetPosition: typing.Optional[Vector3Int] = ...) -> None:...



class CharacterActions(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    Wait : CharacterActions # 0
    Forward : CharacterActions # 1
    TurnRight : CharacterActions # 2
    TurnLeft : CharacterActions # 3
    TurnAround : CharacterActions # 4
    Grab : CharacterActions # 5
    Use : CharacterActions # 6


class CharacterInteractions(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    Hug : CharacterInteractions # 0
    CauseOtherAnimoToBecome : CharacterInteractions # 1


class IAgent(typing.Protocol):
    @property
    def HeldItem(self) -> Item: ...
    @abc.abstractmethod
    def ReleaseItem(self, placeOff: bool) -> bool: ...


class Item(GridObject):
    Info : ObjectInfo
    @property
    def BeingUsedBy(self) -> Character: ...
    @BeingUsedBy.setter
    def BeingUsedBy(self, value: Character) -> Character: ...
    @property
    def BurnAmount(self) -> int: ...
    @BurnAmount.setter
    def BurnAmount(self, value: int) -> int: ...
    @property
    def CanBeOnGrid(self) -> bool: ...
    @property
    def DidStopUsing(self) -> bool: ...
    @DidStopUsing.setter
    def DidStopUsing(self, value: bool) -> bool: ...
    @property
    def Direction(self) -> Vector3Int: ...
    @property
    def Grid(self) -> VoxelGrid: ...
    @property
    def Holder(self) -> GridObject: ...
    @Holder.setter
    def Holder(self, value: GridObject) -> GridObject: ...
    @property
    def InstanceId(self) -> Guid: ...
    @property
    def IsBeingHeld(self) -> bool: ...
    @property
    def IsBeingUsed(self) -> bool: ...
    @property
    def IsDestroyed(self) -> bool: ...
    @property
    def IsOnFire(self) -> bool: ...
    @property
    def IsOnGrid(self) -> bool: ...
    @property
    def IsStoodUpon(self) -> bool: ...
    @property
    def Position(self) -> Vector3Int: ...
    @property
    def PushedPosition(self) -> typing.Optional[Vector3Int]: ...
    @PushedPosition.setter
    def PushedPosition(self, value: typing.Optional[Vector3Int]) -> typing.Optional[Vector3Int]: ...
    @property
    def Transform(self) -> GridTransform: ...
    @property
    def TransformOnGrid(self) -> typing.Optional[GridTransform]: ...
    @property
    def TypeId(self) -> TypeIds: ...
    @property
    def VariantId(self) -> int: ...
    @VariantId.setter
    def VariantId(self, value: int) -> int: ...
    @property
    def WasUsed(self) -> bool: ...
    @property
    def WasUsedBy(self) -> Character: ...
    @WasUsedBy.setter
    def WasUsedBy(self, value: Character) -> Character: ...
    def CalculateIntent(self) -> Intent: ...
    def CanMoveWhileUsing(self, positionOffset: Vector3Int, positionTarget: Vector3Int) -> bool: ...
    def CanTurnWhileUsing(self, rotationOffset: Vector3Int, rotationTarget: Vector3Int) -> bool: ...
    def ContinueUsing(self, toRecalculate: List_1[GridObject]) -> None: ...
    def Destroy(self) -> None: ...
    def ExecuteIntent(self, intent: Intent, toRecalculate: List_1[GridObject]) -> None: ...
    def GetUseIntentGrid(self, user: Character) -> CharacterIntent: ...
    def GetUseIntentHeld(self, user: Character) -> CharacterIntent: ...
    def HandleConflict(self, conflicts: IEnumerable_1[Intent], intent: Intent, toRecalculate: List_1[GridObject]) -> None: ...
    def HandleConflictUse(self, user: Character, intent: CharacterIntent, conflicts: IEnumerable_1[Intent], toRecalculate: List_1[GridObject], willContinueUsing: clr.Reference[bool]) -> None: ...
    def OnBurn(self, source: GridObject, causer: Character) -> bool: ...
    def OnMoveWhileUsing(self, position: Vector3Int) -> None: ...
    def OnSlashed(self, source: GridObject, causer: Character) -> bool: ...
    def OnTurnWhileUsing(self, direction: Vector3Int) -> None: ...
    def Reset(self) -> None: ...
    def StartUsing(self, user: Character, intent: CharacterIntent, toRecalculate: List_1[GridObject], willContinueUsing: clr.Reference[bool]) -> None: ...
    def TryStopUsing(self, willForce: bool) -> bool: ...


class ItemTypes(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    Item : ItemTypes # 0
    Medium : ItemTypes # 1
    NPC : ItemTypes # 2
    Agent : ItemTypes # 3


class Resolution(GridObject):
    def __init__(self, creator: GridObject) -> None: ...
    Info : ObjectInfo
    @property
    def BasePriority(self) -> int: ...
    @property
    def CanBeOnGrid(self) -> bool: ...
    @property
    def Creator(self) -> GridObject: ...
    @Creator.setter
    def Creator(self, value: GridObject) -> GridObject: ...
    @property
    def Direction(self) -> Vector3Int: ...
    @property
    def Grid(self) -> VoxelGrid: ...
    @property
    def InstanceId(self) -> Guid: ...
    @property
    def IsDestroyed(self) -> bool: ...
    @property
    def IsOnGrid(self) -> bool: ...
    @property
    def Position(self) -> Vector3Int: ...
    @property
    def Transform(self) -> GridTransform: ...
    @property
    def TransformOnGrid(self) -> typing.Optional[GridTransform]: ...
    @property
    def TypeId(self) -> TypeIds: ...
    @property
    def VariantId(self) -> int: ...
    @VariantId.setter
    def VariantId(self, value: int) -> int: ...


class TypeIds(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    None_ : TypeIds # 0
    Character : TypeIds # 1
    Axe : TypeIds # 2
    BlockMaker : TypeIds # 3
    FakeAgent : TypeIds # 4
    Flute : TypeIds # 5
    Sprout : TypeIds # 6
    Tree : TypeIds # 7
    AppleTree : TypeIds # 8
    Crystal : TypeIds # 9
    WaterGun : TypeIds # 10
    Apple : TypeIds # 11
    FireGun : TypeIds # 12
    Bat : TypeIds # 13
    Ball : TypeIds # 14
    Flower : TypeIds # 15
    FlowerSeed : TypeIds # 16
    PlantedFlowerSeed : TypeIds # 17
    Fire : TypeIds # 18
    Salamander : TypeIds # 19
    Obstacle : TypeIds # 20
    BounceResolution : TypeIds # 21
    Dog : TypeIds # 22
    NPCObstacle : TypeIds # 23
    LargeSnowball : TypeIds # 24
    SnowPal : TypeIds # 25
    SmallSnowball : TypeIds # 26
    SnowballHeap : TypeIds # 27
    Shovel : TypeIds # 28
    DestructibleObj : TypeIds # 29
    WiltedFlower : TypeIds # 30
    Torch : TypeIds # 31
    PaintRed : TypeIds # 32
    PaintBlue : TypeIds # 33
    PaintBrushRed : TypeIds # 34
    PaintBrushBlue : TypeIds # 35

