import os

from cumulusci.tasks.salesforce import UninstallLocal


class UninstallLocalBundles(UninstallLocal):
    def _run_task(self):
        path = self.options["path"]
        path = os.path.abspath(path)

        self.logger.info(
            "Deleting all metadata from bundles in {} from target org".format(path)
        )

        for item in sorted(os.listdir(path)):
            item_path = os.path.join(path, item)
            if not os.path.isdir(item_path):
                continue

            self.logger.info(
                "Deleting bundle: {}/{}".format(self.options["path"], item)
            )

            self._delete_bundle(item_path)

    def _delete_bundle(self, path=None):
        api = self._get_api(path)
        return api()
