import subprocess
import time


def monitor_and_reconnect(ssid, check_interval=10):
    while True:
        connected = subprocess.call(
            ["ping", "-n", "1", "-w", "1000", "8.8.8.8"],
            stdout=subprocess.DEVNULL, stderr=subprocess.DEVNULL
        ) == 0

        if not connected:
            subprocess.run(["netsh", "wlan", "disconnect"],
                           stdout=subprocess.DEVNULL, stderr=subprocess.DEVNULL)
            time.sleep(2)
            subprocess.run(["netsh", "wlan", "connect", f"name={ssid}"],
                           stdout=subprocess.DEVNULL, stderr=subprocess.DEVNULL)

        time.sleep(check_interval)
