# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CassandraArgs', 'Cassandra']

@pulumi.input_type
class CassandraArgs:
    def __init__(__self__, *,
                 plan: pulumi.Input[str],
                 project: pulumi.Input[str],
                 service_name: pulumi.Input[str],
                 additional_disk_space: Optional[pulumi.Input[str]] = None,
                 cassandra: Optional[pulumi.Input['CassandraCassandraArgs']] = None,
                 cassandra_user_config: Optional[pulumi.Input['CassandraCassandraUserConfigArgs']] = None,
                 cloud_name: Optional[pulumi.Input[str]] = None,
                 disk_space: Optional[pulumi.Input[str]] = None,
                 maintenance_window_dow: Optional[pulumi.Input[str]] = None,
                 maintenance_window_time: Optional[pulumi.Input[str]] = None,
                 project_vpc_id: Optional[pulumi.Input[str]] = None,
                 service_integrations: Optional[pulumi.Input[Sequence[pulumi.Input['CassandraServiceIntegrationArgs']]]] = None,
                 static_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['CassandraTagArgs']]]] = None,
                 tech_emails: Optional[pulumi.Input[Sequence[pulumi.Input['CassandraTechEmailArgs']]]] = None,
                 termination_protection: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a Cassandra resource.
        :param pulumi.Input[str] plan: Defines what kind of computing resources are allocated for the service. It can be changed after creation, though there are some restrictions when going to a smaller plan such as the new plan must have sufficient amount of disk space to store all current data and switching to a plan with fewer nodes might not be supported. The basic plan names are `hobbyist`, `startup-x`, `business-x` and `premium-x` where `x` is (roughly) the amount of memory on each node (also other attributes like number of CPUs and amount of disk space varies but naming is based on memory). The available options can be seen from the [Aiven pricing page](https://aiven.io/pricing).
        :param pulumi.Input[str] project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[str] service_name: Specifies the actual name of the service. The name cannot be changed later without destroying and re-creating the service so name should be picked based on intended service usage rather than current attributes.
        :param pulumi.Input[str] additional_disk_space: Add [disk storage](https://aiven.io/docs/platform/howto/add-storage-space) in increments of 30  GiB to scale your service. The maximum value depends on the service type and cloud provider. Removing additional storage causes the service nodes to go through a rolling restart and there might be a short downtime for services with no HA capabilities.
        :param pulumi.Input['CassandraCassandraArgs'] cassandra: Values provided by the Cassandra server.
        :param pulumi.Input['CassandraCassandraUserConfigArgs'] cassandra_user_config: Cassandra user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[str] cloud_name: Defines where the cloud provider and region where the service is hosted in. This can be changed freely after service is created. Changing the value will trigger a potentially lengthy migration process for the service. Format is cloud provider name (`aws`, `azure`, `do` `google`, `upcloud`, etc.), dash, and the cloud provider specific region name. These are documented on each Cloud provider's own support articles, like [here for Google](https://cloud.google.com/compute/docs/regions-zones/) and [here for AWS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html).
        :param pulumi.Input[str] disk_space: Service disk space. Possible values depend on the service type, the cloud provider and the project. Therefore, reducing will result in the service rebalancing.
        :param pulumi.Input[str] maintenance_window_dow: Day of week when maintenance operations should be performed. One monday, tuesday, wednesday, etc.
        :param pulumi.Input[str] maintenance_window_time: Time of day when maintenance operations should be performed. UTC time in HH:mm:ss format.
        :param pulumi.Input[str] project_vpc_id: Specifies the VPC the service should run in. If the value is not set the service is not run inside a VPC. When set, the value should be given as a reference to set up dependencies correctly and the VPC must be in the same cloud and region as the service itself. Project can be freely moved to and from VPC after creation but doing so triggers migration to new servers so the operation can take significant amount of time to complete if the service has a lot of data.
        :param pulumi.Input[Sequence[pulumi.Input['CassandraServiceIntegrationArgs']]] service_integrations: Service integrations to specify when creating a service. Not applied after initial service creation
        :param pulumi.Input[Sequence[pulumi.Input[str]]] static_ips: Static IPs that are going to be associated with this service. Please assign a value using the 'toset' function. Once a static ip resource is in the 'assigned' state it cannot be unbound from the node again
        :param pulumi.Input[Sequence[pulumi.Input['CassandraTagArgs']]] tags: Tags are key-value pairs that allow you to categorize services.
        :param pulumi.Input[Sequence[pulumi.Input['CassandraTechEmailArgs']]] tech_emails: The email addresses for [service contacts](https://aiven.io/docs/platform/howto/technical-emails), who will receive important alerts and updates about this service. You can also set email contacts at the project level.
        :param pulumi.Input[bool] termination_protection: Prevents the service from being deleted. It is recommended to set this to `true` for all production services to prevent unintentional service deletion. This does not shield against deleting databases or topics but for services with backups much of the content can at least be restored from backup in case accidental deletion is done.
        """
        pulumi.set(__self__, "plan", plan)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "service_name", service_name)
        if additional_disk_space is not None:
            pulumi.set(__self__, "additional_disk_space", additional_disk_space)
        if cassandra is not None:
            pulumi.set(__self__, "cassandra", cassandra)
        if cassandra_user_config is not None:
            pulumi.set(__self__, "cassandra_user_config", cassandra_user_config)
        if cloud_name is not None:
            pulumi.set(__self__, "cloud_name", cloud_name)
        if disk_space is not None:
            warnings.warn("""This will be removed in v5.0.0. Please use `additional_disk_space` to specify the space to be added to the default `disk_space` defined by the plan.""", DeprecationWarning)
            pulumi.log.warn("""disk_space is deprecated: This will be removed in v5.0.0. Please use `additional_disk_space` to specify the space to be added to the default `disk_space` defined by the plan.""")
        if disk_space is not None:
            pulumi.set(__self__, "disk_space", disk_space)
        if maintenance_window_dow is not None:
            pulumi.set(__self__, "maintenance_window_dow", maintenance_window_dow)
        if maintenance_window_time is not None:
            pulumi.set(__self__, "maintenance_window_time", maintenance_window_time)
        if project_vpc_id is not None:
            pulumi.set(__self__, "project_vpc_id", project_vpc_id)
        if service_integrations is not None:
            pulumi.set(__self__, "service_integrations", service_integrations)
        if static_ips is not None:
            pulumi.set(__self__, "static_ips", static_ips)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tech_emails is not None:
            pulumi.set(__self__, "tech_emails", tech_emails)
        if termination_protection is not None:
            pulumi.set(__self__, "termination_protection", termination_protection)

    @property
    @pulumi.getter
    def plan(self) -> pulumi.Input[str]:
        """
        Defines what kind of computing resources are allocated for the service. It can be changed after creation, though there are some restrictions when going to a smaller plan such as the new plan must have sufficient amount of disk space to store all current data and switching to a plan with fewer nodes might not be supported. The basic plan names are `hobbyist`, `startup-x`, `business-x` and `premium-x` where `x` is (roughly) the amount of memory on each node (also other attributes like number of CPUs and amount of disk space varies but naming is based on memory). The available options can be seen from the [Aiven pricing page](https://aiven.io/pricing).
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: pulumi.Input[str]):
        pulumi.set(self, "plan", value)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[str]:
        """
        Specifies the actual name of the service. The name cannot be changed later without destroying and re-creating the service so name should be picked based on intended service usage rather than current attributes.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="additionalDiskSpace")
    def additional_disk_space(self) -> Optional[pulumi.Input[str]]:
        """
        Add [disk storage](https://aiven.io/docs/platform/howto/add-storage-space) in increments of 30  GiB to scale your service. The maximum value depends on the service type and cloud provider. Removing additional storage causes the service nodes to go through a rolling restart and there might be a short downtime for services with no HA capabilities.
        """
        return pulumi.get(self, "additional_disk_space")

    @additional_disk_space.setter
    def additional_disk_space(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "additional_disk_space", value)

    @property
    @pulumi.getter
    def cassandra(self) -> Optional[pulumi.Input['CassandraCassandraArgs']]:
        """
        Values provided by the Cassandra server.
        """
        return pulumi.get(self, "cassandra")

    @cassandra.setter
    def cassandra(self, value: Optional[pulumi.Input['CassandraCassandraArgs']]):
        pulumi.set(self, "cassandra", value)

    @property
    @pulumi.getter(name="cassandraUserConfig")
    def cassandra_user_config(self) -> Optional[pulumi.Input['CassandraCassandraUserConfigArgs']]:
        """
        Cassandra user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "cassandra_user_config")

    @cassandra_user_config.setter
    def cassandra_user_config(self, value: Optional[pulumi.Input['CassandraCassandraUserConfigArgs']]):
        pulumi.set(self, "cassandra_user_config", value)

    @property
    @pulumi.getter(name="cloudName")
    def cloud_name(self) -> Optional[pulumi.Input[str]]:
        """
        Defines where the cloud provider and region where the service is hosted in. This can be changed freely after service is created. Changing the value will trigger a potentially lengthy migration process for the service. Format is cloud provider name (`aws`, `azure`, `do` `google`, `upcloud`, etc.), dash, and the cloud provider specific region name. These are documented on each Cloud provider's own support articles, like [here for Google](https://cloud.google.com/compute/docs/regions-zones/) and [here for AWS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html).
        """
        return pulumi.get(self, "cloud_name")

    @cloud_name.setter
    def cloud_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_name", value)

    @property
    @pulumi.getter(name="diskSpace")
    @_utilities.deprecated("""This will be removed in v5.0.0. Please use `additional_disk_space` to specify the space to be added to the default `disk_space` defined by the plan.""")
    def disk_space(self) -> Optional[pulumi.Input[str]]:
        """
        Service disk space. Possible values depend on the service type, the cloud provider and the project. Therefore, reducing will result in the service rebalancing.
        """
        return pulumi.get(self, "disk_space")

    @disk_space.setter
    def disk_space(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_space", value)

    @property
    @pulumi.getter(name="maintenanceWindowDow")
    def maintenance_window_dow(self) -> Optional[pulumi.Input[str]]:
        """
        Day of week when maintenance operations should be performed. One monday, tuesday, wednesday, etc.
        """
        return pulumi.get(self, "maintenance_window_dow")

    @maintenance_window_dow.setter
    def maintenance_window_dow(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintenance_window_dow", value)

    @property
    @pulumi.getter(name="maintenanceWindowTime")
    def maintenance_window_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time of day when maintenance operations should be performed. UTC time in HH:mm:ss format.
        """
        return pulumi.get(self, "maintenance_window_time")

    @maintenance_window_time.setter
    def maintenance_window_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintenance_window_time", value)

    @property
    @pulumi.getter(name="projectVpcId")
    def project_vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the VPC the service should run in. If the value is not set the service is not run inside a VPC. When set, the value should be given as a reference to set up dependencies correctly and the VPC must be in the same cloud and region as the service itself. Project can be freely moved to and from VPC after creation but doing so triggers migration to new servers so the operation can take significant amount of time to complete if the service has a lot of data.
        """
        return pulumi.get(self, "project_vpc_id")

    @project_vpc_id.setter
    def project_vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_vpc_id", value)

    @property
    @pulumi.getter(name="serviceIntegrations")
    def service_integrations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CassandraServiceIntegrationArgs']]]]:
        """
        Service integrations to specify when creating a service. Not applied after initial service creation
        """
        return pulumi.get(self, "service_integrations")

    @service_integrations.setter
    def service_integrations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CassandraServiceIntegrationArgs']]]]):
        pulumi.set(self, "service_integrations", value)

    @property
    @pulumi.getter(name="staticIps")
    def static_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Static IPs that are going to be associated with this service. Please assign a value using the 'toset' function. Once a static ip resource is in the 'assigned' state it cannot be unbound from the node again
        """
        return pulumi.get(self, "static_ips")

    @static_ips.setter
    def static_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "static_ips", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CassandraTagArgs']]]]:
        """
        Tags are key-value pairs that allow you to categorize services.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CassandraTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="techEmails")
    def tech_emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CassandraTechEmailArgs']]]]:
        """
        The email addresses for [service contacts](https://aiven.io/docs/platform/howto/technical-emails), who will receive important alerts and updates about this service. You can also set email contacts at the project level.
        """
        return pulumi.get(self, "tech_emails")

    @tech_emails.setter
    def tech_emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CassandraTechEmailArgs']]]]):
        pulumi.set(self, "tech_emails", value)

    @property
    @pulumi.getter(name="terminationProtection")
    def termination_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Prevents the service from being deleted. It is recommended to set this to `true` for all production services to prevent unintentional service deletion. This does not shield against deleting databases or topics but for services with backups much of the content can at least be restored from backup in case accidental deletion is done.
        """
        return pulumi.get(self, "termination_protection")

    @termination_protection.setter
    def termination_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "termination_protection", value)


@pulumi.input_type
class _CassandraState:
    def __init__(__self__, *,
                 additional_disk_space: Optional[pulumi.Input[str]] = None,
                 cassandra: Optional[pulumi.Input['CassandraCassandraArgs']] = None,
                 cassandra_user_config: Optional[pulumi.Input['CassandraCassandraUserConfigArgs']] = None,
                 cloud_name: Optional[pulumi.Input[str]] = None,
                 components: Optional[pulumi.Input[Sequence[pulumi.Input['CassandraComponentArgs']]]] = None,
                 disk_space: Optional[pulumi.Input[str]] = None,
                 disk_space_cap: Optional[pulumi.Input[str]] = None,
                 disk_space_default: Optional[pulumi.Input[str]] = None,
                 disk_space_step: Optional[pulumi.Input[str]] = None,
                 disk_space_used: Optional[pulumi.Input[str]] = None,
                 maintenance_window_dow: Optional[pulumi.Input[str]] = None,
                 maintenance_window_time: Optional[pulumi.Input[str]] = None,
                 plan: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 project_vpc_id: Optional[pulumi.Input[str]] = None,
                 service_host: Optional[pulumi.Input[str]] = None,
                 service_integrations: Optional[pulumi.Input[Sequence[pulumi.Input['CassandraServiceIntegrationArgs']]]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 service_password: Optional[pulumi.Input[str]] = None,
                 service_port: Optional[pulumi.Input[int]] = None,
                 service_type: Optional[pulumi.Input[str]] = None,
                 service_uri: Optional[pulumi.Input[str]] = None,
                 service_username: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 static_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['CassandraTagArgs']]]] = None,
                 tech_emails: Optional[pulumi.Input[Sequence[pulumi.Input['CassandraTechEmailArgs']]]] = None,
                 termination_protection: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering Cassandra resources.
        :param pulumi.Input[str] additional_disk_space: Add [disk storage](https://aiven.io/docs/platform/howto/add-storage-space) in increments of 30  GiB to scale your service. The maximum value depends on the service type and cloud provider. Removing additional storage causes the service nodes to go through a rolling restart and there might be a short downtime for services with no HA capabilities.
        :param pulumi.Input['CassandraCassandraArgs'] cassandra: Values provided by the Cassandra server.
        :param pulumi.Input['CassandraCassandraUserConfigArgs'] cassandra_user_config: Cassandra user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[str] cloud_name: Defines where the cloud provider and region where the service is hosted in. This can be changed freely after service is created. Changing the value will trigger a potentially lengthy migration process for the service. Format is cloud provider name (`aws`, `azure`, `do` `google`, `upcloud`, etc.), dash, and the cloud provider specific region name. These are documented on each Cloud provider's own support articles, like [here for Google](https://cloud.google.com/compute/docs/regions-zones/) and [here for AWS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html).
        :param pulumi.Input[Sequence[pulumi.Input['CassandraComponentArgs']]] components: Service component information objects
        :param pulumi.Input[str] disk_space: Service disk space. Possible values depend on the service type, the cloud provider and the project. Therefore, reducing will result in the service rebalancing.
        :param pulumi.Input[str] disk_space_cap: The maximum disk space of the service, possible values depend on the service type, the cloud provider and the project.
        :param pulumi.Input[str] disk_space_default: The default disk space of the service, possible values depend on the service type, the cloud provider and the project. Its also the minimum value for `disk_space`
        :param pulumi.Input[str] disk_space_step: The default disk space step of the service, possible values depend on the service type, the cloud provider and the project. `disk_space` needs to increment from `disk_space_default` by increments of this size.
        :param pulumi.Input[str] disk_space_used: Disk space that service is currently using
        :param pulumi.Input[str] maintenance_window_dow: Day of week when maintenance operations should be performed. One monday, tuesday, wednesday, etc.
        :param pulumi.Input[str] maintenance_window_time: Time of day when maintenance operations should be performed. UTC time in HH:mm:ss format.
        :param pulumi.Input[str] plan: Defines what kind of computing resources are allocated for the service. It can be changed after creation, though there are some restrictions when going to a smaller plan such as the new plan must have sufficient amount of disk space to store all current data and switching to a plan with fewer nodes might not be supported. The basic plan names are `hobbyist`, `startup-x`, `business-x` and `premium-x` where `x` is (roughly) the amount of memory on each node (also other attributes like number of CPUs and amount of disk space varies but naming is based on memory). The available options can be seen from the [Aiven pricing page](https://aiven.io/pricing).
        :param pulumi.Input[str] project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[str] project_vpc_id: Specifies the VPC the service should run in. If the value is not set the service is not run inside a VPC. When set, the value should be given as a reference to set up dependencies correctly and the VPC must be in the same cloud and region as the service itself. Project can be freely moved to and from VPC after creation but doing so triggers migration to new servers so the operation can take significant amount of time to complete if the service has a lot of data.
        :param pulumi.Input[str] service_host: The hostname of the service.
        :param pulumi.Input[Sequence[pulumi.Input['CassandraServiceIntegrationArgs']]] service_integrations: Service integrations to specify when creating a service. Not applied after initial service creation
        :param pulumi.Input[str] service_name: Specifies the actual name of the service. The name cannot be changed later without destroying and re-creating the service so name should be picked based on intended service usage rather than current attributes.
        :param pulumi.Input[str] service_password: Password used for connecting to the service, if applicable
        :param pulumi.Input[int] service_port: The port of the service
        :param pulumi.Input[str] service_type: Aiven internal service type code
        :param pulumi.Input[str] service_uri: URI for connecting to the service. Service specific info is under "kafka", "pg", etc.
        :param pulumi.Input[str] service_username: Username used for connecting to the service, if applicable
        :param pulumi.Input[str] state: Service state. One of `POWEROFF`, `REBALANCING`, `REBUILDING` or `RUNNING`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] static_ips: Static IPs that are going to be associated with this service. Please assign a value using the 'toset' function. Once a static ip resource is in the 'assigned' state it cannot be unbound from the node again
        :param pulumi.Input[Sequence[pulumi.Input['CassandraTagArgs']]] tags: Tags are key-value pairs that allow you to categorize services.
        :param pulumi.Input[Sequence[pulumi.Input['CassandraTechEmailArgs']]] tech_emails: The email addresses for [service contacts](https://aiven.io/docs/platform/howto/technical-emails), who will receive important alerts and updates about this service. You can also set email contacts at the project level.
        :param pulumi.Input[bool] termination_protection: Prevents the service from being deleted. It is recommended to set this to `true` for all production services to prevent unintentional service deletion. This does not shield against deleting databases or topics but for services with backups much of the content can at least be restored from backup in case accidental deletion is done.
        """
        if additional_disk_space is not None:
            pulumi.set(__self__, "additional_disk_space", additional_disk_space)
        if cassandra is not None:
            pulumi.set(__self__, "cassandra", cassandra)
        if cassandra_user_config is not None:
            pulumi.set(__self__, "cassandra_user_config", cassandra_user_config)
        if cloud_name is not None:
            pulumi.set(__self__, "cloud_name", cloud_name)
        if components is not None:
            pulumi.set(__self__, "components", components)
        if disk_space is not None:
            warnings.warn("""This will be removed in v5.0.0. Please use `additional_disk_space` to specify the space to be added to the default `disk_space` defined by the plan.""", DeprecationWarning)
            pulumi.log.warn("""disk_space is deprecated: This will be removed in v5.0.0. Please use `additional_disk_space` to specify the space to be added to the default `disk_space` defined by the plan.""")
        if disk_space is not None:
            pulumi.set(__self__, "disk_space", disk_space)
        if disk_space_cap is not None:
            pulumi.set(__self__, "disk_space_cap", disk_space_cap)
        if disk_space_default is not None:
            pulumi.set(__self__, "disk_space_default", disk_space_default)
        if disk_space_step is not None:
            pulumi.set(__self__, "disk_space_step", disk_space_step)
        if disk_space_used is not None:
            warnings.warn("""This will be removed in v5.0.0. Please use `additional_disk_space` to specify the space to be added to the default `disk_space` defined by the plan.""", DeprecationWarning)
            pulumi.log.warn("""disk_space_used is deprecated: This will be removed in v5.0.0. Please use `additional_disk_space` to specify the space to be added to the default `disk_space` defined by the plan.""")
        if disk_space_used is not None:
            pulumi.set(__self__, "disk_space_used", disk_space_used)
        if maintenance_window_dow is not None:
            pulumi.set(__self__, "maintenance_window_dow", maintenance_window_dow)
        if maintenance_window_time is not None:
            pulumi.set(__self__, "maintenance_window_time", maintenance_window_time)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if project_vpc_id is not None:
            pulumi.set(__self__, "project_vpc_id", project_vpc_id)
        if service_host is not None:
            pulumi.set(__self__, "service_host", service_host)
        if service_integrations is not None:
            pulumi.set(__self__, "service_integrations", service_integrations)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if service_password is not None:
            pulumi.set(__self__, "service_password", service_password)
        if service_port is not None:
            pulumi.set(__self__, "service_port", service_port)
        if service_type is not None:
            pulumi.set(__self__, "service_type", service_type)
        if service_uri is not None:
            pulumi.set(__self__, "service_uri", service_uri)
        if service_username is not None:
            pulumi.set(__self__, "service_username", service_username)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if static_ips is not None:
            pulumi.set(__self__, "static_ips", static_ips)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tech_emails is not None:
            pulumi.set(__self__, "tech_emails", tech_emails)
        if termination_protection is not None:
            pulumi.set(__self__, "termination_protection", termination_protection)

    @property
    @pulumi.getter(name="additionalDiskSpace")
    def additional_disk_space(self) -> Optional[pulumi.Input[str]]:
        """
        Add [disk storage](https://aiven.io/docs/platform/howto/add-storage-space) in increments of 30  GiB to scale your service. The maximum value depends on the service type and cloud provider. Removing additional storage causes the service nodes to go through a rolling restart and there might be a short downtime for services with no HA capabilities.
        """
        return pulumi.get(self, "additional_disk_space")

    @additional_disk_space.setter
    def additional_disk_space(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "additional_disk_space", value)

    @property
    @pulumi.getter
    def cassandra(self) -> Optional[pulumi.Input['CassandraCassandraArgs']]:
        """
        Values provided by the Cassandra server.
        """
        return pulumi.get(self, "cassandra")

    @cassandra.setter
    def cassandra(self, value: Optional[pulumi.Input['CassandraCassandraArgs']]):
        pulumi.set(self, "cassandra", value)

    @property
    @pulumi.getter(name="cassandraUserConfig")
    def cassandra_user_config(self) -> Optional[pulumi.Input['CassandraCassandraUserConfigArgs']]:
        """
        Cassandra user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "cassandra_user_config")

    @cassandra_user_config.setter
    def cassandra_user_config(self, value: Optional[pulumi.Input['CassandraCassandraUserConfigArgs']]):
        pulumi.set(self, "cassandra_user_config", value)

    @property
    @pulumi.getter(name="cloudName")
    def cloud_name(self) -> Optional[pulumi.Input[str]]:
        """
        Defines where the cloud provider and region where the service is hosted in. This can be changed freely after service is created. Changing the value will trigger a potentially lengthy migration process for the service. Format is cloud provider name (`aws`, `azure`, `do` `google`, `upcloud`, etc.), dash, and the cloud provider specific region name. These are documented on each Cloud provider's own support articles, like [here for Google](https://cloud.google.com/compute/docs/regions-zones/) and [here for AWS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html).
        """
        return pulumi.get(self, "cloud_name")

    @cloud_name.setter
    def cloud_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_name", value)

    @property
    @pulumi.getter
    def components(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CassandraComponentArgs']]]]:
        """
        Service component information objects
        """
        return pulumi.get(self, "components")

    @components.setter
    def components(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CassandraComponentArgs']]]]):
        pulumi.set(self, "components", value)

    @property
    @pulumi.getter(name="diskSpace")
    @_utilities.deprecated("""This will be removed in v5.0.0. Please use `additional_disk_space` to specify the space to be added to the default `disk_space` defined by the plan.""")
    def disk_space(self) -> Optional[pulumi.Input[str]]:
        """
        Service disk space. Possible values depend on the service type, the cloud provider and the project. Therefore, reducing will result in the service rebalancing.
        """
        return pulumi.get(self, "disk_space")

    @disk_space.setter
    def disk_space(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_space", value)

    @property
    @pulumi.getter(name="diskSpaceCap")
    def disk_space_cap(self) -> Optional[pulumi.Input[str]]:
        """
        The maximum disk space of the service, possible values depend on the service type, the cloud provider and the project.
        """
        return pulumi.get(self, "disk_space_cap")

    @disk_space_cap.setter
    def disk_space_cap(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_space_cap", value)

    @property
    @pulumi.getter(name="diskSpaceDefault")
    def disk_space_default(self) -> Optional[pulumi.Input[str]]:
        """
        The default disk space of the service, possible values depend on the service type, the cloud provider and the project. Its also the minimum value for `disk_space`
        """
        return pulumi.get(self, "disk_space_default")

    @disk_space_default.setter
    def disk_space_default(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_space_default", value)

    @property
    @pulumi.getter(name="diskSpaceStep")
    def disk_space_step(self) -> Optional[pulumi.Input[str]]:
        """
        The default disk space step of the service, possible values depend on the service type, the cloud provider and the project. `disk_space` needs to increment from `disk_space_default` by increments of this size.
        """
        return pulumi.get(self, "disk_space_step")

    @disk_space_step.setter
    def disk_space_step(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_space_step", value)

    @property
    @pulumi.getter(name="diskSpaceUsed")
    @_utilities.deprecated("""This will be removed in v5.0.0. Please use `additional_disk_space` to specify the space to be added to the default `disk_space` defined by the plan.""")
    def disk_space_used(self) -> Optional[pulumi.Input[str]]:
        """
        Disk space that service is currently using
        """
        return pulumi.get(self, "disk_space_used")

    @disk_space_used.setter
    def disk_space_used(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_space_used", value)

    @property
    @pulumi.getter(name="maintenanceWindowDow")
    def maintenance_window_dow(self) -> Optional[pulumi.Input[str]]:
        """
        Day of week when maintenance operations should be performed. One monday, tuesday, wednesday, etc.
        """
        return pulumi.get(self, "maintenance_window_dow")

    @maintenance_window_dow.setter
    def maintenance_window_dow(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintenance_window_dow", value)

    @property
    @pulumi.getter(name="maintenanceWindowTime")
    def maintenance_window_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time of day when maintenance operations should be performed. UTC time in HH:mm:ss format.
        """
        return pulumi.get(self, "maintenance_window_time")

    @maintenance_window_time.setter
    def maintenance_window_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintenance_window_time", value)

    @property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input[str]]:
        """
        Defines what kind of computing resources are allocated for the service. It can be changed after creation, though there are some restrictions when going to a smaller plan such as the new plan must have sufficient amount of disk space to store all current data and switching to a plan with fewer nodes might not be supported. The basic plan names are `hobbyist`, `startup-x`, `business-x` and `premium-x` where `x` is (roughly) the amount of memory on each node (also other attributes like number of CPUs and amount of disk space varies but naming is based on memory). The available options can be seen from the [Aiven pricing page](https://aiven.io/pricing).
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plan", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="projectVpcId")
    def project_vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the VPC the service should run in. If the value is not set the service is not run inside a VPC. When set, the value should be given as a reference to set up dependencies correctly and the VPC must be in the same cloud and region as the service itself. Project can be freely moved to and from VPC after creation but doing so triggers migration to new servers so the operation can take significant amount of time to complete if the service has a lot of data.
        """
        return pulumi.get(self, "project_vpc_id")

    @project_vpc_id.setter
    def project_vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_vpc_id", value)

    @property
    @pulumi.getter(name="serviceHost")
    def service_host(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname of the service.
        """
        return pulumi.get(self, "service_host")

    @service_host.setter
    def service_host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_host", value)

    @property
    @pulumi.getter(name="serviceIntegrations")
    def service_integrations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CassandraServiceIntegrationArgs']]]]:
        """
        Service integrations to specify when creating a service. Not applied after initial service creation
        """
        return pulumi.get(self, "service_integrations")

    @service_integrations.setter
    def service_integrations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CassandraServiceIntegrationArgs']]]]):
        pulumi.set(self, "service_integrations", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the actual name of the service. The name cannot be changed later without destroying and re-creating the service so name should be picked based on intended service usage rather than current attributes.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="servicePassword")
    def service_password(self) -> Optional[pulumi.Input[str]]:
        """
        Password used for connecting to the service, if applicable
        """
        return pulumi.get(self, "service_password")

    @service_password.setter
    def service_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_password", value)

    @property
    @pulumi.getter(name="servicePort")
    def service_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port of the service
        """
        return pulumi.get(self, "service_port")

    @service_port.setter
    def service_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "service_port", value)

    @property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> Optional[pulumi.Input[str]]:
        """
        Aiven internal service type code
        """
        return pulumi.get(self, "service_type")

    @service_type.setter
    def service_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_type", value)

    @property
    @pulumi.getter(name="serviceUri")
    def service_uri(self) -> Optional[pulumi.Input[str]]:
        """
        URI for connecting to the service. Service specific info is under "kafka", "pg", etc.
        """
        return pulumi.get(self, "service_uri")

    @service_uri.setter
    def service_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_uri", value)

    @property
    @pulumi.getter(name="serviceUsername")
    def service_username(self) -> Optional[pulumi.Input[str]]:
        """
        Username used for connecting to the service, if applicable
        """
        return pulumi.get(self, "service_username")

    @service_username.setter
    def service_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_username", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        Service state. One of `POWEROFF`, `REBALANCING`, `REBUILDING` or `RUNNING`
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="staticIps")
    def static_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Static IPs that are going to be associated with this service. Please assign a value using the 'toset' function. Once a static ip resource is in the 'assigned' state it cannot be unbound from the node again
        """
        return pulumi.get(self, "static_ips")

    @static_ips.setter
    def static_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "static_ips", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CassandraTagArgs']]]]:
        """
        Tags are key-value pairs that allow you to categorize services.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CassandraTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="techEmails")
    def tech_emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CassandraTechEmailArgs']]]]:
        """
        The email addresses for [service contacts](https://aiven.io/docs/platform/howto/technical-emails), who will receive important alerts and updates about this service. You can also set email contacts at the project level.
        """
        return pulumi.get(self, "tech_emails")

    @tech_emails.setter
    def tech_emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CassandraTechEmailArgs']]]]):
        pulumi.set(self, "tech_emails", value)

    @property
    @pulumi.getter(name="terminationProtection")
    def termination_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Prevents the service from being deleted. It is recommended to set this to `true` for all production services to prevent unintentional service deletion. This does not shield against deleting databases or topics but for services with backups much of the content can at least be restored from backup in case accidental deletion is done.
        """
        return pulumi.get(self, "termination_protection")

    @termination_protection.setter
    def termination_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "termination_protection", value)


class Cassandra(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_disk_space: Optional[pulumi.Input[str]] = None,
                 cassandra: Optional[pulumi.Input[Union['CassandraCassandraArgs', 'CassandraCassandraArgsDict']]] = None,
                 cassandra_user_config: Optional[pulumi.Input[Union['CassandraCassandraUserConfigArgs', 'CassandraCassandraUserConfigArgsDict']]] = None,
                 cloud_name: Optional[pulumi.Input[str]] = None,
                 disk_space: Optional[pulumi.Input[str]] = None,
                 maintenance_window_dow: Optional[pulumi.Input[str]] = None,
                 maintenance_window_time: Optional[pulumi.Input[str]] = None,
                 plan: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 project_vpc_id: Optional[pulumi.Input[str]] = None,
                 service_integrations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CassandraServiceIntegrationArgs', 'CassandraServiceIntegrationArgsDict']]]]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 static_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CassandraTagArgs', 'CassandraTagArgsDict']]]]] = None,
                 tech_emails: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CassandraTechEmailArgs', 'CassandraTechEmailArgsDict']]]]] = None,
                 termination_protection: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Creates and manages an [Aiven for Apache Cassandra®](https://aiven.io/docs/products/cassandra) service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        example_cassandra = aiven.Cassandra("example_cassandra",
            project=example_project["project"],
            cloud_name="google-europe-west1",
            plan="startup-4",
            service_name="example-cassandra-service",
            maintenance_window_dow="monday",
            maintenance_window_time="10:00:00",
            cassandra_user_config={
                "migrate_sstableloader": True,
                "public_access": {
                    "prometheus": True,
                },
            })
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/cassandra:Cassandra example_cassandra PROJECT/SERVICE_NAME
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] additional_disk_space: Add [disk storage](https://aiven.io/docs/platform/howto/add-storage-space) in increments of 30  GiB to scale your service. The maximum value depends on the service type and cloud provider. Removing additional storage causes the service nodes to go through a rolling restart and there might be a short downtime for services with no HA capabilities.
        :param pulumi.Input[Union['CassandraCassandraArgs', 'CassandraCassandraArgsDict']] cassandra: Values provided by the Cassandra server.
        :param pulumi.Input[Union['CassandraCassandraUserConfigArgs', 'CassandraCassandraUserConfigArgsDict']] cassandra_user_config: Cassandra user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[str] cloud_name: Defines where the cloud provider and region where the service is hosted in. This can be changed freely after service is created. Changing the value will trigger a potentially lengthy migration process for the service. Format is cloud provider name (`aws`, `azure`, `do` `google`, `upcloud`, etc.), dash, and the cloud provider specific region name. These are documented on each Cloud provider's own support articles, like [here for Google](https://cloud.google.com/compute/docs/regions-zones/) and [here for AWS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html).
        :param pulumi.Input[str] disk_space: Service disk space. Possible values depend on the service type, the cloud provider and the project. Therefore, reducing will result in the service rebalancing.
        :param pulumi.Input[str] maintenance_window_dow: Day of week when maintenance operations should be performed. One monday, tuesday, wednesday, etc.
        :param pulumi.Input[str] maintenance_window_time: Time of day when maintenance operations should be performed. UTC time in HH:mm:ss format.
        :param pulumi.Input[str] plan: Defines what kind of computing resources are allocated for the service. It can be changed after creation, though there are some restrictions when going to a smaller plan such as the new plan must have sufficient amount of disk space to store all current data and switching to a plan with fewer nodes might not be supported. The basic plan names are `hobbyist`, `startup-x`, `business-x` and `premium-x` where `x` is (roughly) the amount of memory on each node (also other attributes like number of CPUs and amount of disk space varies but naming is based on memory). The available options can be seen from the [Aiven pricing page](https://aiven.io/pricing).
        :param pulumi.Input[str] project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[str] project_vpc_id: Specifies the VPC the service should run in. If the value is not set the service is not run inside a VPC. When set, the value should be given as a reference to set up dependencies correctly and the VPC must be in the same cloud and region as the service itself. Project can be freely moved to and from VPC after creation but doing so triggers migration to new servers so the operation can take significant amount of time to complete if the service has a lot of data.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CassandraServiceIntegrationArgs', 'CassandraServiceIntegrationArgsDict']]]] service_integrations: Service integrations to specify when creating a service. Not applied after initial service creation
        :param pulumi.Input[str] service_name: Specifies the actual name of the service. The name cannot be changed later without destroying and re-creating the service so name should be picked based on intended service usage rather than current attributes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] static_ips: Static IPs that are going to be associated with this service. Please assign a value using the 'toset' function. Once a static ip resource is in the 'assigned' state it cannot be unbound from the node again
        :param pulumi.Input[Sequence[pulumi.Input[Union['CassandraTagArgs', 'CassandraTagArgsDict']]]] tags: Tags are key-value pairs that allow you to categorize services.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CassandraTechEmailArgs', 'CassandraTechEmailArgsDict']]]] tech_emails: The email addresses for [service contacts](https://aiven.io/docs/platform/howto/technical-emails), who will receive important alerts and updates about this service. You can also set email contacts at the project level.
        :param pulumi.Input[bool] termination_protection: Prevents the service from being deleted. It is recommended to set this to `true` for all production services to prevent unintentional service deletion. This does not shield against deleting databases or topics but for services with backups much of the content can at least be restored from backup in case accidental deletion is done.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CassandraArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages an [Aiven for Apache Cassandra®](https://aiven.io/docs/products/cassandra) service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        example_cassandra = aiven.Cassandra("example_cassandra",
            project=example_project["project"],
            cloud_name="google-europe-west1",
            plan="startup-4",
            service_name="example-cassandra-service",
            maintenance_window_dow="monday",
            maintenance_window_time="10:00:00",
            cassandra_user_config={
                "migrate_sstableloader": True,
                "public_access": {
                    "prometheus": True,
                },
            })
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/cassandra:Cassandra example_cassandra PROJECT/SERVICE_NAME
        ```

        :param str resource_name: The name of the resource.
        :param CassandraArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CassandraArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_disk_space: Optional[pulumi.Input[str]] = None,
                 cassandra: Optional[pulumi.Input[Union['CassandraCassandraArgs', 'CassandraCassandraArgsDict']]] = None,
                 cassandra_user_config: Optional[pulumi.Input[Union['CassandraCassandraUserConfigArgs', 'CassandraCassandraUserConfigArgsDict']]] = None,
                 cloud_name: Optional[pulumi.Input[str]] = None,
                 disk_space: Optional[pulumi.Input[str]] = None,
                 maintenance_window_dow: Optional[pulumi.Input[str]] = None,
                 maintenance_window_time: Optional[pulumi.Input[str]] = None,
                 plan: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 project_vpc_id: Optional[pulumi.Input[str]] = None,
                 service_integrations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CassandraServiceIntegrationArgs', 'CassandraServiceIntegrationArgsDict']]]]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 static_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CassandraTagArgs', 'CassandraTagArgsDict']]]]] = None,
                 tech_emails: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CassandraTechEmailArgs', 'CassandraTechEmailArgsDict']]]]] = None,
                 termination_protection: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CassandraArgs.__new__(CassandraArgs)

            __props__.__dict__["additional_disk_space"] = additional_disk_space
            __props__.__dict__["cassandra"] = None if cassandra is None else pulumi.Output.secret(cassandra)
            __props__.__dict__["cassandra_user_config"] = cassandra_user_config
            __props__.__dict__["cloud_name"] = cloud_name
            __props__.__dict__["disk_space"] = disk_space
            __props__.__dict__["maintenance_window_dow"] = maintenance_window_dow
            __props__.__dict__["maintenance_window_time"] = maintenance_window_time
            if plan is None and not opts.urn:
                raise TypeError("Missing required property 'plan'")
            __props__.__dict__["plan"] = plan
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["project_vpc_id"] = project_vpc_id
            __props__.__dict__["service_integrations"] = service_integrations
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["static_ips"] = static_ips
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tech_emails"] = tech_emails
            __props__.__dict__["termination_protection"] = termination_protection
            __props__.__dict__["components"] = None
            __props__.__dict__["disk_space_cap"] = None
            __props__.__dict__["disk_space_default"] = None
            __props__.__dict__["disk_space_step"] = None
            __props__.__dict__["disk_space_used"] = None
            __props__.__dict__["service_host"] = None
            __props__.__dict__["service_password"] = None
            __props__.__dict__["service_port"] = None
            __props__.__dict__["service_type"] = None
            __props__.__dict__["service_uri"] = None
            __props__.__dict__["service_username"] = None
            __props__.__dict__["state"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["cassandra", "servicePassword", "serviceUri"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Cassandra, __self__).__init__(
            'aiven:index/cassandra:Cassandra',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_disk_space: Optional[pulumi.Input[str]] = None,
            cassandra: Optional[pulumi.Input[Union['CassandraCassandraArgs', 'CassandraCassandraArgsDict']]] = None,
            cassandra_user_config: Optional[pulumi.Input[Union['CassandraCassandraUserConfigArgs', 'CassandraCassandraUserConfigArgsDict']]] = None,
            cloud_name: Optional[pulumi.Input[str]] = None,
            components: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CassandraComponentArgs', 'CassandraComponentArgsDict']]]]] = None,
            disk_space: Optional[pulumi.Input[str]] = None,
            disk_space_cap: Optional[pulumi.Input[str]] = None,
            disk_space_default: Optional[pulumi.Input[str]] = None,
            disk_space_step: Optional[pulumi.Input[str]] = None,
            disk_space_used: Optional[pulumi.Input[str]] = None,
            maintenance_window_dow: Optional[pulumi.Input[str]] = None,
            maintenance_window_time: Optional[pulumi.Input[str]] = None,
            plan: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            project_vpc_id: Optional[pulumi.Input[str]] = None,
            service_host: Optional[pulumi.Input[str]] = None,
            service_integrations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CassandraServiceIntegrationArgs', 'CassandraServiceIntegrationArgsDict']]]]] = None,
            service_name: Optional[pulumi.Input[str]] = None,
            service_password: Optional[pulumi.Input[str]] = None,
            service_port: Optional[pulumi.Input[int]] = None,
            service_type: Optional[pulumi.Input[str]] = None,
            service_uri: Optional[pulumi.Input[str]] = None,
            service_username: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            static_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CassandraTagArgs', 'CassandraTagArgsDict']]]]] = None,
            tech_emails: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CassandraTechEmailArgs', 'CassandraTechEmailArgsDict']]]]] = None,
            termination_protection: Optional[pulumi.Input[bool]] = None) -> 'Cassandra':
        """
        Get an existing Cassandra resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] additional_disk_space: Add [disk storage](https://aiven.io/docs/platform/howto/add-storage-space) in increments of 30  GiB to scale your service. The maximum value depends on the service type and cloud provider. Removing additional storage causes the service nodes to go through a rolling restart and there might be a short downtime for services with no HA capabilities.
        :param pulumi.Input[Union['CassandraCassandraArgs', 'CassandraCassandraArgsDict']] cassandra: Values provided by the Cassandra server.
        :param pulumi.Input[Union['CassandraCassandraUserConfigArgs', 'CassandraCassandraUserConfigArgsDict']] cassandra_user_config: Cassandra user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[str] cloud_name: Defines where the cloud provider and region where the service is hosted in. This can be changed freely after service is created. Changing the value will trigger a potentially lengthy migration process for the service. Format is cloud provider name (`aws`, `azure`, `do` `google`, `upcloud`, etc.), dash, and the cloud provider specific region name. These are documented on each Cloud provider's own support articles, like [here for Google](https://cloud.google.com/compute/docs/regions-zones/) and [here for AWS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html).
        :param pulumi.Input[Sequence[pulumi.Input[Union['CassandraComponentArgs', 'CassandraComponentArgsDict']]]] components: Service component information objects
        :param pulumi.Input[str] disk_space: Service disk space. Possible values depend on the service type, the cloud provider and the project. Therefore, reducing will result in the service rebalancing.
        :param pulumi.Input[str] disk_space_cap: The maximum disk space of the service, possible values depend on the service type, the cloud provider and the project.
        :param pulumi.Input[str] disk_space_default: The default disk space of the service, possible values depend on the service type, the cloud provider and the project. Its also the minimum value for `disk_space`
        :param pulumi.Input[str] disk_space_step: The default disk space step of the service, possible values depend on the service type, the cloud provider and the project. `disk_space` needs to increment from `disk_space_default` by increments of this size.
        :param pulumi.Input[str] disk_space_used: Disk space that service is currently using
        :param pulumi.Input[str] maintenance_window_dow: Day of week when maintenance operations should be performed. One monday, tuesday, wednesday, etc.
        :param pulumi.Input[str] maintenance_window_time: Time of day when maintenance operations should be performed. UTC time in HH:mm:ss format.
        :param pulumi.Input[str] plan: Defines what kind of computing resources are allocated for the service. It can be changed after creation, though there are some restrictions when going to a smaller plan such as the new plan must have sufficient amount of disk space to store all current data and switching to a plan with fewer nodes might not be supported. The basic plan names are `hobbyist`, `startup-x`, `business-x` and `premium-x` where `x` is (roughly) the amount of memory on each node (also other attributes like number of CPUs and amount of disk space varies but naming is based on memory). The available options can be seen from the [Aiven pricing page](https://aiven.io/pricing).
        :param pulumi.Input[str] project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[str] project_vpc_id: Specifies the VPC the service should run in. If the value is not set the service is not run inside a VPC. When set, the value should be given as a reference to set up dependencies correctly and the VPC must be in the same cloud and region as the service itself. Project can be freely moved to and from VPC after creation but doing so triggers migration to new servers so the operation can take significant amount of time to complete if the service has a lot of data.
        :param pulumi.Input[str] service_host: The hostname of the service.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CassandraServiceIntegrationArgs', 'CassandraServiceIntegrationArgsDict']]]] service_integrations: Service integrations to specify when creating a service. Not applied after initial service creation
        :param pulumi.Input[str] service_name: Specifies the actual name of the service. The name cannot be changed later without destroying and re-creating the service so name should be picked based on intended service usage rather than current attributes.
        :param pulumi.Input[str] service_password: Password used for connecting to the service, if applicable
        :param pulumi.Input[int] service_port: The port of the service
        :param pulumi.Input[str] service_type: Aiven internal service type code
        :param pulumi.Input[str] service_uri: URI for connecting to the service. Service specific info is under "kafka", "pg", etc.
        :param pulumi.Input[str] service_username: Username used for connecting to the service, if applicable
        :param pulumi.Input[str] state: Service state. One of `POWEROFF`, `REBALANCING`, `REBUILDING` or `RUNNING`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] static_ips: Static IPs that are going to be associated with this service. Please assign a value using the 'toset' function. Once a static ip resource is in the 'assigned' state it cannot be unbound from the node again
        :param pulumi.Input[Sequence[pulumi.Input[Union['CassandraTagArgs', 'CassandraTagArgsDict']]]] tags: Tags are key-value pairs that allow you to categorize services.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CassandraTechEmailArgs', 'CassandraTechEmailArgsDict']]]] tech_emails: The email addresses for [service contacts](https://aiven.io/docs/platform/howto/technical-emails), who will receive important alerts and updates about this service. You can also set email contacts at the project level.
        :param pulumi.Input[bool] termination_protection: Prevents the service from being deleted. It is recommended to set this to `true` for all production services to prevent unintentional service deletion. This does not shield against deleting databases or topics but for services with backups much of the content can at least be restored from backup in case accidental deletion is done.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CassandraState.__new__(_CassandraState)

        __props__.__dict__["additional_disk_space"] = additional_disk_space
        __props__.__dict__["cassandra"] = cassandra
        __props__.__dict__["cassandra_user_config"] = cassandra_user_config
        __props__.__dict__["cloud_name"] = cloud_name
        __props__.__dict__["components"] = components
        __props__.__dict__["disk_space"] = disk_space
        __props__.__dict__["disk_space_cap"] = disk_space_cap
        __props__.__dict__["disk_space_default"] = disk_space_default
        __props__.__dict__["disk_space_step"] = disk_space_step
        __props__.__dict__["disk_space_used"] = disk_space_used
        __props__.__dict__["maintenance_window_dow"] = maintenance_window_dow
        __props__.__dict__["maintenance_window_time"] = maintenance_window_time
        __props__.__dict__["plan"] = plan
        __props__.__dict__["project"] = project
        __props__.__dict__["project_vpc_id"] = project_vpc_id
        __props__.__dict__["service_host"] = service_host
        __props__.__dict__["service_integrations"] = service_integrations
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["service_password"] = service_password
        __props__.__dict__["service_port"] = service_port
        __props__.__dict__["service_type"] = service_type
        __props__.__dict__["service_uri"] = service_uri
        __props__.__dict__["service_username"] = service_username
        __props__.__dict__["state"] = state
        __props__.__dict__["static_ips"] = static_ips
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tech_emails"] = tech_emails
        __props__.__dict__["termination_protection"] = termination_protection
        return Cassandra(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="additionalDiskSpace")
    def additional_disk_space(self) -> pulumi.Output[str]:
        """
        Add [disk storage](https://aiven.io/docs/platform/howto/add-storage-space) in increments of 30  GiB to scale your service. The maximum value depends on the service type and cloud provider. Removing additional storage causes the service nodes to go through a rolling restart and there might be a short downtime for services with no HA capabilities.
        """
        return pulumi.get(self, "additional_disk_space")

    @property
    @pulumi.getter
    def cassandra(self) -> pulumi.Output['outputs.CassandraCassandra']:
        """
        Values provided by the Cassandra server.
        """
        return pulumi.get(self, "cassandra")

    @property
    @pulumi.getter(name="cassandraUserConfig")
    def cassandra_user_config(self) -> pulumi.Output[Optional['outputs.CassandraCassandraUserConfig']]:
        """
        Cassandra user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "cassandra_user_config")

    @property
    @pulumi.getter(name="cloudName")
    def cloud_name(self) -> pulumi.Output[Optional[str]]:
        """
        Defines where the cloud provider and region where the service is hosted in. This can be changed freely after service is created. Changing the value will trigger a potentially lengthy migration process for the service. Format is cloud provider name (`aws`, `azure`, `do` `google`, `upcloud`, etc.), dash, and the cloud provider specific region name. These are documented on each Cloud provider's own support articles, like [here for Google](https://cloud.google.com/compute/docs/regions-zones/) and [here for AWS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html).
        """
        return pulumi.get(self, "cloud_name")

    @property
    @pulumi.getter
    def components(self) -> pulumi.Output[Sequence['outputs.CassandraComponent']]:
        """
        Service component information objects
        """
        return pulumi.get(self, "components")

    @property
    @pulumi.getter(name="diskSpace")
    @_utilities.deprecated("""This will be removed in v5.0.0. Please use `additional_disk_space` to specify the space to be added to the default `disk_space` defined by the plan.""")
    def disk_space(self) -> pulumi.Output[Optional[str]]:
        """
        Service disk space. Possible values depend on the service type, the cloud provider and the project. Therefore, reducing will result in the service rebalancing.
        """
        return pulumi.get(self, "disk_space")

    @property
    @pulumi.getter(name="diskSpaceCap")
    def disk_space_cap(self) -> pulumi.Output[str]:
        """
        The maximum disk space of the service, possible values depend on the service type, the cloud provider and the project.
        """
        return pulumi.get(self, "disk_space_cap")

    @property
    @pulumi.getter(name="diskSpaceDefault")
    def disk_space_default(self) -> pulumi.Output[str]:
        """
        The default disk space of the service, possible values depend on the service type, the cloud provider and the project. Its also the minimum value for `disk_space`
        """
        return pulumi.get(self, "disk_space_default")

    @property
    @pulumi.getter(name="diskSpaceStep")
    def disk_space_step(self) -> pulumi.Output[str]:
        """
        The default disk space step of the service, possible values depend on the service type, the cloud provider and the project. `disk_space` needs to increment from `disk_space_default` by increments of this size.
        """
        return pulumi.get(self, "disk_space_step")

    @property
    @pulumi.getter(name="diskSpaceUsed")
    @_utilities.deprecated("""This will be removed in v5.0.0. Please use `additional_disk_space` to specify the space to be added to the default `disk_space` defined by the plan.""")
    def disk_space_used(self) -> pulumi.Output[str]:
        """
        Disk space that service is currently using
        """
        return pulumi.get(self, "disk_space_used")

    @property
    @pulumi.getter(name="maintenanceWindowDow")
    def maintenance_window_dow(self) -> pulumi.Output[Optional[str]]:
        """
        Day of week when maintenance operations should be performed. One monday, tuesday, wednesday, etc.
        """
        return pulumi.get(self, "maintenance_window_dow")

    @property
    @pulumi.getter(name="maintenanceWindowTime")
    def maintenance_window_time(self) -> pulumi.Output[Optional[str]]:
        """
        Time of day when maintenance operations should be performed. UTC time in HH:mm:ss format.
        """
        return pulumi.get(self, "maintenance_window_time")

    @property
    @pulumi.getter
    def plan(self) -> pulumi.Output[str]:
        """
        Defines what kind of computing resources are allocated for the service. It can be changed after creation, though there are some restrictions when going to a smaller plan such as the new plan must have sufficient amount of disk space to store all current data and switching to a plan with fewer nodes might not be supported. The basic plan names are `hobbyist`, `startup-x`, `business-x` and `premium-x` where `x` is (roughly) the amount of memory on each node (also other attributes like number of CPUs and amount of disk space varies but naming is based on memory). The available options can be seen from the [Aiven pricing page](https://aiven.io/pricing).
        """
        return pulumi.get(self, "plan")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="projectVpcId")
    def project_vpc_id(self) -> pulumi.Output[str]:
        """
        Specifies the VPC the service should run in. If the value is not set the service is not run inside a VPC. When set, the value should be given as a reference to set up dependencies correctly and the VPC must be in the same cloud and region as the service itself. Project can be freely moved to and from VPC after creation but doing so triggers migration to new servers so the operation can take significant amount of time to complete if the service has a lot of data.
        """
        return pulumi.get(self, "project_vpc_id")

    @property
    @pulumi.getter(name="serviceHost")
    def service_host(self) -> pulumi.Output[str]:
        """
        The hostname of the service.
        """
        return pulumi.get(self, "service_host")

    @property
    @pulumi.getter(name="serviceIntegrations")
    def service_integrations(self) -> pulumi.Output[Sequence['outputs.CassandraServiceIntegration']]:
        """
        Service integrations to specify when creating a service. Not applied after initial service creation
        """
        return pulumi.get(self, "service_integrations")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[str]:
        """
        Specifies the actual name of the service. The name cannot be changed later without destroying and re-creating the service so name should be picked based on intended service usage rather than current attributes.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="servicePassword")
    def service_password(self) -> pulumi.Output[str]:
        """
        Password used for connecting to the service, if applicable
        """
        return pulumi.get(self, "service_password")

    @property
    @pulumi.getter(name="servicePort")
    def service_port(self) -> pulumi.Output[int]:
        """
        The port of the service
        """
        return pulumi.get(self, "service_port")

    @property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> pulumi.Output[str]:
        """
        Aiven internal service type code
        """
        return pulumi.get(self, "service_type")

    @property
    @pulumi.getter(name="serviceUri")
    def service_uri(self) -> pulumi.Output[str]:
        """
        URI for connecting to the service. Service specific info is under "kafka", "pg", etc.
        """
        return pulumi.get(self, "service_uri")

    @property
    @pulumi.getter(name="serviceUsername")
    def service_username(self) -> pulumi.Output[str]:
        """
        Username used for connecting to the service, if applicable
        """
        return pulumi.get(self, "service_username")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        Service state. One of `POWEROFF`, `REBALANCING`, `REBUILDING` or `RUNNING`
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="staticIps")
    def static_ips(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Static IPs that are going to be associated with this service. Please assign a value using the 'toset' function. Once a static ip resource is in the 'assigned' state it cannot be unbound from the node again
        """
        return pulumi.get(self, "static_ips")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.CassandraTag']]]:
        """
        Tags are key-value pairs that allow you to categorize services.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="techEmails")
    def tech_emails(self) -> pulumi.Output[Optional[Sequence['outputs.CassandraTechEmail']]]:
        """
        The email addresses for [service contacts](https://aiven.io/docs/platform/howto/technical-emails), who will receive important alerts and updates about this service. You can also set email contacts at the project level.
        """
        return pulumi.get(self, "tech_emails")

    @property
    @pulumi.getter(name="terminationProtection")
    def termination_protection(self) -> pulumi.Output[Optional[bool]]:
        """
        Prevents the service from being deleted. It is recommended to set this to `true` for all production services to prevent unintentional service deletion. This does not shield against deleting databases or topics but for services with backups much of the content can at least be restored from backup in case accidental deletion is done.
        """
        return pulumi.get(self, "termination_protection")

