# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ConnectionPoolArgs', 'ConnectionPool']

@pulumi.input_type
class ConnectionPoolArgs:
    def __init__(__self__, *,
                 database_name: pulumi.Input[str],
                 pool_name: pulumi.Input[str],
                 project: pulumi.Input[str],
                 service_name: pulumi.Input[str],
                 pool_mode: Optional[pulumi.Input[str]] = None,
                 pool_size: Optional[pulumi.Input[int]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ConnectionPool resource.
        :param pulumi.Input[str] database_name: The name of the database the pool connects to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[str] pool_name: Name of the pool. Changing this property forces recreation of the resource.
        :param pulumi.Input[str] project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[str] service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[str] pool_mode: The [operational mode](https://aiven.io/docs/products/postgresql/concepts/pg-connection-pooling#pooling-modes). The possible values are `session`, `transaction` and `statement`. The default value is `transaction`.
        :param pulumi.Input[int] pool_size: The number of PostgreSQL server connections this pool can use at a time. This does not affect the number of incoming connections. Each pool can handle a minimum of 5000 client connections. The default value is `10`.
        :param pulumi.Input[str] username: The name of the service user used to connect to the database. To set up proper dependencies please refer to this variable as a reference.
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "pool_name", pool_name)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "service_name", service_name)
        if pool_mode is not None:
            pulumi.set(__self__, "pool_mode", pool_mode)
        if pool_size is not None:
            pulumi.set(__self__, "pool_size", pool_size)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[str]:
        """
        The name of the database the pool connects to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="poolName")
    def pool_name(self) -> pulumi.Input[str]:
        """
        Name of the pool. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "pool_name")

    @pool_name.setter
    def pool_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "pool_name", value)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[str]:
        """
        The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="poolMode")
    def pool_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The [operational mode](https://aiven.io/docs/products/postgresql/concepts/pg-connection-pooling#pooling-modes). The possible values are `session`, `transaction` and `statement`. The default value is `transaction`.
        """
        return pulumi.get(self, "pool_mode")

    @pool_mode.setter
    def pool_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pool_mode", value)

    @property
    @pulumi.getter(name="poolSize")
    def pool_size(self) -> Optional[pulumi.Input[int]]:
        """
        The number of PostgreSQL server connections this pool can use at a time. This does not affect the number of incoming connections. Each pool can handle a minimum of 5000 client connections. The default value is `10`.
        """
        return pulumi.get(self, "pool_size")

    @pool_size.setter
    def pool_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "pool_size", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the service user used to connect to the database. To set up proper dependencies please refer to this variable as a reference.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class _ConnectionPoolState:
    def __init__(__self__, *,
                 connection_uri: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 pool_mode: Optional[pulumi.Input[str]] = None,
                 pool_name: Optional[pulumi.Input[str]] = None,
                 pool_size: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ConnectionPool resources.
        :param pulumi.Input[str] connection_uri: The URI for connecting to the pool.
        :param pulumi.Input[str] database_name: The name of the database the pool connects to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[str] pool_mode: The [operational mode](https://aiven.io/docs/products/postgresql/concepts/pg-connection-pooling#pooling-modes). The possible values are `session`, `transaction` and `statement`. The default value is `transaction`.
        :param pulumi.Input[str] pool_name: Name of the pool. Changing this property forces recreation of the resource.
        :param pulumi.Input[int] pool_size: The number of PostgreSQL server connections this pool can use at a time. This does not affect the number of incoming connections. Each pool can handle a minimum of 5000 client connections. The default value is `10`.
        :param pulumi.Input[str] project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[str] service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[str] username: The name of the service user used to connect to the database. To set up proper dependencies please refer to this variable as a reference.
        """
        if connection_uri is not None:
            pulumi.set(__self__, "connection_uri", connection_uri)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if pool_mode is not None:
            pulumi.set(__self__, "pool_mode", pool_mode)
        if pool_name is not None:
            pulumi.set(__self__, "pool_name", pool_name)
        if pool_size is not None:
            pulumi.set(__self__, "pool_size", pool_size)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="connectionUri")
    def connection_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The URI for connecting to the pool.
        """
        return pulumi.get(self, "connection_uri")

    @connection_uri.setter
    def connection_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_uri", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the database the pool connects to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="poolMode")
    def pool_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The [operational mode](https://aiven.io/docs/products/postgresql/concepts/pg-connection-pooling#pooling-modes). The possible values are `session`, `transaction` and `statement`. The default value is `transaction`.
        """
        return pulumi.get(self, "pool_mode")

    @pool_mode.setter
    def pool_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pool_mode", value)

    @property
    @pulumi.getter(name="poolName")
    def pool_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the pool. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "pool_name")

    @pool_name.setter
    def pool_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pool_name", value)

    @property
    @pulumi.getter(name="poolSize")
    def pool_size(self) -> Optional[pulumi.Input[int]]:
        """
        The number of PostgreSQL server connections this pool can use at a time. This does not affect the number of incoming connections. Each pool can handle a minimum of 5000 client connections. The default value is `10`.
        """
        return pulumi.get(self, "pool_size")

    @pool_size.setter
    def pool_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "pool_size", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the service user used to connect to the database. To set up proper dependencies please refer to this variable as a reference.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


class ConnectionPool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 pool_mode: Optional[pulumi.Input[str]] = None,
                 pool_name: Optional[pulumi.Input[str]] = None,
                 pool_size: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates and manages a [connection pool](https://aiven.io/docs/products/postgresql/concepts/pg-connection-pooling) in an Aiven for PostgreSQL® service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        main = aiven.ConnectionPool("main",
            project=example_project["project"],
            service_name=example_postgres["serviceName"],
            database_name=main_aiven_pg_database["databaseName"],
            pool_mode="transaction",
            pool_name="example-pool",
            pool_size=10,
            username=example_user["username"])
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/connectionPool:ConnectionPool main PROJECT/SERVICE_NAME/POOL_NAME
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] database_name: The name of the database the pool connects to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[str] pool_mode: The [operational mode](https://aiven.io/docs/products/postgresql/concepts/pg-connection-pooling#pooling-modes). The possible values are `session`, `transaction` and `statement`. The default value is `transaction`.
        :param pulumi.Input[str] pool_name: Name of the pool. Changing this property forces recreation of the resource.
        :param pulumi.Input[int] pool_size: The number of PostgreSQL server connections this pool can use at a time. This does not affect the number of incoming connections. Each pool can handle a minimum of 5000 client connections. The default value is `10`.
        :param pulumi.Input[str] project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[str] service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[str] username: The name of the service user used to connect to the database. To set up proper dependencies please refer to this variable as a reference.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConnectionPoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages a [connection pool](https://aiven.io/docs/products/postgresql/concepts/pg-connection-pooling) in an Aiven for PostgreSQL® service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        main = aiven.ConnectionPool("main",
            project=example_project["project"],
            service_name=example_postgres["serviceName"],
            database_name=main_aiven_pg_database["databaseName"],
            pool_mode="transaction",
            pool_name="example-pool",
            pool_size=10,
            username=example_user["username"])
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/connectionPool:ConnectionPool main PROJECT/SERVICE_NAME/POOL_NAME
        ```

        :param str resource_name: The name of the resource.
        :param ConnectionPoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectionPoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 pool_mode: Optional[pulumi.Input[str]] = None,
                 pool_name: Optional[pulumi.Input[str]] = None,
                 pool_size: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectionPoolArgs.__new__(ConnectionPoolArgs)

            if database_name is None and not opts.urn:
                raise TypeError("Missing required property 'database_name'")
            __props__.__dict__["database_name"] = database_name
            __props__.__dict__["pool_mode"] = pool_mode
            if pool_name is None and not opts.urn:
                raise TypeError("Missing required property 'pool_name'")
            __props__.__dict__["pool_name"] = pool_name
            __props__.__dict__["pool_size"] = pool_size
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["username"] = username
            __props__.__dict__["connection_uri"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["connectionUri"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ConnectionPool, __self__).__init__(
            'aiven:index/connectionPool:ConnectionPool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            connection_uri: Optional[pulumi.Input[str]] = None,
            database_name: Optional[pulumi.Input[str]] = None,
            pool_mode: Optional[pulumi.Input[str]] = None,
            pool_name: Optional[pulumi.Input[str]] = None,
            pool_size: Optional[pulumi.Input[int]] = None,
            project: Optional[pulumi.Input[str]] = None,
            service_name: Optional[pulumi.Input[str]] = None,
            username: Optional[pulumi.Input[str]] = None) -> 'ConnectionPool':
        """
        Get an existing ConnectionPool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] connection_uri: The URI for connecting to the pool.
        :param pulumi.Input[str] database_name: The name of the database the pool connects to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[str] pool_mode: The [operational mode](https://aiven.io/docs/products/postgresql/concepts/pg-connection-pooling#pooling-modes). The possible values are `session`, `transaction` and `statement`. The default value is `transaction`.
        :param pulumi.Input[str] pool_name: Name of the pool. Changing this property forces recreation of the resource.
        :param pulumi.Input[int] pool_size: The number of PostgreSQL server connections this pool can use at a time. This does not affect the number of incoming connections. Each pool can handle a minimum of 5000 client connections. The default value is `10`.
        :param pulumi.Input[str] project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[str] service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[str] username: The name of the service user used to connect to the database. To set up proper dependencies please refer to this variable as a reference.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectionPoolState.__new__(_ConnectionPoolState)

        __props__.__dict__["connection_uri"] = connection_uri
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["pool_mode"] = pool_mode
        __props__.__dict__["pool_name"] = pool_name
        __props__.__dict__["pool_size"] = pool_size
        __props__.__dict__["project"] = project
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["username"] = username
        return ConnectionPool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="connectionUri")
    def connection_uri(self) -> pulumi.Output[str]:
        """
        The URI for connecting to the pool.
        """
        return pulumi.get(self, "connection_uri")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[str]:
        """
        The name of the database the pool connects to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="poolMode")
    def pool_mode(self) -> pulumi.Output[Optional[str]]:
        """
        The [operational mode](https://aiven.io/docs/products/postgresql/concepts/pg-connection-pooling#pooling-modes). The possible values are `session`, `transaction` and `statement`. The default value is `transaction`.
        """
        return pulumi.get(self, "pool_mode")

    @property
    @pulumi.getter(name="poolName")
    def pool_name(self) -> pulumi.Output[str]:
        """
        Name of the pool. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "pool_name")

    @property
    @pulumi.getter(name="poolSize")
    def pool_size(self) -> pulumi.Output[Optional[int]]:
        """
        The number of PostgreSQL server connections this pool can use at a time. This does not affect the number of incoming connections. Each pool can handle a minimum of 5000 client connections. The default value is `10`.
        """
        return pulumi.get(self, "pool_size")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[str]:
        """
        The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the service user used to connect to the database. To set up proper dependencies please refer to this variable as a reference.
        """
        return pulumi.get(self, "username")

