# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetAzureVpcPeeringConnectionResult',
    'AwaitableGetAzureVpcPeeringConnectionResult',
    'get_azure_vpc_peering_connection',
    'get_azure_vpc_peering_connection_output',
]

@pulumi.output_type
class GetAzureVpcPeeringConnectionResult:
    """
    A collection of values returned by getAzureVpcPeeringConnection.
    """
    def __init__(__self__, azure_subscription_id=None, id=None, peer_azure_app_id=None, peer_azure_tenant_id=None, peer_resource_group=None, peering_connection_id=None, state=None, state_info=None, vnet_name=None, vpc_id=None):
        if azure_subscription_id and not isinstance(azure_subscription_id, str):
            raise TypeError("Expected argument 'azure_subscription_id' to be a str")
        pulumi.set(__self__, "azure_subscription_id", azure_subscription_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if peer_azure_app_id and not isinstance(peer_azure_app_id, str):
            raise TypeError("Expected argument 'peer_azure_app_id' to be a str")
        pulumi.set(__self__, "peer_azure_app_id", peer_azure_app_id)
        if peer_azure_tenant_id and not isinstance(peer_azure_tenant_id, str):
            raise TypeError("Expected argument 'peer_azure_tenant_id' to be a str")
        pulumi.set(__self__, "peer_azure_tenant_id", peer_azure_tenant_id)
        if peer_resource_group and not isinstance(peer_resource_group, str):
            raise TypeError("Expected argument 'peer_resource_group' to be a str")
        pulumi.set(__self__, "peer_resource_group", peer_resource_group)
        if peering_connection_id and not isinstance(peering_connection_id, str):
            raise TypeError("Expected argument 'peering_connection_id' to be a str")
        pulumi.set(__self__, "peering_connection_id", peering_connection_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if state_info and not isinstance(state_info, dict):
            raise TypeError("Expected argument 'state_info' to be a dict")
        pulumi.set(__self__, "state_info", state_info)
        if vnet_name and not isinstance(vnet_name, str):
            raise TypeError("Expected argument 'vnet_name' to be a str")
        pulumi.set(__self__, "vnet_name", vnet_name)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="azureSubscriptionId")
    def azure_subscription_id(self) -> str:
        """
        The ID of the Azure subscription in UUID4 format. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "azure_subscription_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="peerAzureAppId")
    def peer_azure_app_id(self) -> str:
        """
        The ID of the Azure app that is allowed to create a peering to the Azure Virtual Network (VNet) in UUID4 format. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "peer_azure_app_id")

    @property
    @pulumi.getter(name="peerAzureTenantId")
    def peer_azure_tenant_id(self) -> str:
        """
        The Azure tenant ID in UUID4 format. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "peer_azure_tenant_id")

    @property
    @pulumi.getter(name="peerResourceGroup")
    def peer_resource_group(self) -> str:
        """
        The name of the Azure resource group associated with the VNet. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "peer_resource_group")

    @property
    @pulumi.getter(name="peeringConnectionId")
    def peering_connection_id(self) -> str:
        """
        The ID of the cloud provider for the peering connection.
        """
        return pulumi.get(self, "peering_connection_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        State of the peering connection
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateInfo")
    def state_info(self) -> Mapping[str, str]:
        """
        State-specific help or error information.
        """
        return pulumi.get(self, "state_info")

    @property
    @pulumi.getter(name="vnetName")
    def vnet_name(self) -> str:
        """
        The name of the Azure VNet. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "vnet_name")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The ID of the Aiven VPC. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "vpc_id")


class AwaitableGetAzureVpcPeeringConnectionResult(GetAzureVpcPeeringConnectionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAzureVpcPeeringConnectionResult(
            azure_subscription_id=self.azure_subscription_id,
            id=self.id,
            peer_azure_app_id=self.peer_azure_app_id,
            peer_azure_tenant_id=self.peer_azure_tenant_id,
            peer_resource_group=self.peer_resource_group,
            peering_connection_id=self.peering_connection_id,
            state=self.state,
            state_info=self.state_info,
            vnet_name=self.vnet_name,
            vpc_id=self.vpc_id)


def get_azure_vpc_peering_connection(azure_subscription_id: Optional[str] = None,
                                     peer_azure_app_id: Optional[str] = None,
                                     peer_azure_tenant_id: Optional[str] = None,
                                     peer_resource_group: Optional[str] = None,
                                     vnet_name: Optional[str] = None,
                                     vpc_id: Optional[str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAzureVpcPeeringConnectionResult:
    """
    Gets information about about an Azure VPC peering connection.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    azure_to_aiven_peering = aiven.get_azure_vpc_peering_connection(vpc_id=example_vpc["id"],
        azure_subscription_id="00000000-0000-0000-0000-000000000000",
        peer_resource_group="example-resource-group",
        vnet_name="example-vnet",
        peer_azure_app_id="00000000-0000-0000-0000-000000000000",
        peer_azure_tenant_id="00000000-0000-0000-0000-000000000000")
    ```


    :param str azure_subscription_id: The ID of the Azure subscription in UUID4 format. Changing this property forces recreation of the resource.
    :param str peer_azure_app_id: The ID of the Azure app that is allowed to create a peering to the Azure Virtual Network (VNet) in UUID4 format. Changing this property forces recreation of the resource.
    :param str peer_azure_tenant_id: The Azure tenant ID in UUID4 format. Changing this property forces recreation of the resource.
    :param str peer_resource_group: The name of the Azure resource group associated with the VNet. Changing this property forces recreation of the resource.
    :param str vnet_name: The name of the Azure VNet. Changing this property forces recreation of the resource.
    :param str vpc_id: The ID of the Aiven VPC. Changing this property forces recreation of the resource.
    """
    __args__ = dict()
    __args__['azureSubscriptionId'] = azure_subscription_id
    __args__['peerAzureAppId'] = peer_azure_app_id
    __args__['peerAzureTenantId'] = peer_azure_tenant_id
    __args__['peerResourceGroup'] = peer_resource_group
    __args__['vnetName'] = vnet_name
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aiven:index/getAzureVpcPeeringConnection:getAzureVpcPeeringConnection', __args__, opts=opts, typ=GetAzureVpcPeeringConnectionResult).value

    return AwaitableGetAzureVpcPeeringConnectionResult(
        azure_subscription_id=pulumi.get(__ret__, 'azure_subscription_id'),
        id=pulumi.get(__ret__, 'id'),
        peer_azure_app_id=pulumi.get(__ret__, 'peer_azure_app_id'),
        peer_azure_tenant_id=pulumi.get(__ret__, 'peer_azure_tenant_id'),
        peer_resource_group=pulumi.get(__ret__, 'peer_resource_group'),
        peering_connection_id=pulumi.get(__ret__, 'peering_connection_id'),
        state=pulumi.get(__ret__, 'state'),
        state_info=pulumi.get(__ret__, 'state_info'),
        vnet_name=pulumi.get(__ret__, 'vnet_name'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))
def get_azure_vpc_peering_connection_output(azure_subscription_id: Optional[pulumi.Input[str]] = None,
                                            peer_azure_app_id: Optional[pulumi.Input[str]] = None,
                                            peer_azure_tenant_id: Optional[pulumi.Input[str]] = None,
                                            peer_resource_group: Optional[pulumi.Input[str]] = None,
                                            vnet_name: Optional[pulumi.Input[str]] = None,
                                            vpc_id: Optional[pulumi.Input[str]] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAzureVpcPeeringConnectionResult]:
    """
    Gets information about about an Azure VPC peering connection.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    azure_to_aiven_peering = aiven.get_azure_vpc_peering_connection(vpc_id=example_vpc["id"],
        azure_subscription_id="00000000-0000-0000-0000-000000000000",
        peer_resource_group="example-resource-group",
        vnet_name="example-vnet",
        peer_azure_app_id="00000000-0000-0000-0000-000000000000",
        peer_azure_tenant_id="00000000-0000-0000-0000-000000000000")
    ```


    :param str azure_subscription_id: The ID of the Azure subscription in UUID4 format. Changing this property forces recreation of the resource.
    :param str peer_azure_app_id: The ID of the Azure app that is allowed to create a peering to the Azure Virtual Network (VNet) in UUID4 format. Changing this property forces recreation of the resource.
    :param str peer_azure_tenant_id: The Azure tenant ID in UUID4 format. Changing this property forces recreation of the resource.
    :param str peer_resource_group: The name of the Azure resource group associated with the VNet. Changing this property forces recreation of the resource.
    :param str vnet_name: The name of the Azure VNet. Changing this property forces recreation of the resource.
    :param str vpc_id: The ID of the Aiven VPC. Changing this property forces recreation of the resource.
    """
    __args__ = dict()
    __args__['azureSubscriptionId'] = azure_subscription_id
    __args__['peerAzureAppId'] = peer_azure_app_id
    __args__['peerAzureTenantId'] = peer_azure_tenant_id
    __args__['peerResourceGroup'] = peer_resource_group
    __args__['vnetName'] = vnet_name
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aiven:index/getAzureVpcPeeringConnection:getAzureVpcPeeringConnection', __args__, opts=opts, typ=GetAzureVpcPeeringConnectionResult)
    return __ret__.apply(lambda __response__: GetAzureVpcPeeringConnectionResult(
        azure_subscription_id=pulumi.get(__response__, 'azure_subscription_id'),
        id=pulumi.get(__response__, 'id'),
        peer_azure_app_id=pulumi.get(__response__, 'peer_azure_app_id'),
        peer_azure_tenant_id=pulumi.get(__response__, 'peer_azure_tenant_id'),
        peer_resource_group=pulumi.get(__response__, 'peer_resource_group'),
        peering_connection_id=pulumi.get(__response__, 'peering_connection_id'),
        state=pulumi.get(__response__, 'state'),
        state_info=pulumi.get(__response__, 'state_info'),
        vnet_name=pulumi.get(__response__, 'vnet_name'),
        vpc_id=pulumi.get(__response__, 'vpc_id')))
