# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetFlinkApplicationVersionResult',
    'AwaitableGetFlinkApplicationVersionResult',
    'get_flink_application_version',
    'get_flink_application_version_output',
]

@pulumi.output_type
class GetFlinkApplicationVersionResult:
    """
    A collection of values returned by getFlinkApplicationVersion.
    """
    def __init__(__self__, application_id=None, application_version_id=None, created_at=None, created_by=None, id=None, project=None, service_name=None, sink=None, sinks=None, source=None, sources=None, statement=None, version=None):
        if application_id and not isinstance(application_id, str):
            raise TypeError("Expected argument 'application_id' to be a str")
        pulumi.set(__self__, "application_id", application_id)
        if application_version_id and not isinstance(application_version_id, str):
            raise TypeError("Expected argument 'application_version_id' to be a str")
        pulumi.set(__self__, "application_version_id", application_version_id)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if sink and not isinstance(sink, list):
            raise TypeError("Expected argument 'sink' to be a list")
        pulumi.set(__self__, "sink", sink)
        if sinks and not isinstance(sinks, list):
            raise TypeError("Expected argument 'sinks' to be a list")
        pulumi.set(__self__, "sinks", sinks)
        if source and not isinstance(source, list):
            raise TypeError("Expected argument 'source' to be a list")
        pulumi.set(__self__, "source", source)
        if sources and not isinstance(sources, list):
            raise TypeError("Expected argument 'sources' to be a list")
        pulumi.set(__self__, "sources", sources)
        if statement and not isinstance(statement, str):
            raise TypeError("Expected argument 'statement' to be a str")
        pulumi.set(__self__, "statement", statement)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> str:
        """
        Application ID.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="applicationVersionId")
    def application_version_id(self) -> str:
        """
        Application version ID.
        """
        return pulumi.get(self, "application_version_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        Application version creation time.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> str:
        """
        The user who created the application.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        """
        The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def sink(self) -> Sequence['outputs.GetFlinkApplicationVersionSinkResult']:
        """
        The sink table for the application.
        """
        return pulumi.get(self, "sink")

    @property
    @pulumi.getter
    def sinks(self) -> Sequence['outputs.GetFlinkApplicationVersionSinkResult']:
        """
        Application sinks
        """
        return pulumi.get(self, "sinks")

    @property
    @pulumi.getter
    def source(self) -> Sequence['outputs.GetFlinkApplicationVersionSourceResult']:
        """
        The source table for the application.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.GetFlinkApplicationVersionSourceResult']:
        """
        Application sources
        """
        return pulumi.get(self, "sources")

    @property
    @pulumi.getter
    def statement(self) -> str:
        """
        Job SQL statement.
        """
        return pulumi.get(self, "statement")

    @property
    @pulumi.getter
    def version(self) -> int:
        """
        Application version number.
        """
        return pulumi.get(self, "version")


class AwaitableGetFlinkApplicationVersionResult(GetFlinkApplicationVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFlinkApplicationVersionResult(
            application_id=self.application_id,
            application_version_id=self.application_version_id,
            created_at=self.created_at,
            created_by=self.created_by,
            id=self.id,
            project=self.project,
            service_name=self.service_name,
            sink=self.sink,
            sinks=self.sinks,
            source=self.source,
            sources=self.sources,
            statement=self.statement,
            version=self.version)


def get_flink_application_version(application_id: Optional[str] = None,
                                  application_version_id: Optional[str] = None,
                                  project: Optional[str] = None,
                                  service_name: Optional[str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFlinkApplicationVersionResult:
    """
    Gets information about an Aiven for Apache Flink® application version.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    main = aiven.get_flink_application_version(project=example_project["project"],
        service_name=example_flink["serviceName"],
        application_id=example_app["applicationId"],
        application_version_id="d6e7f71c-cadf-49b5-a4ad-126c805fe684")
    ```


    :param str application_id: Application ID.
    :param str application_version_id: Application version ID.
    :param str project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param str service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    """
    __args__ = dict()
    __args__['applicationId'] = application_id
    __args__['applicationVersionId'] = application_version_id
    __args__['project'] = project
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aiven:index/getFlinkApplicationVersion:getFlinkApplicationVersion', __args__, opts=opts, typ=GetFlinkApplicationVersionResult).value

    return AwaitableGetFlinkApplicationVersionResult(
        application_id=pulumi.get(__ret__, 'application_id'),
        application_version_id=pulumi.get(__ret__, 'application_version_id'),
        created_at=pulumi.get(__ret__, 'created_at'),
        created_by=pulumi.get(__ret__, 'created_by'),
        id=pulumi.get(__ret__, 'id'),
        project=pulumi.get(__ret__, 'project'),
        service_name=pulumi.get(__ret__, 'service_name'),
        sink=pulumi.get(__ret__, 'sink'),
        sinks=pulumi.get(__ret__, 'sinks'),
        source=pulumi.get(__ret__, 'source'),
        sources=pulumi.get(__ret__, 'sources'),
        statement=pulumi.get(__ret__, 'statement'),
        version=pulumi.get(__ret__, 'version'))
def get_flink_application_version_output(application_id: Optional[pulumi.Input[str]] = None,
                                         application_version_id: Optional[pulumi.Input[str]] = None,
                                         project: Optional[pulumi.Input[str]] = None,
                                         service_name: Optional[pulumi.Input[str]] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFlinkApplicationVersionResult]:
    """
    Gets information about an Aiven for Apache Flink® application version.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    main = aiven.get_flink_application_version(project=example_project["project"],
        service_name=example_flink["serviceName"],
        application_id=example_app["applicationId"],
        application_version_id="d6e7f71c-cadf-49b5-a4ad-126c805fe684")
    ```


    :param str application_id: Application ID.
    :param str application_version_id: Application version ID.
    :param str project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param str service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    """
    __args__ = dict()
    __args__['applicationId'] = application_id
    __args__['applicationVersionId'] = application_version_id
    __args__['project'] = project
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aiven:index/getFlinkApplicationVersion:getFlinkApplicationVersion', __args__, opts=opts, typ=GetFlinkApplicationVersionResult)
    return __ret__.apply(lambda __response__: GetFlinkApplicationVersionResult(
        application_id=pulumi.get(__response__, 'application_id'),
        application_version_id=pulumi.get(__response__, 'application_version_id'),
        created_at=pulumi.get(__response__, 'created_at'),
        created_by=pulumi.get(__response__, 'created_by'),
        id=pulumi.get(__response__, 'id'),
        project=pulumi.get(__response__, 'project'),
        service_name=pulumi.get(__response__, 'service_name'),
        sink=pulumi.get(__response__, 'sink'),
        sinks=pulumi.get(__response__, 'sinks'),
        source=pulumi.get(__response__, 'source'),
        sources=pulumi.get(__response__, 'sources'),
        statement=pulumi.get(__response__, 'statement'),
        version=pulumi.get(__response__, 'version')))
