# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetGcpPrivatelinkResult',
    'AwaitableGetGcpPrivatelinkResult',
    'get_gcp_privatelink',
    'get_gcp_privatelink_output',
]

@pulumi.output_type
class GetGcpPrivatelinkResult:
    """
    A collection of values returned by getGcpPrivatelink.
    """
    def __init__(__self__, google_service_attachment=None, id=None, message=None, project=None, service_name=None, state=None):
        if google_service_attachment and not isinstance(google_service_attachment, str):
            raise TypeError("Expected argument 'google_service_attachment' to be a str")
        pulumi.set(__self__, "google_service_attachment", google_service_attachment)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if message and not isinstance(message, str):
            raise TypeError("Expected argument 'message' to be a str")
        pulumi.set(__self__, "message", message)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="googleServiceAttachment")
    def google_service_attachment(self) -> str:
        """
        Google Private Service Connect service attachment.
        """
        return pulumi.get(self, "google_service_attachment")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Printable result of the Google Cloud Private Service Connect request.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        """
        The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the Private Service Connect resource.
        """
        return pulumi.get(self, "state")


class AwaitableGetGcpPrivatelinkResult(GetGcpPrivatelinkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGcpPrivatelinkResult(
            google_service_attachment=self.google_service_attachment,
            id=self.id,
            message=self.message,
            project=self.project,
            service_name=self.service_name,
            state=self.state)


def get_gcp_privatelink(project: Optional[str] = None,
                        service_name: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGcpPrivatelinkResult:
    """
    Gets information about a Google Private Service Connect connection for an Aiven service.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    main = aiven.get_gcp_privatelink(project=example_project["project"],
        service_name=example_kafka["serviceName"])
    ```


    :param str project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param str service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aiven:index/getGcpPrivatelink:getGcpPrivatelink', __args__, opts=opts, typ=GetGcpPrivatelinkResult).value

    return AwaitableGetGcpPrivatelinkResult(
        google_service_attachment=pulumi.get(__ret__, 'google_service_attachment'),
        id=pulumi.get(__ret__, 'id'),
        message=pulumi.get(__ret__, 'message'),
        project=pulumi.get(__ret__, 'project'),
        service_name=pulumi.get(__ret__, 'service_name'),
        state=pulumi.get(__ret__, 'state'))
def get_gcp_privatelink_output(project: Optional[pulumi.Input[str]] = None,
                               service_name: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetGcpPrivatelinkResult]:
    """
    Gets information about a Google Private Service Connect connection for an Aiven service.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    main = aiven.get_gcp_privatelink(project=example_project["project"],
        service_name=example_kafka["serviceName"])
    ```


    :param str project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param str service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aiven:index/getGcpPrivatelink:getGcpPrivatelink', __args__, opts=opts, typ=GetGcpPrivatelinkResult)
    return __ret__.apply(lambda __response__: GetGcpPrivatelinkResult(
        google_service_attachment=pulumi.get(__response__, 'google_service_attachment'),
        id=pulumi.get(__response__, 'id'),
        message=pulumi.get(__response__, 'message'),
        project=pulumi.get(__response__, 'project'),
        service_name=pulumi.get(__response__, 'service_name'),
        state=pulumi.get(__response__, 'state')))
