# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetKafkaTopicResult',
    'AwaitableGetKafkaTopicResult',
    'get_kafka_topic',
    'get_kafka_topic_output',
]

@pulumi.output_type
class GetKafkaTopicResult:
    """
    A collection of values returned by getKafkaTopic.
    """
    def __init__(__self__, configs=None, id=None, owner_user_group_id=None, partitions=None, project=None, replication=None, service_name=None, tags=None, termination_protection=None, topic_description=None, topic_name=None):
        if configs and not isinstance(configs, list):
            raise TypeError("Expected argument 'configs' to be a list")
        pulumi.set(__self__, "configs", configs)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if owner_user_group_id and not isinstance(owner_user_group_id, str):
            raise TypeError("Expected argument 'owner_user_group_id' to be a str")
        pulumi.set(__self__, "owner_user_group_id", owner_user_group_id)
        if partitions and not isinstance(partitions, int):
            raise TypeError("Expected argument 'partitions' to be a int")
        pulumi.set(__self__, "partitions", partitions)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if replication and not isinstance(replication, int):
            raise TypeError("Expected argument 'replication' to be a int")
        pulumi.set(__self__, "replication", replication)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if termination_protection and not isinstance(termination_protection, bool):
            raise TypeError("Expected argument 'termination_protection' to be a bool")
        pulumi.set(__self__, "termination_protection", termination_protection)
        if topic_description and not isinstance(topic_description, str):
            raise TypeError("Expected argument 'topic_description' to be a str")
        pulumi.set(__self__, "topic_description", topic_description)
        if topic_name and not isinstance(topic_name, str):
            raise TypeError("Expected argument 'topic_name' to be a str")
        pulumi.set(__self__, "topic_name", topic_name)

    @property
    @pulumi.getter
    def configs(self) -> Sequence['outputs.GetKafkaTopicConfigResult']:
        """
        [Advanced parameters](https://aiven.io/docs/products/kafka/reference/advanced-params) to configure topics.
        """
        return pulumi.get(self, "configs")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ownerUserGroupId")
    def owner_user_group_id(self) -> str:
        """
        The ID of the user group that owns the topic. Assigning ownership to decentralize topic management is part of [Aiven for Apache Kafka® governance](https://aiven.io/docs/products/kafka/concepts/governance-overview).
        """
        return pulumi.get(self, "owner_user_group_id")

    @property
    @pulumi.getter
    def partitions(self) -> int:
        """
        The number of partitions to create in the topic.
        """
        return pulumi.get(self, "partitions")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def replication(self) -> int:
        """
        The replication factor for the topic.
        """
        return pulumi.get(self, "replication")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        """
        The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def tags(self) -> Sequence['outputs.GetKafkaTopicTagResult']:
        """
        Tags for the topic.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="terminationProtection")
    def termination_protection(self) -> bool:
        return pulumi.get(self, "termination_protection")

    @property
    @pulumi.getter(name="topicDescription")
    def topic_description(self) -> str:
        """
        The description of the topic
        """
        return pulumi.get(self, "topic_description")

    @property
    @pulumi.getter(name="topicName")
    def topic_name(self) -> str:
        """
        The name of the topic. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "topic_name")


class AwaitableGetKafkaTopicResult(GetKafkaTopicResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKafkaTopicResult(
            configs=self.configs,
            id=self.id,
            owner_user_group_id=self.owner_user_group_id,
            partitions=self.partitions,
            project=self.project,
            replication=self.replication,
            service_name=self.service_name,
            tags=self.tags,
            termination_protection=self.termination_protection,
            topic_description=self.topic_description,
            topic_name=self.topic_name)


def get_kafka_topic(project: Optional[str] = None,
                    service_name: Optional[str] = None,
                    topic_name: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKafkaTopicResult:
    """
    Gets information about an Aiven for Apache Kafka® topic.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    example_topic = aiven.get_kafka_topic(project=example_project["project"],
        service_name=example_kafka["serviceName"],
        topic_name="example-topic")
    ```


    :param str project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param str service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param str topic_name: The name of the topic. Changing this property forces recreation of the resource.
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['serviceName'] = service_name
    __args__['topicName'] = topic_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aiven:index/getKafkaTopic:getKafkaTopic', __args__, opts=opts, typ=GetKafkaTopicResult).value

    return AwaitableGetKafkaTopicResult(
        configs=pulumi.get(__ret__, 'configs'),
        id=pulumi.get(__ret__, 'id'),
        owner_user_group_id=pulumi.get(__ret__, 'owner_user_group_id'),
        partitions=pulumi.get(__ret__, 'partitions'),
        project=pulumi.get(__ret__, 'project'),
        replication=pulumi.get(__ret__, 'replication'),
        service_name=pulumi.get(__ret__, 'service_name'),
        tags=pulumi.get(__ret__, 'tags'),
        termination_protection=pulumi.get(__ret__, 'termination_protection'),
        topic_description=pulumi.get(__ret__, 'topic_description'),
        topic_name=pulumi.get(__ret__, 'topic_name'))
def get_kafka_topic_output(project: Optional[pulumi.Input[str]] = None,
                           service_name: Optional[pulumi.Input[str]] = None,
                           topic_name: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetKafkaTopicResult]:
    """
    Gets information about an Aiven for Apache Kafka® topic.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    example_topic = aiven.get_kafka_topic(project=example_project["project"],
        service_name=example_kafka["serviceName"],
        topic_name="example-topic")
    ```


    :param str project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param str service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param str topic_name: The name of the topic. Changing this property forces recreation of the resource.
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['serviceName'] = service_name
    __args__['topicName'] = topic_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aiven:index/getKafkaTopic:getKafkaTopic', __args__, opts=opts, typ=GetKafkaTopicResult)
    return __ret__.apply(lambda __response__: GetKafkaTopicResult(
        configs=pulumi.get(__response__, 'configs'),
        id=pulumi.get(__response__, 'id'),
        owner_user_group_id=pulumi.get(__response__, 'owner_user_group_id'),
        partitions=pulumi.get(__response__, 'partitions'),
        project=pulumi.get(__response__, 'project'),
        replication=pulumi.get(__response__, 'replication'),
        service_name=pulumi.get(__response__, 'service_name'),
        tags=pulumi.get(__response__, 'tags'),
        termination_protection=pulumi.get(__response__, 'termination_protection'),
        topic_description=pulumi.get(__response__, 'topic_description'),
        topic_name=pulumi.get(__response__, 'topic_name')))
