# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetOrganizationApplicationUserResult',
    'AwaitableGetOrganizationApplicationUserResult',
    'get_organization_application_user',
    'get_organization_application_user_output',
]

@pulumi.output_type
class GetOrganizationApplicationUserResult:
    """
    A collection of values returned by getOrganizationApplicationUser.
    """
    def __init__(__self__, email=None, id=None, is_super_admin=None, name=None, organization_id=None, user_id=None):
        if email and not isinstance(email, str):
            raise TypeError("Expected argument 'email' to be a str")
        pulumi.set(__self__, "email", email)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_super_admin and not isinstance(is_super_admin, bool):
            raise TypeError("Expected argument 'is_super_admin' to be a bool")
        pulumi.set(__self__, "is_super_admin", is_super_admin)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if user_id and not isinstance(user_id, str):
            raise TypeError("Expected argument 'user_id' to be a str")
        pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter
    def email(self) -> str:
        """
        An email address automatically generated by Aiven to help identify the application user. No notifications are sent to this email.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isSuperAdmin")
    def is_super_admin(self) -> bool:
        """
        Makes the application user a super admin. The super admin role has full access to an organization, its billing and settings, and all its organizational units, projects, and services.
        """
        return pulumi.get(self, "is_super_admin")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the application user.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> str:
        """
        The ID of the organization the application user belongs to.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> str:
        """
        The ID of the application user.
        """
        return pulumi.get(self, "user_id")


class AwaitableGetOrganizationApplicationUserResult(GetOrganizationApplicationUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOrganizationApplicationUserResult(
            email=self.email,
            id=self.id,
            is_super_admin=self.is_super_admin,
            name=self.name,
            organization_id=self.organization_id,
            user_id=self.user_id)


def get_organization_application_user(organization_id: Optional[str] = None,
                                      user_id: Optional[str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOrganizationApplicationUserResult:
    """
    Gets information about an application user.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    tf_user = aiven.get_organization_application_user(organization_id=main["id"],
        user_id="u123a456b7890c")
    ```


    :param str organization_id: The ID of the organization the application user belongs to.
    :param str user_id: The ID of the application user.
    """
    __args__ = dict()
    __args__['organizationId'] = organization_id
    __args__['userId'] = user_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aiven:index/getOrganizationApplicationUser:getOrganizationApplicationUser', __args__, opts=opts, typ=GetOrganizationApplicationUserResult).value

    return AwaitableGetOrganizationApplicationUserResult(
        email=pulumi.get(__ret__, 'email'),
        id=pulumi.get(__ret__, 'id'),
        is_super_admin=pulumi.get(__ret__, 'is_super_admin'),
        name=pulumi.get(__ret__, 'name'),
        organization_id=pulumi.get(__ret__, 'organization_id'),
        user_id=pulumi.get(__ret__, 'user_id'))
def get_organization_application_user_output(organization_id: Optional[pulumi.Input[str]] = None,
                                             user_id: Optional[pulumi.Input[str]] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOrganizationApplicationUserResult]:
    """
    Gets information about an application user.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    tf_user = aiven.get_organization_application_user(organization_id=main["id"],
        user_id="u123a456b7890c")
    ```


    :param str organization_id: The ID of the organization the application user belongs to.
    :param str user_id: The ID of the application user.
    """
    __args__ = dict()
    __args__['organizationId'] = organization_id
    __args__['userId'] = user_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aiven:index/getOrganizationApplicationUser:getOrganizationApplicationUser', __args__, opts=opts, typ=GetOrganizationApplicationUserResult)
    return __ret__.apply(lambda __response__: GetOrganizationApplicationUserResult(
        email=pulumi.get(__response__, 'email'),
        id=pulumi.get(__response__, 'id'),
        is_super_admin=pulumi.get(__response__, 'is_super_admin'),
        name=pulumi.get(__response__, 'name'),
        organization_id=pulumi.get(__response__, 'organization_id'),
        user_id=pulumi.get(__response__, 'user_id')))
