# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetServiceIntegrationEndpointResult',
    'AwaitableGetServiceIntegrationEndpointResult',
    'get_service_integration_endpoint',
    'get_service_integration_endpoint_output',
]

@pulumi.output_type
class GetServiceIntegrationEndpointResult:
    """
    A collection of values returned by getServiceIntegrationEndpoint.
    """
    def __init__(__self__, autoscaler_user_configs=None, datadog_user_configs=None, endpoint_config=None, endpoint_name=None, endpoint_type=None, external_aws_cloudwatch_logs_user_configs=None, external_aws_cloudwatch_metrics_user_configs=None, external_aws_s3_user_configs=None, external_clickhouse_user_configs=None, external_elasticsearch_logs_user_configs=None, external_google_cloud_bigqueries=None, external_google_cloud_logging_user_configs=None, external_kafka_user_configs=None, external_mysql_user_configs=None, external_opensearch_logs_user_configs=None, external_postgresqls=None, external_prometheus_user_configs=None, external_schema_registry_user_configs=None, id=None, jolokia_user_configs=None, project=None, prometheus_user_configs=None, rsyslog_user_configs=None):
        if autoscaler_user_configs and not isinstance(autoscaler_user_configs, list):
            raise TypeError("Expected argument 'autoscaler_user_configs' to be a list")
        pulumi.set(__self__, "autoscaler_user_configs", autoscaler_user_configs)
        if datadog_user_configs and not isinstance(datadog_user_configs, list):
            raise TypeError("Expected argument 'datadog_user_configs' to be a list")
        pulumi.set(__self__, "datadog_user_configs", datadog_user_configs)
        if endpoint_config and not isinstance(endpoint_config, dict):
            raise TypeError("Expected argument 'endpoint_config' to be a dict")
        pulumi.set(__self__, "endpoint_config", endpoint_config)
        if endpoint_name and not isinstance(endpoint_name, str):
            raise TypeError("Expected argument 'endpoint_name' to be a str")
        pulumi.set(__self__, "endpoint_name", endpoint_name)
        if endpoint_type and not isinstance(endpoint_type, str):
            raise TypeError("Expected argument 'endpoint_type' to be a str")
        pulumi.set(__self__, "endpoint_type", endpoint_type)
        if external_aws_cloudwatch_logs_user_configs and not isinstance(external_aws_cloudwatch_logs_user_configs, list):
            raise TypeError("Expected argument 'external_aws_cloudwatch_logs_user_configs' to be a list")
        pulumi.set(__self__, "external_aws_cloudwatch_logs_user_configs", external_aws_cloudwatch_logs_user_configs)
        if external_aws_cloudwatch_metrics_user_configs and not isinstance(external_aws_cloudwatch_metrics_user_configs, list):
            raise TypeError("Expected argument 'external_aws_cloudwatch_metrics_user_configs' to be a list")
        pulumi.set(__self__, "external_aws_cloudwatch_metrics_user_configs", external_aws_cloudwatch_metrics_user_configs)
        if external_aws_s3_user_configs and not isinstance(external_aws_s3_user_configs, list):
            raise TypeError("Expected argument 'external_aws_s3_user_configs' to be a list")
        pulumi.set(__self__, "external_aws_s3_user_configs", external_aws_s3_user_configs)
        if external_clickhouse_user_configs and not isinstance(external_clickhouse_user_configs, list):
            raise TypeError("Expected argument 'external_clickhouse_user_configs' to be a list")
        pulumi.set(__self__, "external_clickhouse_user_configs", external_clickhouse_user_configs)
        if external_elasticsearch_logs_user_configs and not isinstance(external_elasticsearch_logs_user_configs, list):
            raise TypeError("Expected argument 'external_elasticsearch_logs_user_configs' to be a list")
        pulumi.set(__self__, "external_elasticsearch_logs_user_configs", external_elasticsearch_logs_user_configs)
        if external_google_cloud_bigqueries and not isinstance(external_google_cloud_bigqueries, list):
            raise TypeError("Expected argument 'external_google_cloud_bigqueries' to be a list")
        pulumi.set(__self__, "external_google_cloud_bigqueries", external_google_cloud_bigqueries)
        if external_google_cloud_logging_user_configs and not isinstance(external_google_cloud_logging_user_configs, list):
            raise TypeError("Expected argument 'external_google_cloud_logging_user_configs' to be a list")
        pulumi.set(__self__, "external_google_cloud_logging_user_configs", external_google_cloud_logging_user_configs)
        if external_kafka_user_configs and not isinstance(external_kafka_user_configs, list):
            raise TypeError("Expected argument 'external_kafka_user_configs' to be a list")
        pulumi.set(__self__, "external_kafka_user_configs", external_kafka_user_configs)
        if external_mysql_user_configs and not isinstance(external_mysql_user_configs, list):
            raise TypeError("Expected argument 'external_mysql_user_configs' to be a list")
        pulumi.set(__self__, "external_mysql_user_configs", external_mysql_user_configs)
        if external_opensearch_logs_user_configs and not isinstance(external_opensearch_logs_user_configs, list):
            raise TypeError("Expected argument 'external_opensearch_logs_user_configs' to be a list")
        pulumi.set(__self__, "external_opensearch_logs_user_configs", external_opensearch_logs_user_configs)
        if external_postgresqls and not isinstance(external_postgresqls, list):
            raise TypeError("Expected argument 'external_postgresqls' to be a list")
        pulumi.set(__self__, "external_postgresqls", external_postgresqls)
        if external_prometheus_user_configs and not isinstance(external_prometheus_user_configs, list):
            raise TypeError("Expected argument 'external_prometheus_user_configs' to be a list")
        pulumi.set(__self__, "external_prometheus_user_configs", external_prometheus_user_configs)
        if external_schema_registry_user_configs and not isinstance(external_schema_registry_user_configs, list):
            raise TypeError("Expected argument 'external_schema_registry_user_configs' to be a list")
        pulumi.set(__self__, "external_schema_registry_user_configs", external_schema_registry_user_configs)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if jolokia_user_configs and not isinstance(jolokia_user_configs, list):
            raise TypeError("Expected argument 'jolokia_user_configs' to be a list")
        pulumi.set(__self__, "jolokia_user_configs", jolokia_user_configs)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if prometheus_user_configs and not isinstance(prometheus_user_configs, list):
            raise TypeError("Expected argument 'prometheus_user_configs' to be a list")
        pulumi.set(__self__, "prometheus_user_configs", prometheus_user_configs)
        if rsyslog_user_configs and not isinstance(rsyslog_user_configs, list):
            raise TypeError("Expected argument 'rsyslog_user_configs' to be a list")
        pulumi.set(__self__, "rsyslog_user_configs", rsyslog_user_configs)

    @property
    @pulumi.getter(name="autoscalerUserConfigs")
    def autoscaler_user_configs(self) -> Sequence['outputs.GetServiceIntegrationEndpointAutoscalerUserConfigResult']:
        """
        Autoscaler user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "autoscaler_user_configs")

    @property
    @pulumi.getter(name="datadogUserConfigs")
    def datadog_user_configs(self) -> Sequence['outputs.GetServiceIntegrationEndpointDatadogUserConfigResult']:
        """
        Datadog user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "datadog_user_configs")

    @property
    @pulumi.getter(name="endpointConfig")
    def endpoint_config(self) -> Mapping[str, str]:
        """
        Backend configuration for the endpoint.
        """
        return pulumi.get(self, "endpoint_config")

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> str:
        """
        Name of the service integration endpoint.
        """
        return pulumi.get(self, "endpoint_name")

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> str:
        """
        The type of service integration endpoint. The possible values are `autoscaler`, `datadog`, `external_aws_cloudwatch_logs`, `external_aws_cloudwatch_metrics`, `external_aws_s3`, `external_clickhouse`, `external_elasticsearch_logs`, `external_google_cloud_bigquery`, `external_google_cloud_logging`, `external_kafka`, `external_mysql`, `external_opensearch_logs`, `external_postgresql`, `external_prometheus`, `external_redis`, `external_schema_registry`, `external_sumologic_logs`, `jolokia`, `prometheus` and `rsyslog`.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="externalAwsCloudwatchLogsUserConfigs")
    def external_aws_cloudwatch_logs_user_configs(self) -> Sequence['outputs.GetServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfigResult']:
        """
        ExternalAwsCloudwatchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_aws_cloudwatch_logs_user_configs")

    @property
    @pulumi.getter(name="externalAwsCloudwatchMetricsUserConfigs")
    def external_aws_cloudwatch_metrics_user_configs(self) -> Sequence['outputs.GetServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfigResult']:
        """
        ExternalAwsCloudwatchMetrics user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_aws_cloudwatch_metrics_user_configs")

    @property
    @pulumi.getter(name="externalAwsS3UserConfigs")
    def external_aws_s3_user_configs(self) -> Sequence['outputs.GetServiceIntegrationEndpointExternalAwsS3UserConfigResult']:
        """
        ExternalAwsS3 user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_aws_s3_user_configs")

    @property
    @pulumi.getter(name="externalClickhouseUserConfigs")
    def external_clickhouse_user_configs(self) -> Sequence['outputs.GetServiceIntegrationEndpointExternalClickhouseUserConfigResult']:
        """
        ExternalClickhouse user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_clickhouse_user_configs")

    @property
    @pulumi.getter(name="externalElasticsearchLogsUserConfigs")
    def external_elasticsearch_logs_user_configs(self) -> Sequence['outputs.GetServiceIntegrationEndpointExternalElasticsearchLogsUserConfigResult']:
        """
        ExternalElasticsearchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_elasticsearch_logs_user_configs")

    @property
    @pulumi.getter(name="externalGoogleCloudBigqueries")
    def external_google_cloud_bigqueries(self) -> Sequence['outputs.GetServiceIntegrationEndpointExternalGoogleCloudBigqueryResult']:
        """
        ExternalGoogleCloudBigquery user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_google_cloud_bigqueries")

    @property
    @pulumi.getter(name="externalGoogleCloudLoggingUserConfigs")
    def external_google_cloud_logging_user_configs(self) -> Sequence['outputs.GetServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfigResult']:
        """
        ExternalGoogleCloudLogging user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_google_cloud_logging_user_configs")

    @property
    @pulumi.getter(name="externalKafkaUserConfigs")
    def external_kafka_user_configs(self) -> Sequence['outputs.GetServiceIntegrationEndpointExternalKafkaUserConfigResult']:
        """
        ExternalKafka user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_kafka_user_configs")

    @property
    @pulumi.getter(name="externalMysqlUserConfigs")
    def external_mysql_user_configs(self) -> Sequence['outputs.GetServiceIntegrationEndpointExternalMysqlUserConfigResult']:
        """
        ExternalMysql user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_mysql_user_configs")

    @property
    @pulumi.getter(name="externalOpensearchLogsUserConfigs")
    def external_opensearch_logs_user_configs(self) -> Sequence['outputs.GetServiceIntegrationEndpointExternalOpensearchLogsUserConfigResult']:
        """
        ExternalOpensearchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_opensearch_logs_user_configs")

    @property
    @pulumi.getter(name="externalPostgresqls")
    def external_postgresqls(self) -> Sequence['outputs.GetServiceIntegrationEndpointExternalPostgresqlResult']:
        """
        ExternalPostgresql user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_postgresqls")

    @property
    @pulumi.getter(name="externalPrometheusUserConfigs")
    def external_prometheus_user_configs(self) -> Sequence['outputs.GetServiceIntegrationEndpointExternalPrometheusUserConfigResult']:
        """
        ExternalPrometheus user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_prometheus_user_configs")

    @property
    @pulumi.getter(name="externalSchemaRegistryUserConfigs")
    def external_schema_registry_user_configs(self) -> Sequence['outputs.GetServiceIntegrationEndpointExternalSchemaRegistryUserConfigResult']:
        """
        ExternalSchemaRegistry user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_schema_registry_user_configs")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="jolokiaUserConfigs")
    def jolokia_user_configs(self) -> Sequence['outputs.GetServiceIntegrationEndpointJolokiaUserConfigResult']:
        """
        Jolokia user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "jolokia_user_configs")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        Project the service integration endpoint is in.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="prometheusUserConfigs")
    def prometheus_user_configs(self) -> Sequence['outputs.GetServiceIntegrationEndpointPrometheusUserConfigResult']:
        """
        Prometheus user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "prometheus_user_configs")

    @property
    @pulumi.getter(name="rsyslogUserConfigs")
    def rsyslog_user_configs(self) -> Sequence['outputs.GetServiceIntegrationEndpointRsyslogUserConfigResult']:
        """
        Rsyslog user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "rsyslog_user_configs")


class AwaitableGetServiceIntegrationEndpointResult(GetServiceIntegrationEndpointResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceIntegrationEndpointResult(
            autoscaler_user_configs=self.autoscaler_user_configs,
            datadog_user_configs=self.datadog_user_configs,
            endpoint_config=self.endpoint_config,
            endpoint_name=self.endpoint_name,
            endpoint_type=self.endpoint_type,
            external_aws_cloudwatch_logs_user_configs=self.external_aws_cloudwatch_logs_user_configs,
            external_aws_cloudwatch_metrics_user_configs=self.external_aws_cloudwatch_metrics_user_configs,
            external_aws_s3_user_configs=self.external_aws_s3_user_configs,
            external_clickhouse_user_configs=self.external_clickhouse_user_configs,
            external_elasticsearch_logs_user_configs=self.external_elasticsearch_logs_user_configs,
            external_google_cloud_bigqueries=self.external_google_cloud_bigqueries,
            external_google_cloud_logging_user_configs=self.external_google_cloud_logging_user_configs,
            external_kafka_user_configs=self.external_kafka_user_configs,
            external_mysql_user_configs=self.external_mysql_user_configs,
            external_opensearch_logs_user_configs=self.external_opensearch_logs_user_configs,
            external_postgresqls=self.external_postgresqls,
            external_prometheus_user_configs=self.external_prometheus_user_configs,
            external_schema_registry_user_configs=self.external_schema_registry_user_configs,
            id=self.id,
            jolokia_user_configs=self.jolokia_user_configs,
            project=self.project,
            prometheus_user_configs=self.prometheus_user_configs,
            rsyslog_user_configs=self.rsyslog_user_configs)


def get_service_integration_endpoint(endpoint_name: Optional[str] = None,
                                     project: Optional[str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceIntegrationEndpointResult:
    """
    Gets information about an integration endpoint.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    example_datadog_endpoint = aiven.get_service_integration_endpoint(project=example_project["project"],
        endpoint_name="Datadog endpoint")
    ```


    :param str endpoint_name: Name of the service integration endpoint.
    :param str project: Project the service integration endpoint is in.
    """
    __args__ = dict()
    __args__['endpointName'] = endpoint_name
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aiven:index/getServiceIntegrationEndpoint:getServiceIntegrationEndpoint', __args__, opts=opts, typ=GetServiceIntegrationEndpointResult).value

    return AwaitableGetServiceIntegrationEndpointResult(
        autoscaler_user_configs=pulumi.get(__ret__, 'autoscaler_user_configs'),
        datadog_user_configs=pulumi.get(__ret__, 'datadog_user_configs'),
        endpoint_config=pulumi.get(__ret__, 'endpoint_config'),
        endpoint_name=pulumi.get(__ret__, 'endpoint_name'),
        endpoint_type=pulumi.get(__ret__, 'endpoint_type'),
        external_aws_cloudwatch_logs_user_configs=pulumi.get(__ret__, 'external_aws_cloudwatch_logs_user_configs'),
        external_aws_cloudwatch_metrics_user_configs=pulumi.get(__ret__, 'external_aws_cloudwatch_metrics_user_configs'),
        external_aws_s3_user_configs=pulumi.get(__ret__, 'external_aws_s3_user_configs'),
        external_clickhouse_user_configs=pulumi.get(__ret__, 'external_clickhouse_user_configs'),
        external_elasticsearch_logs_user_configs=pulumi.get(__ret__, 'external_elasticsearch_logs_user_configs'),
        external_google_cloud_bigqueries=pulumi.get(__ret__, 'external_google_cloud_bigqueries'),
        external_google_cloud_logging_user_configs=pulumi.get(__ret__, 'external_google_cloud_logging_user_configs'),
        external_kafka_user_configs=pulumi.get(__ret__, 'external_kafka_user_configs'),
        external_mysql_user_configs=pulumi.get(__ret__, 'external_mysql_user_configs'),
        external_opensearch_logs_user_configs=pulumi.get(__ret__, 'external_opensearch_logs_user_configs'),
        external_postgresqls=pulumi.get(__ret__, 'external_postgresqls'),
        external_prometheus_user_configs=pulumi.get(__ret__, 'external_prometheus_user_configs'),
        external_schema_registry_user_configs=pulumi.get(__ret__, 'external_schema_registry_user_configs'),
        id=pulumi.get(__ret__, 'id'),
        jolokia_user_configs=pulumi.get(__ret__, 'jolokia_user_configs'),
        project=pulumi.get(__ret__, 'project'),
        prometheus_user_configs=pulumi.get(__ret__, 'prometheus_user_configs'),
        rsyslog_user_configs=pulumi.get(__ret__, 'rsyslog_user_configs'))
def get_service_integration_endpoint_output(endpoint_name: Optional[pulumi.Input[str]] = None,
                                            project: Optional[pulumi.Input[str]] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetServiceIntegrationEndpointResult]:
    """
    Gets information about an integration endpoint.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    example_datadog_endpoint = aiven.get_service_integration_endpoint(project=example_project["project"],
        endpoint_name="Datadog endpoint")
    ```


    :param str endpoint_name: Name of the service integration endpoint.
    :param str project: Project the service integration endpoint is in.
    """
    __args__ = dict()
    __args__['endpointName'] = endpoint_name
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aiven:index/getServiceIntegrationEndpoint:getServiceIntegrationEndpoint', __args__, opts=opts, typ=GetServiceIntegrationEndpointResult)
    return __ret__.apply(lambda __response__: GetServiceIntegrationEndpointResult(
        autoscaler_user_configs=pulumi.get(__response__, 'autoscaler_user_configs'),
        datadog_user_configs=pulumi.get(__response__, 'datadog_user_configs'),
        endpoint_config=pulumi.get(__response__, 'endpoint_config'),
        endpoint_name=pulumi.get(__response__, 'endpoint_name'),
        endpoint_type=pulumi.get(__response__, 'endpoint_type'),
        external_aws_cloudwatch_logs_user_configs=pulumi.get(__response__, 'external_aws_cloudwatch_logs_user_configs'),
        external_aws_cloudwatch_metrics_user_configs=pulumi.get(__response__, 'external_aws_cloudwatch_metrics_user_configs'),
        external_aws_s3_user_configs=pulumi.get(__response__, 'external_aws_s3_user_configs'),
        external_clickhouse_user_configs=pulumi.get(__response__, 'external_clickhouse_user_configs'),
        external_elasticsearch_logs_user_configs=pulumi.get(__response__, 'external_elasticsearch_logs_user_configs'),
        external_google_cloud_bigqueries=pulumi.get(__response__, 'external_google_cloud_bigqueries'),
        external_google_cloud_logging_user_configs=pulumi.get(__response__, 'external_google_cloud_logging_user_configs'),
        external_kafka_user_configs=pulumi.get(__response__, 'external_kafka_user_configs'),
        external_mysql_user_configs=pulumi.get(__response__, 'external_mysql_user_configs'),
        external_opensearch_logs_user_configs=pulumi.get(__response__, 'external_opensearch_logs_user_configs'),
        external_postgresqls=pulumi.get(__response__, 'external_postgresqls'),
        external_prometheus_user_configs=pulumi.get(__response__, 'external_prometheus_user_configs'),
        external_schema_registry_user_configs=pulumi.get(__response__, 'external_schema_registry_user_configs'),
        id=pulumi.get(__response__, 'id'),
        jolokia_user_configs=pulumi.get(__response__, 'jolokia_user_configs'),
        project=pulumi.get(__response__, 'project'),
        prometheus_user_configs=pulumi.get(__response__, 'prometheus_user_configs'),
        rsyslog_user_configs=pulumi.get(__response__, 'rsyslog_user_configs')))
