# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetValkeyUserResult',
    'AwaitableGetValkeyUserResult',
    'get_valkey_user',
    'get_valkey_user_output',
]

@pulumi.output_type
class GetValkeyUserResult:
    """
    A collection of values returned by getValkeyUser.
    """
    def __init__(__self__, id=None, password=None, project=None, service_name=None, type=None, username=None, valkey_acl_categories=None, valkey_acl_channels=None, valkey_acl_commands=None, valkey_acl_keys=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if password and not isinstance(password, str):
            raise TypeError("Expected argument 'password' to be a str")
        pulumi.set(__self__, "password", password)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)
        if valkey_acl_categories and not isinstance(valkey_acl_categories, list):
            raise TypeError("Expected argument 'valkey_acl_categories' to be a list")
        pulumi.set(__self__, "valkey_acl_categories", valkey_acl_categories)
        if valkey_acl_channels and not isinstance(valkey_acl_channels, list):
            raise TypeError("Expected argument 'valkey_acl_channels' to be a list")
        pulumi.set(__self__, "valkey_acl_channels", valkey_acl_channels)
        if valkey_acl_commands and not isinstance(valkey_acl_commands, list):
            raise TypeError("Expected argument 'valkey_acl_commands' to be a list")
        pulumi.set(__self__, "valkey_acl_commands", valkey_acl_commands)
        if valkey_acl_keys and not isinstance(valkey_acl_keys, list):
            raise TypeError("Expected argument 'valkey_acl_keys' to be a list")
        pulumi.set(__self__, "valkey_acl_keys", valkey_acl_keys)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The password of the Valkey User.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        """
        The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the user account. Tells whether the user is the primary account or a regular account.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The actual name of the Valkey User. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="valkeyAclCategories")
    def valkey_acl_categories(self) -> Sequence[str]:
        """
        Defines command category rules. The field is required with`valkey_acl_commands` and `valkey_acl_keys`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "valkey_acl_categories")

    @property
    @pulumi.getter(name="valkeyAclChannels")
    def valkey_acl_channels(self) -> Sequence[str]:
        """
        Defines the permitted pub/sub channel patterns. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "valkey_acl_channels")

    @property
    @pulumi.getter(name="valkeyAclCommands")
    def valkey_acl_commands(self) -> Sequence[str]:
        """
        Defines rules for individual commands. The field is required with`valkey_acl_categories` and `valkey_acl_keys`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "valkey_acl_commands")

    @property
    @pulumi.getter(name="valkeyAclKeys")
    def valkey_acl_keys(self) -> Sequence[str]:
        """
        Defines key access rules. The field is required with`valkey_acl_categories` and `valkey_acl_keys`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "valkey_acl_keys")


class AwaitableGetValkeyUserResult(GetValkeyUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetValkeyUserResult(
            id=self.id,
            password=self.password,
            project=self.project,
            service_name=self.service_name,
            type=self.type,
            username=self.username,
            valkey_acl_categories=self.valkey_acl_categories,
            valkey_acl_channels=self.valkey_acl_channels,
            valkey_acl_commands=self.valkey_acl_commands,
            valkey_acl_keys=self.valkey_acl_keys)


def get_valkey_user(project: Optional[str] = None,
                    service_name: Optional[str] = None,
                    username: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetValkeyUserResult:
    """
    The Valkey User data source provides information about the existing Aiven for Valkey user.


    :param str project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param str service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param str username: The actual name of the Valkey User. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['serviceName'] = service_name
    __args__['username'] = username
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aiven:index/getValkeyUser:getValkeyUser', __args__, opts=opts, typ=GetValkeyUserResult).value

    return AwaitableGetValkeyUserResult(
        id=pulumi.get(__ret__, 'id'),
        password=pulumi.get(__ret__, 'password'),
        project=pulumi.get(__ret__, 'project'),
        service_name=pulumi.get(__ret__, 'service_name'),
        type=pulumi.get(__ret__, 'type'),
        username=pulumi.get(__ret__, 'username'),
        valkey_acl_categories=pulumi.get(__ret__, 'valkey_acl_categories'),
        valkey_acl_channels=pulumi.get(__ret__, 'valkey_acl_channels'),
        valkey_acl_commands=pulumi.get(__ret__, 'valkey_acl_commands'),
        valkey_acl_keys=pulumi.get(__ret__, 'valkey_acl_keys'))
def get_valkey_user_output(project: Optional[pulumi.Input[str]] = None,
                           service_name: Optional[pulumi.Input[str]] = None,
                           username: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetValkeyUserResult]:
    """
    The Valkey User data source provides information about the existing Aiven for Valkey user.


    :param str project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param str service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param str username: The actual name of the Valkey User. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['serviceName'] = service_name
    __args__['username'] = username
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aiven:index/getValkeyUser:getValkeyUser', __args__, opts=opts, typ=GetValkeyUserResult)
    return __ret__.apply(lambda __response__: GetValkeyUserResult(
        id=pulumi.get(__response__, 'id'),
        password=pulumi.get(__response__, 'password'),
        project=pulumi.get(__response__, 'project'),
        service_name=pulumi.get(__response__, 'service_name'),
        type=pulumi.get(__response__, 'type'),
        username=pulumi.get(__response__, 'username'),
        valkey_acl_categories=pulumi.get(__response__, 'valkey_acl_categories'),
        valkey_acl_channels=pulumi.get(__response__, 'valkey_acl_channels'),
        valkey_acl_commands=pulumi.get(__response__, 'valkey_acl_commands'),
        valkey_acl_keys=pulumi.get(__response__, 'valkey_acl_keys')))
