# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['OrganizationApplicationUserTokenArgs', 'OrganizationApplicationUserToken']

@pulumi.input_type
class OrganizationApplicationUserTokenArgs:
    def __init__(__self__, *,
                 organization_id: pulumi.Input[str],
                 user_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 extend_when_used: Optional[pulumi.Input[bool]] = None,
                 max_age_seconds: Optional[pulumi.Input[int]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a OrganizationApplicationUserToken resource.
        :param pulumi.Input[str] organization_id: The ID of the organization the application user belongs to.
        :param pulumi.Input[str] user_id: The ID of the application user the token is created for.
        :param pulumi.Input[str] description: Description of the token.
        :param pulumi.Input[bool] extend_when_used: Extends the token session duration when the token is used. Only applicable if a value is set for `max_age_seconds`.
        :param pulumi.Input[int] max_age_seconds: The number of hours after which a token expires. Default session duration is 10 hours.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scopes: Limits access to specific resources by granting read or write privileges to them. For example: `billing:read`. Available scopes are: `authentication`, `billing`, `payments` for [payment methods](https://aiven.io/docs/platform/howto/list-billing), `privatelink`, `projects`, `services`, `static_ips`, and `user`.
        """
        pulumi.set(__self__, "organization_id", organization_id)
        pulumi.set(__self__, "user_id", user_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if extend_when_used is not None:
            pulumi.set(__self__, "extend_when_used", extend_when_used)
        if max_age_seconds is not None:
            pulumi.set(__self__, "max_age_seconds", max_age_seconds)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Input[str]:
        """
        The ID of the organization the application user belongs to.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Input[str]:
        """
        The ID of the application user the token is created for.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the token.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="extendWhenUsed")
    def extend_when_used(self) -> Optional[pulumi.Input[bool]]:
        """
        Extends the token session duration when the token is used. Only applicable if a value is set for `max_age_seconds`.
        """
        return pulumi.get(self, "extend_when_used")

    @extend_when_used.setter
    def extend_when_used(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "extend_when_used", value)

    @property
    @pulumi.getter(name="maxAgeSeconds")
    def max_age_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The number of hours after which a token expires. Default session duration is 10 hours.
        """
        return pulumi.get(self, "max_age_seconds")

    @max_age_seconds.setter
    def max_age_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_age_seconds", value)

    @property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Limits access to specific resources by granting read or write privileges to them. For example: `billing:read`. Available scopes are: `authentication`, `billing`, `payments` for [payment methods](https://aiven.io/docs/platform/howto/list-billing), `privatelink`, `projects`, `services`, `static_ips`, and `user`.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "scopes", value)


@pulumi.input_type
class _OrganizationApplicationUserTokenState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[str]] = None,
                 created_manually: Optional[pulumi.Input[bool]] = None,
                 currently_active: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 expiry_time: Optional[pulumi.Input[str]] = None,
                 extend_when_used: Optional[pulumi.Input[bool]] = None,
                 full_token: Optional[pulumi.Input[str]] = None,
                 last_ip: Optional[pulumi.Input[str]] = None,
                 last_used_time: Optional[pulumi.Input[str]] = None,
                 last_user_agent: Optional[pulumi.Input[str]] = None,
                 last_user_agent_human_readable: Optional[pulumi.Input[str]] = None,
                 max_age_seconds: Optional[pulumi.Input[int]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 token_prefix: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering OrganizationApplicationUserToken resources.
        :param pulumi.Input[str] create_time: Time when the token was created.
        :param pulumi.Input[bool] created_manually: True for tokens explicitly created using the `access_tokens` API. False for tokens created when a user logs in.
        :param pulumi.Input[bool] currently_active: True if the API request was made with this token.
        :param pulumi.Input[str] description: Description of the token.
        :param pulumi.Input[str] expiry_time: Timestamp when the access token will expire unless extended.
        :param pulumi.Input[bool] extend_when_used: Extends the token session duration when the token is used. Only applicable if a value is set for `max_age_seconds`.
        :param pulumi.Input[str] full_token: Full token.
        :param pulumi.Input[str] last_ip: IP address of the last request made with this token.
        :param pulumi.Input[str] last_used_time: Timestamp when the access token was last used.
        :param pulumi.Input[str] last_user_agent: User agent of the last request made with this token.
        :param pulumi.Input[str] last_user_agent_human_readable: User agent of the last request made with this token in human-readable format.
        :param pulumi.Input[int] max_age_seconds: The number of hours after which a token expires. Default session duration is 10 hours.
        :param pulumi.Input[str] organization_id: The ID of the organization the application user belongs to.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scopes: Limits access to specific resources by granting read or write privileges to them. For example: `billing:read`. Available scopes are: `authentication`, `billing`, `payments` for [payment methods](https://aiven.io/docs/platform/howto/list-billing), `privatelink`, `projects`, `services`, `static_ips`, and `user`.
        :param pulumi.Input[str] token_prefix: Prefix of the token.
        :param pulumi.Input[str] user_id: The ID of the application user the token is created for.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if created_manually is not None:
            pulumi.set(__self__, "created_manually", created_manually)
        if currently_active is not None:
            pulumi.set(__self__, "currently_active", currently_active)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expiry_time is not None:
            pulumi.set(__self__, "expiry_time", expiry_time)
        if extend_when_used is not None:
            pulumi.set(__self__, "extend_when_used", extend_when_used)
        if full_token is not None:
            pulumi.set(__self__, "full_token", full_token)
        if last_ip is not None:
            pulumi.set(__self__, "last_ip", last_ip)
        if last_used_time is not None:
            pulumi.set(__self__, "last_used_time", last_used_time)
        if last_user_agent is not None:
            pulumi.set(__self__, "last_user_agent", last_user_agent)
        if last_user_agent_human_readable is not None:
            pulumi.set(__self__, "last_user_agent_human_readable", last_user_agent_human_readable)
        if max_age_seconds is not None:
            pulumi.set(__self__, "max_age_seconds", max_age_seconds)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if token_prefix is not None:
            pulumi.set(__self__, "token_prefix", token_prefix)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time when the token was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="createdManually")
    def created_manually(self) -> Optional[pulumi.Input[bool]]:
        """
        True for tokens explicitly created using the `access_tokens` API. False for tokens created when a user logs in.
        """
        return pulumi.get(self, "created_manually")

    @created_manually.setter
    def created_manually(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "created_manually", value)

    @property
    @pulumi.getter(name="currentlyActive")
    def currently_active(self) -> Optional[pulumi.Input[bool]]:
        """
        True if the API request was made with this token.
        """
        return pulumi.get(self, "currently_active")

    @currently_active.setter
    def currently_active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "currently_active", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the token.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="expiryTime")
    def expiry_time(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp when the access token will expire unless extended.
        """
        return pulumi.get(self, "expiry_time")

    @expiry_time.setter
    def expiry_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiry_time", value)

    @property
    @pulumi.getter(name="extendWhenUsed")
    def extend_when_used(self) -> Optional[pulumi.Input[bool]]:
        """
        Extends the token session duration when the token is used. Only applicable if a value is set for `max_age_seconds`.
        """
        return pulumi.get(self, "extend_when_used")

    @extend_when_used.setter
    def extend_when_used(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "extend_when_used", value)

    @property
    @pulumi.getter(name="fullToken")
    def full_token(self) -> Optional[pulumi.Input[str]]:
        """
        Full token.
        """
        return pulumi.get(self, "full_token")

    @full_token.setter
    def full_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "full_token", value)

    @property
    @pulumi.getter(name="lastIp")
    def last_ip(self) -> Optional[pulumi.Input[str]]:
        """
        IP address of the last request made with this token.
        """
        return pulumi.get(self, "last_ip")

    @last_ip.setter
    def last_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_ip", value)

    @property
    @pulumi.getter(name="lastUsedTime")
    def last_used_time(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp when the access token was last used.
        """
        return pulumi.get(self, "last_used_time")

    @last_used_time.setter
    def last_used_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_used_time", value)

    @property
    @pulumi.getter(name="lastUserAgent")
    def last_user_agent(self) -> Optional[pulumi.Input[str]]:
        """
        User agent of the last request made with this token.
        """
        return pulumi.get(self, "last_user_agent")

    @last_user_agent.setter
    def last_user_agent(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_user_agent", value)

    @property
    @pulumi.getter(name="lastUserAgentHumanReadable")
    def last_user_agent_human_readable(self) -> Optional[pulumi.Input[str]]:
        """
        User agent of the last request made with this token in human-readable format.
        """
        return pulumi.get(self, "last_user_agent_human_readable")

    @last_user_agent_human_readable.setter
    def last_user_agent_human_readable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_user_agent_human_readable", value)

    @property
    @pulumi.getter(name="maxAgeSeconds")
    def max_age_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The number of hours after which a token expires. Default session duration is 10 hours.
        """
        return pulumi.get(self, "max_age_seconds")

    @max_age_seconds.setter
    def max_age_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_age_seconds", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the organization the application user belongs to.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Limits access to specific resources by granting read or write privileges to them. For example: `billing:read`. Available scopes are: `authentication`, `billing`, `payments` for [payment methods](https://aiven.io/docs/platform/howto/list-billing), `privatelink`, `projects`, `services`, `static_ips`, and `user`.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "scopes", value)

    @property
    @pulumi.getter(name="tokenPrefix")
    def token_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Prefix of the token.
        """
        return pulumi.get(self, "token_prefix")

    @token_prefix.setter
    def token_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token_prefix", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the application user the token is created for.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_id", value)


class OrganizationApplicationUserToken(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 extend_when_used: Optional[pulumi.Input[bool]] = None,
                 max_age_seconds: Optional[pulumi.Input[int]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates and manages an application user token. Review the [best practices](https://aiven.io/docs/platform/concepts/application-users#security-best-practices) for securing application users and their tokens.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        tf_user = aiven.OrganizationApplicationUser("tf_user",
            organization_id=main["id"],
            name="app-terraform")
        example = aiven.OrganizationApplicationUserToken("example",
            organization_id=main["id"],
            user_id=tf_user.user_id,
            description="Token for TF access to Aiven.")
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/organizationApplicationUserToken:OrganizationApplicationUserToken example ORGANIZATION_ID/USER_ID/TOKEN_PREFIX
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of the token.
        :param pulumi.Input[bool] extend_when_used: Extends the token session duration when the token is used. Only applicable if a value is set for `max_age_seconds`.
        :param pulumi.Input[int] max_age_seconds: The number of hours after which a token expires. Default session duration is 10 hours.
        :param pulumi.Input[str] organization_id: The ID of the organization the application user belongs to.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scopes: Limits access to specific resources by granting read or write privileges to them. For example: `billing:read`. Available scopes are: `authentication`, `billing`, `payments` for [payment methods](https://aiven.io/docs/platform/howto/list-billing), `privatelink`, `projects`, `services`, `static_ips`, and `user`.
        :param pulumi.Input[str] user_id: The ID of the application user the token is created for.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OrganizationApplicationUserTokenArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages an application user token. Review the [best practices](https://aiven.io/docs/platform/concepts/application-users#security-best-practices) for securing application users and their tokens.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        tf_user = aiven.OrganizationApplicationUser("tf_user",
            organization_id=main["id"],
            name="app-terraform")
        example = aiven.OrganizationApplicationUserToken("example",
            organization_id=main["id"],
            user_id=tf_user.user_id,
            description="Token for TF access to Aiven.")
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/organizationApplicationUserToken:OrganizationApplicationUserToken example ORGANIZATION_ID/USER_ID/TOKEN_PREFIX
        ```

        :param str resource_name: The name of the resource.
        :param OrganizationApplicationUserTokenArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationApplicationUserTokenArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 extend_when_used: Optional[pulumi.Input[bool]] = None,
                 max_age_seconds: Optional[pulumi.Input[int]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationApplicationUserTokenArgs.__new__(OrganizationApplicationUserTokenArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["extend_when_used"] = extend_when_used
            __props__.__dict__["max_age_seconds"] = max_age_seconds
            if organization_id is None and not opts.urn:
                raise TypeError("Missing required property 'organization_id'")
            __props__.__dict__["organization_id"] = organization_id
            __props__.__dict__["scopes"] = scopes
            if user_id is None and not opts.urn:
                raise TypeError("Missing required property 'user_id'")
            __props__.__dict__["user_id"] = user_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["created_manually"] = None
            __props__.__dict__["currently_active"] = None
            __props__.__dict__["expiry_time"] = None
            __props__.__dict__["full_token"] = None
            __props__.__dict__["last_ip"] = None
            __props__.__dict__["last_used_time"] = None
            __props__.__dict__["last_user_agent"] = None
            __props__.__dict__["last_user_agent_human_readable"] = None
            __props__.__dict__["token_prefix"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["fullToken"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(OrganizationApplicationUserToken, __self__).__init__(
            'aiven:index/organizationApplicationUserToken:OrganizationApplicationUserToken',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            created_manually: Optional[pulumi.Input[bool]] = None,
            currently_active: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            expiry_time: Optional[pulumi.Input[str]] = None,
            extend_when_used: Optional[pulumi.Input[bool]] = None,
            full_token: Optional[pulumi.Input[str]] = None,
            last_ip: Optional[pulumi.Input[str]] = None,
            last_used_time: Optional[pulumi.Input[str]] = None,
            last_user_agent: Optional[pulumi.Input[str]] = None,
            last_user_agent_human_readable: Optional[pulumi.Input[str]] = None,
            max_age_seconds: Optional[pulumi.Input[int]] = None,
            organization_id: Optional[pulumi.Input[str]] = None,
            scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            token_prefix: Optional[pulumi.Input[str]] = None,
            user_id: Optional[pulumi.Input[str]] = None) -> 'OrganizationApplicationUserToken':
        """
        Get an existing OrganizationApplicationUserToken resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] create_time: Time when the token was created.
        :param pulumi.Input[bool] created_manually: True for tokens explicitly created using the `access_tokens` API. False for tokens created when a user logs in.
        :param pulumi.Input[bool] currently_active: True if the API request was made with this token.
        :param pulumi.Input[str] description: Description of the token.
        :param pulumi.Input[str] expiry_time: Timestamp when the access token will expire unless extended.
        :param pulumi.Input[bool] extend_when_used: Extends the token session duration when the token is used. Only applicable if a value is set for `max_age_seconds`.
        :param pulumi.Input[str] full_token: Full token.
        :param pulumi.Input[str] last_ip: IP address of the last request made with this token.
        :param pulumi.Input[str] last_used_time: Timestamp when the access token was last used.
        :param pulumi.Input[str] last_user_agent: User agent of the last request made with this token.
        :param pulumi.Input[str] last_user_agent_human_readable: User agent of the last request made with this token in human-readable format.
        :param pulumi.Input[int] max_age_seconds: The number of hours after which a token expires. Default session duration is 10 hours.
        :param pulumi.Input[str] organization_id: The ID of the organization the application user belongs to.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scopes: Limits access to specific resources by granting read or write privileges to them. For example: `billing:read`. Available scopes are: `authentication`, `billing`, `payments` for [payment methods](https://aiven.io/docs/platform/howto/list-billing), `privatelink`, `projects`, `services`, `static_ips`, and `user`.
        :param pulumi.Input[str] token_prefix: Prefix of the token.
        :param pulumi.Input[str] user_id: The ID of the application user the token is created for.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrganizationApplicationUserTokenState.__new__(_OrganizationApplicationUserTokenState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["created_manually"] = created_manually
        __props__.__dict__["currently_active"] = currently_active
        __props__.__dict__["description"] = description
        __props__.__dict__["expiry_time"] = expiry_time
        __props__.__dict__["extend_when_used"] = extend_when_used
        __props__.__dict__["full_token"] = full_token
        __props__.__dict__["last_ip"] = last_ip
        __props__.__dict__["last_used_time"] = last_used_time
        __props__.__dict__["last_user_agent"] = last_user_agent
        __props__.__dict__["last_user_agent_human_readable"] = last_user_agent_human_readable
        __props__.__dict__["max_age_seconds"] = max_age_seconds
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["scopes"] = scopes
        __props__.__dict__["token_prefix"] = token_prefix
        __props__.__dict__["user_id"] = user_id
        return OrganizationApplicationUserToken(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Time when the token was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="createdManually")
    def created_manually(self) -> pulumi.Output[bool]:
        """
        True for tokens explicitly created using the `access_tokens` API. False for tokens created when a user logs in.
        """
        return pulumi.get(self, "created_manually")

    @property
    @pulumi.getter(name="currentlyActive")
    def currently_active(self) -> pulumi.Output[bool]:
        """
        True if the API request was made with this token.
        """
        return pulumi.get(self, "currently_active")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the token.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="expiryTime")
    def expiry_time(self) -> pulumi.Output[str]:
        """
        Timestamp when the access token will expire unless extended.
        """
        return pulumi.get(self, "expiry_time")

    @property
    @pulumi.getter(name="extendWhenUsed")
    def extend_when_used(self) -> pulumi.Output[Optional[bool]]:
        """
        Extends the token session duration when the token is used. Only applicable if a value is set for `max_age_seconds`.
        """
        return pulumi.get(self, "extend_when_used")

    @property
    @pulumi.getter(name="fullToken")
    def full_token(self) -> pulumi.Output[str]:
        """
        Full token.
        """
        return pulumi.get(self, "full_token")

    @property
    @pulumi.getter(name="lastIp")
    def last_ip(self) -> pulumi.Output[str]:
        """
        IP address of the last request made with this token.
        """
        return pulumi.get(self, "last_ip")

    @property
    @pulumi.getter(name="lastUsedTime")
    def last_used_time(self) -> pulumi.Output[str]:
        """
        Timestamp when the access token was last used.
        """
        return pulumi.get(self, "last_used_time")

    @property
    @pulumi.getter(name="lastUserAgent")
    def last_user_agent(self) -> pulumi.Output[str]:
        """
        User agent of the last request made with this token.
        """
        return pulumi.get(self, "last_user_agent")

    @property
    @pulumi.getter(name="lastUserAgentHumanReadable")
    def last_user_agent_human_readable(self) -> pulumi.Output[str]:
        """
        User agent of the last request made with this token in human-readable format.
        """
        return pulumi.get(self, "last_user_agent_human_readable")

    @property
    @pulumi.getter(name="maxAgeSeconds")
    def max_age_seconds(self) -> pulumi.Output[Optional[int]]:
        """
        The number of hours after which a token expires. Default session duration is 10 hours.
        """
        return pulumi.get(self, "max_age_seconds")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[str]:
        """
        The ID of the organization the application user belongs to.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter
    def scopes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Limits access to specific resources by granting read or write privileges to them. For example: `billing:read`. Available scopes are: `authentication`, `billing`, `payments` for [payment methods](https://aiven.io/docs/platform/howto/list-billing), `privatelink`, `projects`, `services`, `static_ips`, and `user`.
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter(name="tokenPrefix")
    def token_prefix(self) -> pulumi.Output[str]:
        """
        Prefix of the token.
        """
        return pulumi.get(self, "token_prefix")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[str]:
        """
        The ID of the application user the token is created for.
        """
        return pulumi.get(self, "user_id")

