# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['OrganizationUserArgs', 'OrganizationUser']

@pulumi.input_type
class OrganizationUserArgs:
    def __init__(__self__, *,
                 organization_id: pulumi.Input[str],
                 user_email: pulumi.Input[str]):
        """
        The set of arguments for constructing a OrganizationUser resource.
        :param pulumi.Input[str] organization_id: The unique organization ID. Changing this property forces recreation of the resource.
        :param pulumi.Input[str] user_email: This is a user email address that first will be invited, and after accepting an invitation, they become a member of the organization. Should be lowercase. Changing this property forces recreation of the resource.
        """
        pulumi.set(__self__, "organization_id", organization_id)
        pulumi.set(__self__, "user_email", user_email)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Input[str]:
        """
        The unique organization ID. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter(name="userEmail")
    def user_email(self) -> pulumi.Input[str]:
        """
        This is a user email address that first will be invited, and after accepting an invitation, they become a member of the organization. Should be lowercase. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "user_email")

    @user_email.setter
    def user_email(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_email", value)


@pulumi.input_type
class _OrganizationUserState:
    def __init__(__self__, *,
                 accepted: Optional[pulumi.Input[bool]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 invited_by: Optional[pulumi.Input[str]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 user_email: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering OrganizationUser resources.
        :param pulumi.Input[bool] accepted: This is a boolean flag that determines whether an invitation was accepted or not by the user. `false` value means that the invitation was sent to the user but not yet accepted. `true` means that the user accepted the invitation and now a member of an organization.
        :param pulumi.Input[str] create_time: Time of creation
        :param pulumi.Input[str] invited_by: The email address of the user who sent an invitation to the user.
        :param pulumi.Input[str] organization_id: The unique organization ID. Changing this property forces recreation of the resource.
        :param pulumi.Input[str] user_email: This is a user email address that first will be invited, and after accepting an invitation, they become a member of the organization. Should be lowercase. Changing this property forces recreation of the resource.
        :param pulumi.Input[str] user_id: The unique organization user ID
        """
        if accepted is not None:
            warnings.warn("""This field is deprecated and will be removed in the next major release. """, DeprecationWarning)
            pulumi.log.warn("""accepted is deprecated: This field is deprecated and will be removed in the next major release. """)
        if accepted is not None:
            pulumi.set(__self__, "accepted", accepted)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if invited_by is not None:
            warnings.warn("""This field is deprecated and will be removed in the next major release. """, DeprecationWarning)
            pulumi.log.warn("""invited_by is deprecated: This field is deprecated and will be removed in the next major release. """)
        if invited_by is not None:
            pulumi.set(__self__, "invited_by", invited_by)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if user_email is not None:
            pulumi.set(__self__, "user_email", user_email)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter
    @_utilities.deprecated("""This field is deprecated and will be removed in the next major release. """)
    def accepted(self) -> Optional[pulumi.Input[bool]]:
        """
        This is a boolean flag that determines whether an invitation was accepted or not by the user. `false` value means that the invitation was sent to the user but not yet accepted. `true` means that the user accepted the invitation and now a member of an organization.
        """
        return pulumi.get(self, "accepted")

    @accepted.setter
    def accepted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "accepted", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time of creation
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="invitedBy")
    @_utilities.deprecated("""This field is deprecated and will be removed in the next major release. """)
    def invited_by(self) -> Optional[pulumi.Input[str]]:
        """
        The email address of the user who sent an invitation to the user.
        """
        return pulumi.get(self, "invited_by")

    @invited_by.setter
    def invited_by(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "invited_by", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique organization ID. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter(name="userEmail")
    def user_email(self) -> Optional[pulumi.Input[str]]:
        """
        This is a user email address that first will be invited, and after accepting an invitation, they become a member of the organization. Should be lowercase. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "user_email")

    @user_email.setter
    def user_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_email", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique organization user ID
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_id", value)


class OrganizationUser(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 user_email: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a OrganizationUser resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] organization_id: The unique organization ID. Changing this property forces recreation of the resource.
        :param pulumi.Input[str] user_email: This is a user email address that first will be invited, and after accepting an invitation, they become a member of the organization. Should be lowercase. Changing this property forces recreation of the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OrganizationUserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a OrganizationUser resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param OrganizationUserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationUserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 user_email: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationUserArgs.__new__(OrganizationUserArgs)

            if organization_id is None and not opts.urn:
                raise TypeError("Missing required property 'organization_id'")
            __props__.__dict__["organization_id"] = organization_id
            if user_email is None and not opts.urn:
                raise TypeError("Missing required property 'user_email'")
            __props__.__dict__["user_email"] = user_email
            __props__.__dict__["accepted"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["invited_by"] = None
            __props__.__dict__["user_id"] = None
        super(OrganizationUser, __self__).__init__(
            'aiven:index/organizationUser:OrganizationUser',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accepted: Optional[pulumi.Input[bool]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            invited_by: Optional[pulumi.Input[str]] = None,
            organization_id: Optional[pulumi.Input[str]] = None,
            user_email: Optional[pulumi.Input[str]] = None,
            user_id: Optional[pulumi.Input[str]] = None) -> 'OrganizationUser':
        """
        Get an existing OrganizationUser resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] accepted: This is a boolean flag that determines whether an invitation was accepted or not by the user. `false` value means that the invitation was sent to the user but not yet accepted. `true` means that the user accepted the invitation and now a member of an organization.
        :param pulumi.Input[str] create_time: Time of creation
        :param pulumi.Input[str] invited_by: The email address of the user who sent an invitation to the user.
        :param pulumi.Input[str] organization_id: The unique organization ID. Changing this property forces recreation of the resource.
        :param pulumi.Input[str] user_email: This is a user email address that first will be invited, and after accepting an invitation, they become a member of the organization. Should be lowercase. Changing this property forces recreation of the resource.
        :param pulumi.Input[str] user_id: The unique organization user ID
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrganizationUserState.__new__(_OrganizationUserState)

        __props__.__dict__["accepted"] = accepted
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["invited_by"] = invited_by
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["user_email"] = user_email
        __props__.__dict__["user_id"] = user_id
        return OrganizationUser(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    @_utilities.deprecated("""This field is deprecated and will be removed in the next major release. """)
    def accepted(self) -> pulumi.Output[bool]:
        """
        This is a boolean flag that determines whether an invitation was accepted or not by the user. `false` value means that the invitation was sent to the user but not yet accepted. `true` means that the user accepted the invitation and now a member of an organization.
        """
        return pulumi.get(self, "accepted")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Time of creation
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="invitedBy")
    @_utilities.deprecated("""This field is deprecated and will be removed in the next major release. """)
    def invited_by(self) -> pulumi.Output[str]:
        """
        The email address of the user who sent an invitation to the user.
        """
        return pulumi.get(self, "invited_by")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[str]:
        """
        The unique organization ID. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="userEmail")
    def user_email(self) -> pulumi.Output[str]:
        """
        This is a user email address that first will be invited, and after accepting an invitation, they become a member of the organization. Should be lowercase. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "user_email")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[str]:
        """
        The unique organization user ID
        """
        return pulumi.get(self, "user_id")

