# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceIntegrationEndpointArgs', 'ServiceIntegrationEndpoint']

@pulumi.input_type
class ServiceIntegrationEndpointArgs:
    def __init__(__self__, *,
                 endpoint_name: pulumi.Input[str],
                 endpoint_type: pulumi.Input[str],
                 project: pulumi.Input[str],
                 autoscaler_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointAutoscalerUserConfigArgs']] = None,
                 datadog_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointDatadogUserConfigArgs']] = None,
                 external_aws_cloudwatch_logs_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfigArgs']] = None,
                 external_aws_cloudwatch_metrics_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfigArgs']] = None,
                 external_aws_s3_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointExternalAwsS3UserConfigArgs']] = None,
                 external_clickhouse_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointExternalClickhouseUserConfigArgs']] = None,
                 external_elasticsearch_logs_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointExternalElasticsearchLogsUserConfigArgs']] = None,
                 external_google_cloud_bigquery: Optional[pulumi.Input['ServiceIntegrationEndpointExternalGoogleCloudBigqueryArgs']] = None,
                 external_google_cloud_logging_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfigArgs']] = None,
                 external_kafka_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointExternalKafkaUserConfigArgs']] = None,
                 external_mysql_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointExternalMysqlUserConfigArgs']] = None,
                 external_opensearch_logs_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointExternalOpensearchLogsUserConfigArgs']] = None,
                 external_postgresql: Optional[pulumi.Input['ServiceIntegrationEndpointExternalPostgresqlArgs']] = None,
                 external_prometheus_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointExternalPrometheusUserConfigArgs']] = None,
                 external_schema_registry_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgs']] = None,
                 jolokia_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointJolokiaUserConfigArgs']] = None,
                 prometheus_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointPrometheusUserConfigArgs']] = None,
                 rsyslog_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointRsyslogUserConfigArgs']] = None):
        """
        The set of arguments for constructing a ServiceIntegrationEndpoint resource.
        :param pulumi.Input[str] endpoint_name: Name of the service integration endpoint.
        :param pulumi.Input[str] endpoint_type: The type of service integration endpoint. The possible values are `autoscaler`, `datadog`, `external_aws_cloudwatch_logs`, `external_aws_cloudwatch_metrics`, `external_aws_s3`, `external_clickhouse`, `external_elasticsearch_logs`, `external_google_cloud_bigquery`, `external_google_cloud_logging`, `external_kafka`, `external_mysql`, `external_opensearch_logs`, `external_postgresql`, `external_prometheus`, `external_redis`, `external_schema_registry`, `external_sumologic_logs`, `jolokia`, `prometheus` and `rsyslog`.
        :param pulumi.Input[str] project: Project the service integration endpoint is in.
        :param pulumi.Input['ServiceIntegrationEndpointAutoscalerUserConfigArgs'] autoscaler_user_config: Autoscaler user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationEndpointDatadogUserConfigArgs'] datadog_user_config: Datadog user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfigArgs'] external_aws_cloudwatch_logs_user_config: ExternalAwsCloudwatchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfigArgs'] external_aws_cloudwatch_metrics_user_config: ExternalAwsCloudwatchMetrics user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationEndpointExternalAwsS3UserConfigArgs'] external_aws_s3_user_config: ExternalAwsS3 user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationEndpointExternalClickhouseUserConfigArgs'] external_clickhouse_user_config: ExternalClickhouse user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationEndpointExternalElasticsearchLogsUserConfigArgs'] external_elasticsearch_logs_user_config: ExternalElasticsearchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationEndpointExternalGoogleCloudBigqueryArgs'] external_google_cloud_bigquery: ExternalGoogleCloudBigquery user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfigArgs'] external_google_cloud_logging_user_config: ExternalGoogleCloudLogging user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationEndpointExternalKafkaUserConfigArgs'] external_kafka_user_config: ExternalKafka user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationEndpointExternalMysqlUserConfigArgs'] external_mysql_user_config: ExternalMysql user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationEndpointExternalOpensearchLogsUserConfigArgs'] external_opensearch_logs_user_config: ExternalOpensearchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationEndpointExternalPostgresqlArgs'] external_postgresql: ExternalPostgresql user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationEndpointExternalPrometheusUserConfigArgs'] external_prometheus_user_config: ExternalPrometheus user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgs'] external_schema_registry_user_config: ExternalSchemaRegistry user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationEndpointJolokiaUserConfigArgs'] jolokia_user_config: Jolokia user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationEndpointPrometheusUserConfigArgs'] prometheus_user_config: Prometheus user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationEndpointRsyslogUserConfigArgs'] rsyslog_user_config: Rsyslog user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        pulumi.set(__self__, "endpoint_name", endpoint_name)
        pulumi.set(__self__, "endpoint_type", endpoint_type)
        pulumi.set(__self__, "project", project)
        if autoscaler_user_config is not None:
            pulumi.set(__self__, "autoscaler_user_config", autoscaler_user_config)
        if datadog_user_config is not None:
            pulumi.set(__self__, "datadog_user_config", datadog_user_config)
        if external_aws_cloudwatch_logs_user_config is not None:
            pulumi.set(__self__, "external_aws_cloudwatch_logs_user_config", external_aws_cloudwatch_logs_user_config)
        if external_aws_cloudwatch_metrics_user_config is not None:
            pulumi.set(__self__, "external_aws_cloudwatch_metrics_user_config", external_aws_cloudwatch_metrics_user_config)
        if external_aws_s3_user_config is not None:
            pulumi.set(__self__, "external_aws_s3_user_config", external_aws_s3_user_config)
        if external_clickhouse_user_config is not None:
            pulumi.set(__self__, "external_clickhouse_user_config", external_clickhouse_user_config)
        if external_elasticsearch_logs_user_config is not None:
            pulumi.set(__self__, "external_elasticsearch_logs_user_config", external_elasticsearch_logs_user_config)
        if external_google_cloud_bigquery is not None:
            pulumi.set(__self__, "external_google_cloud_bigquery", external_google_cloud_bigquery)
        if external_google_cloud_logging_user_config is not None:
            pulumi.set(__self__, "external_google_cloud_logging_user_config", external_google_cloud_logging_user_config)
        if external_kafka_user_config is not None:
            pulumi.set(__self__, "external_kafka_user_config", external_kafka_user_config)
        if external_mysql_user_config is not None:
            pulumi.set(__self__, "external_mysql_user_config", external_mysql_user_config)
        if external_opensearch_logs_user_config is not None:
            pulumi.set(__self__, "external_opensearch_logs_user_config", external_opensearch_logs_user_config)
        if external_postgresql is not None:
            pulumi.set(__self__, "external_postgresql", external_postgresql)
        if external_prometheus_user_config is not None:
            pulumi.set(__self__, "external_prometheus_user_config", external_prometheus_user_config)
        if external_schema_registry_user_config is not None:
            pulumi.set(__self__, "external_schema_registry_user_config", external_schema_registry_user_config)
        if jolokia_user_config is not None:
            pulumi.set(__self__, "jolokia_user_config", jolokia_user_config)
        if prometheus_user_config is not None:
            pulumi.set(__self__, "prometheus_user_config", prometheus_user_config)
        if rsyslog_user_config is not None:
            pulumi.set(__self__, "rsyslog_user_config", rsyslog_user_config)

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> pulumi.Input[str]:
        """
        Name of the service integration endpoint.
        """
        return pulumi.get(self, "endpoint_name")

    @endpoint_name.setter
    def endpoint_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint_name", value)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> pulumi.Input[str]:
        """
        The type of service integration endpoint. The possible values are `autoscaler`, `datadog`, `external_aws_cloudwatch_logs`, `external_aws_cloudwatch_metrics`, `external_aws_s3`, `external_clickhouse`, `external_elasticsearch_logs`, `external_google_cloud_bigquery`, `external_google_cloud_logging`, `external_kafka`, `external_mysql`, `external_opensearch_logs`, `external_postgresql`, `external_prometheus`, `external_redis`, `external_schema_registry`, `external_sumologic_logs`, `jolokia`, `prometheus` and `rsyslog`.
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint_type", value)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        Project the service integration endpoint is in.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="autoscalerUserConfig")
    def autoscaler_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointAutoscalerUserConfigArgs']]:
        """
        Autoscaler user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "autoscaler_user_config")

    @autoscaler_user_config.setter
    def autoscaler_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointAutoscalerUserConfigArgs']]):
        pulumi.set(self, "autoscaler_user_config", value)

    @property
    @pulumi.getter(name="datadogUserConfig")
    def datadog_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointDatadogUserConfigArgs']]:
        """
        Datadog user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "datadog_user_config")

    @datadog_user_config.setter
    def datadog_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointDatadogUserConfigArgs']]):
        pulumi.set(self, "datadog_user_config", value)

    @property
    @pulumi.getter(name="externalAwsCloudwatchLogsUserConfig")
    def external_aws_cloudwatch_logs_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfigArgs']]:
        """
        ExternalAwsCloudwatchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_aws_cloudwatch_logs_user_config")

    @external_aws_cloudwatch_logs_user_config.setter
    def external_aws_cloudwatch_logs_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfigArgs']]):
        pulumi.set(self, "external_aws_cloudwatch_logs_user_config", value)

    @property
    @pulumi.getter(name="externalAwsCloudwatchMetricsUserConfig")
    def external_aws_cloudwatch_metrics_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfigArgs']]:
        """
        ExternalAwsCloudwatchMetrics user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_aws_cloudwatch_metrics_user_config")

    @external_aws_cloudwatch_metrics_user_config.setter
    def external_aws_cloudwatch_metrics_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfigArgs']]):
        pulumi.set(self, "external_aws_cloudwatch_metrics_user_config", value)

    @property
    @pulumi.getter(name="externalAwsS3UserConfig")
    def external_aws_s3_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointExternalAwsS3UserConfigArgs']]:
        """
        ExternalAwsS3 user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_aws_s3_user_config")

    @external_aws_s3_user_config.setter
    def external_aws_s3_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointExternalAwsS3UserConfigArgs']]):
        pulumi.set(self, "external_aws_s3_user_config", value)

    @property
    @pulumi.getter(name="externalClickhouseUserConfig")
    def external_clickhouse_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointExternalClickhouseUserConfigArgs']]:
        """
        ExternalClickhouse user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_clickhouse_user_config")

    @external_clickhouse_user_config.setter
    def external_clickhouse_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointExternalClickhouseUserConfigArgs']]):
        pulumi.set(self, "external_clickhouse_user_config", value)

    @property
    @pulumi.getter(name="externalElasticsearchLogsUserConfig")
    def external_elasticsearch_logs_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointExternalElasticsearchLogsUserConfigArgs']]:
        """
        ExternalElasticsearchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_elasticsearch_logs_user_config")

    @external_elasticsearch_logs_user_config.setter
    def external_elasticsearch_logs_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointExternalElasticsearchLogsUserConfigArgs']]):
        pulumi.set(self, "external_elasticsearch_logs_user_config", value)

    @property
    @pulumi.getter(name="externalGoogleCloudBigquery")
    def external_google_cloud_bigquery(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointExternalGoogleCloudBigqueryArgs']]:
        """
        ExternalGoogleCloudBigquery user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_google_cloud_bigquery")

    @external_google_cloud_bigquery.setter
    def external_google_cloud_bigquery(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointExternalGoogleCloudBigqueryArgs']]):
        pulumi.set(self, "external_google_cloud_bigquery", value)

    @property
    @pulumi.getter(name="externalGoogleCloudLoggingUserConfig")
    def external_google_cloud_logging_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfigArgs']]:
        """
        ExternalGoogleCloudLogging user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_google_cloud_logging_user_config")

    @external_google_cloud_logging_user_config.setter
    def external_google_cloud_logging_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfigArgs']]):
        pulumi.set(self, "external_google_cloud_logging_user_config", value)

    @property
    @pulumi.getter(name="externalKafkaUserConfig")
    def external_kafka_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointExternalKafkaUserConfigArgs']]:
        """
        ExternalKafka user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_kafka_user_config")

    @external_kafka_user_config.setter
    def external_kafka_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointExternalKafkaUserConfigArgs']]):
        pulumi.set(self, "external_kafka_user_config", value)

    @property
    @pulumi.getter(name="externalMysqlUserConfig")
    def external_mysql_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointExternalMysqlUserConfigArgs']]:
        """
        ExternalMysql user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_mysql_user_config")

    @external_mysql_user_config.setter
    def external_mysql_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointExternalMysqlUserConfigArgs']]):
        pulumi.set(self, "external_mysql_user_config", value)

    @property
    @pulumi.getter(name="externalOpensearchLogsUserConfig")
    def external_opensearch_logs_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointExternalOpensearchLogsUserConfigArgs']]:
        """
        ExternalOpensearchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_opensearch_logs_user_config")

    @external_opensearch_logs_user_config.setter
    def external_opensearch_logs_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointExternalOpensearchLogsUserConfigArgs']]):
        pulumi.set(self, "external_opensearch_logs_user_config", value)

    @property
    @pulumi.getter(name="externalPostgresql")
    def external_postgresql(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointExternalPostgresqlArgs']]:
        """
        ExternalPostgresql user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_postgresql")

    @external_postgresql.setter
    def external_postgresql(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointExternalPostgresqlArgs']]):
        pulumi.set(self, "external_postgresql", value)

    @property
    @pulumi.getter(name="externalPrometheusUserConfig")
    def external_prometheus_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointExternalPrometheusUserConfigArgs']]:
        """
        ExternalPrometheus user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_prometheus_user_config")

    @external_prometheus_user_config.setter
    def external_prometheus_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointExternalPrometheusUserConfigArgs']]):
        pulumi.set(self, "external_prometheus_user_config", value)

    @property
    @pulumi.getter(name="externalSchemaRegistryUserConfig")
    def external_schema_registry_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgs']]:
        """
        ExternalSchemaRegistry user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_schema_registry_user_config")

    @external_schema_registry_user_config.setter
    def external_schema_registry_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgs']]):
        pulumi.set(self, "external_schema_registry_user_config", value)

    @property
    @pulumi.getter(name="jolokiaUserConfig")
    def jolokia_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointJolokiaUserConfigArgs']]:
        """
        Jolokia user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "jolokia_user_config")

    @jolokia_user_config.setter
    def jolokia_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointJolokiaUserConfigArgs']]):
        pulumi.set(self, "jolokia_user_config", value)

    @property
    @pulumi.getter(name="prometheusUserConfig")
    def prometheus_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointPrometheusUserConfigArgs']]:
        """
        Prometheus user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "prometheus_user_config")

    @prometheus_user_config.setter
    def prometheus_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointPrometheusUserConfigArgs']]):
        pulumi.set(self, "prometheus_user_config", value)

    @property
    @pulumi.getter(name="rsyslogUserConfig")
    def rsyslog_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointRsyslogUserConfigArgs']]:
        """
        Rsyslog user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "rsyslog_user_config")

    @rsyslog_user_config.setter
    def rsyslog_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointRsyslogUserConfigArgs']]):
        pulumi.set(self, "rsyslog_user_config", value)


@pulumi.input_type
class _ServiceIntegrationEndpointState:
    def __init__(__self__, *,
                 autoscaler_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointAutoscalerUserConfigArgs']] = None,
                 datadog_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointDatadogUserConfigArgs']] = None,
                 endpoint_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 endpoint_name: Optional[pulumi.Input[str]] = None,
                 endpoint_type: Optional[pulumi.Input[str]] = None,
                 external_aws_cloudwatch_logs_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfigArgs']] = None,
                 external_aws_cloudwatch_metrics_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfigArgs']] = None,
                 external_aws_s3_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointExternalAwsS3UserConfigArgs']] = None,
                 external_clickhouse_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointExternalClickhouseUserConfigArgs']] = None,
                 external_elasticsearch_logs_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointExternalElasticsearchLogsUserConfigArgs']] = None,
                 external_google_cloud_bigquery: Optional[pulumi.Input['ServiceIntegrationEndpointExternalGoogleCloudBigqueryArgs']] = None,
                 external_google_cloud_logging_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfigArgs']] = None,
                 external_kafka_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointExternalKafkaUserConfigArgs']] = None,
                 external_mysql_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointExternalMysqlUserConfigArgs']] = None,
                 external_opensearch_logs_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointExternalOpensearchLogsUserConfigArgs']] = None,
                 external_postgresql: Optional[pulumi.Input['ServiceIntegrationEndpointExternalPostgresqlArgs']] = None,
                 external_prometheus_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointExternalPrometheusUserConfigArgs']] = None,
                 external_schema_registry_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgs']] = None,
                 jolokia_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointJolokiaUserConfigArgs']] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 prometheus_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointPrometheusUserConfigArgs']] = None,
                 rsyslog_user_config: Optional[pulumi.Input['ServiceIntegrationEndpointRsyslogUserConfigArgs']] = None):
        """
        Input properties used for looking up and filtering ServiceIntegrationEndpoint resources.
        :param pulumi.Input['ServiceIntegrationEndpointAutoscalerUserConfigArgs'] autoscaler_user_config: Autoscaler user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationEndpointDatadogUserConfigArgs'] datadog_user_config: Datadog user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] endpoint_config: Backend configuration for the endpoint.
        :param pulumi.Input[str] endpoint_name: Name of the service integration endpoint.
        :param pulumi.Input[str] endpoint_type: The type of service integration endpoint. The possible values are `autoscaler`, `datadog`, `external_aws_cloudwatch_logs`, `external_aws_cloudwatch_metrics`, `external_aws_s3`, `external_clickhouse`, `external_elasticsearch_logs`, `external_google_cloud_bigquery`, `external_google_cloud_logging`, `external_kafka`, `external_mysql`, `external_opensearch_logs`, `external_postgresql`, `external_prometheus`, `external_redis`, `external_schema_registry`, `external_sumologic_logs`, `jolokia`, `prometheus` and `rsyslog`.
        :param pulumi.Input['ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfigArgs'] external_aws_cloudwatch_logs_user_config: ExternalAwsCloudwatchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfigArgs'] external_aws_cloudwatch_metrics_user_config: ExternalAwsCloudwatchMetrics user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationEndpointExternalAwsS3UserConfigArgs'] external_aws_s3_user_config: ExternalAwsS3 user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationEndpointExternalClickhouseUserConfigArgs'] external_clickhouse_user_config: ExternalClickhouse user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationEndpointExternalElasticsearchLogsUserConfigArgs'] external_elasticsearch_logs_user_config: ExternalElasticsearchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationEndpointExternalGoogleCloudBigqueryArgs'] external_google_cloud_bigquery: ExternalGoogleCloudBigquery user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfigArgs'] external_google_cloud_logging_user_config: ExternalGoogleCloudLogging user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationEndpointExternalKafkaUserConfigArgs'] external_kafka_user_config: ExternalKafka user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationEndpointExternalMysqlUserConfigArgs'] external_mysql_user_config: ExternalMysql user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationEndpointExternalOpensearchLogsUserConfigArgs'] external_opensearch_logs_user_config: ExternalOpensearchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationEndpointExternalPostgresqlArgs'] external_postgresql: ExternalPostgresql user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationEndpointExternalPrometheusUserConfigArgs'] external_prometheus_user_config: ExternalPrometheus user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgs'] external_schema_registry_user_config: ExternalSchemaRegistry user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationEndpointJolokiaUserConfigArgs'] jolokia_user_config: Jolokia user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[str] project: Project the service integration endpoint is in.
        :param pulumi.Input['ServiceIntegrationEndpointPrometheusUserConfigArgs'] prometheus_user_config: Prometheus user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationEndpointRsyslogUserConfigArgs'] rsyslog_user_config: Rsyslog user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        if autoscaler_user_config is not None:
            pulumi.set(__self__, "autoscaler_user_config", autoscaler_user_config)
        if datadog_user_config is not None:
            pulumi.set(__self__, "datadog_user_config", datadog_user_config)
        if endpoint_config is not None:
            pulumi.set(__self__, "endpoint_config", endpoint_config)
        if endpoint_name is not None:
            pulumi.set(__self__, "endpoint_name", endpoint_name)
        if endpoint_type is not None:
            pulumi.set(__self__, "endpoint_type", endpoint_type)
        if external_aws_cloudwatch_logs_user_config is not None:
            pulumi.set(__self__, "external_aws_cloudwatch_logs_user_config", external_aws_cloudwatch_logs_user_config)
        if external_aws_cloudwatch_metrics_user_config is not None:
            pulumi.set(__self__, "external_aws_cloudwatch_metrics_user_config", external_aws_cloudwatch_metrics_user_config)
        if external_aws_s3_user_config is not None:
            pulumi.set(__self__, "external_aws_s3_user_config", external_aws_s3_user_config)
        if external_clickhouse_user_config is not None:
            pulumi.set(__self__, "external_clickhouse_user_config", external_clickhouse_user_config)
        if external_elasticsearch_logs_user_config is not None:
            pulumi.set(__self__, "external_elasticsearch_logs_user_config", external_elasticsearch_logs_user_config)
        if external_google_cloud_bigquery is not None:
            pulumi.set(__self__, "external_google_cloud_bigquery", external_google_cloud_bigquery)
        if external_google_cloud_logging_user_config is not None:
            pulumi.set(__self__, "external_google_cloud_logging_user_config", external_google_cloud_logging_user_config)
        if external_kafka_user_config is not None:
            pulumi.set(__self__, "external_kafka_user_config", external_kafka_user_config)
        if external_mysql_user_config is not None:
            pulumi.set(__self__, "external_mysql_user_config", external_mysql_user_config)
        if external_opensearch_logs_user_config is not None:
            pulumi.set(__self__, "external_opensearch_logs_user_config", external_opensearch_logs_user_config)
        if external_postgresql is not None:
            pulumi.set(__self__, "external_postgresql", external_postgresql)
        if external_prometheus_user_config is not None:
            pulumi.set(__self__, "external_prometheus_user_config", external_prometheus_user_config)
        if external_schema_registry_user_config is not None:
            pulumi.set(__self__, "external_schema_registry_user_config", external_schema_registry_user_config)
        if jolokia_user_config is not None:
            pulumi.set(__self__, "jolokia_user_config", jolokia_user_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if prometheus_user_config is not None:
            pulumi.set(__self__, "prometheus_user_config", prometheus_user_config)
        if rsyslog_user_config is not None:
            pulumi.set(__self__, "rsyslog_user_config", rsyslog_user_config)

    @property
    @pulumi.getter(name="autoscalerUserConfig")
    def autoscaler_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointAutoscalerUserConfigArgs']]:
        """
        Autoscaler user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "autoscaler_user_config")

    @autoscaler_user_config.setter
    def autoscaler_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointAutoscalerUserConfigArgs']]):
        pulumi.set(self, "autoscaler_user_config", value)

    @property
    @pulumi.getter(name="datadogUserConfig")
    def datadog_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointDatadogUserConfigArgs']]:
        """
        Datadog user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "datadog_user_config")

    @datadog_user_config.setter
    def datadog_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointDatadogUserConfigArgs']]):
        pulumi.set(self, "datadog_user_config", value)

    @property
    @pulumi.getter(name="endpointConfig")
    def endpoint_config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Backend configuration for the endpoint.
        """
        return pulumi.get(self, "endpoint_config")

    @endpoint_config.setter
    def endpoint_config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "endpoint_config", value)

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the service integration endpoint.
        """
        return pulumi.get(self, "endpoint_name")

    @endpoint_name.setter
    def endpoint_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_name", value)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of service integration endpoint. The possible values are `autoscaler`, `datadog`, `external_aws_cloudwatch_logs`, `external_aws_cloudwatch_metrics`, `external_aws_s3`, `external_clickhouse`, `external_elasticsearch_logs`, `external_google_cloud_bigquery`, `external_google_cloud_logging`, `external_kafka`, `external_mysql`, `external_opensearch_logs`, `external_postgresql`, `external_prometheus`, `external_redis`, `external_schema_registry`, `external_sumologic_logs`, `jolokia`, `prometheus` and `rsyslog`.
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_type", value)

    @property
    @pulumi.getter(name="externalAwsCloudwatchLogsUserConfig")
    def external_aws_cloudwatch_logs_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfigArgs']]:
        """
        ExternalAwsCloudwatchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_aws_cloudwatch_logs_user_config")

    @external_aws_cloudwatch_logs_user_config.setter
    def external_aws_cloudwatch_logs_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfigArgs']]):
        pulumi.set(self, "external_aws_cloudwatch_logs_user_config", value)

    @property
    @pulumi.getter(name="externalAwsCloudwatchMetricsUserConfig")
    def external_aws_cloudwatch_metrics_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfigArgs']]:
        """
        ExternalAwsCloudwatchMetrics user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_aws_cloudwatch_metrics_user_config")

    @external_aws_cloudwatch_metrics_user_config.setter
    def external_aws_cloudwatch_metrics_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfigArgs']]):
        pulumi.set(self, "external_aws_cloudwatch_metrics_user_config", value)

    @property
    @pulumi.getter(name="externalAwsS3UserConfig")
    def external_aws_s3_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointExternalAwsS3UserConfigArgs']]:
        """
        ExternalAwsS3 user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_aws_s3_user_config")

    @external_aws_s3_user_config.setter
    def external_aws_s3_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointExternalAwsS3UserConfigArgs']]):
        pulumi.set(self, "external_aws_s3_user_config", value)

    @property
    @pulumi.getter(name="externalClickhouseUserConfig")
    def external_clickhouse_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointExternalClickhouseUserConfigArgs']]:
        """
        ExternalClickhouse user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_clickhouse_user_config")

    @external_clickhouse_user_config.setter
    def external_clickhouse_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointExternalClickhouseUserConfigArgs']]):
        pulumi.set(self, "external_clickhouse_user_config", value)

    @property
    @pulumi.getter(name="externalElasticsearchLogsUserConfig")
    def external_elasticsearch_logs_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointExternalElasticsearchLogsUserConfigArgs']]:
        """
        ExternalElasticsearchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_elasticsearch_logs_user_config")

    @external_elasticsearch_logs_user_config.setter
    def external_elasticsearch_logs_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointExternalElasticsearchLogsUserConfigArgs']]):
        pulumi.set(self, "external_elasticsearch_logs_user_config", value)

    @property
    @pulumi.getter(name="externalGoogleCloudBigquery")
    def external_google_cloud_bigquery(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointExternalGoogleCloudBigqueryArgs']]:
        """
        ExternalGoogleCloudBigquery user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_google_cloud_bigquery")

    @external_google_cloud_bigquery.setter
    def external_google_cloud_bigquery(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointExternalGoogleCloudBigqueryArgs']]):
        pulumi.set(self, "external_google_cloud_bigquery", value)

    @property
    @pulumi.getter(name="externalGoogleCloudLoggingUserConfig")
    def external_google_cloud_logging_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfigArgs']]:
        """
        ExternalGoogleCloudLogging user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_google_cloud_logging_user_config")

    @external_google_cloud_logging_user_config.setter
    def external_google_cloud_logging_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfigArgs']]):
        pulumi.set(self, "external_google_cloud_logging_user_config", value)

    @property
    @pulumi.getter(name="externalKafkaUserConfig")
    def external_kafka_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointExternalKafkaUserConfigArgs']]:
        """
        ExternalKafka user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_kafka_user_config")

    @external_kafka_user_config.setter
    def external_kafka_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointExternalKafkaUserConfigArgs']]):
        pulumi.set(self, "external_kafka_user_config", value)

    @property
    @pulumi.getter(name="externalMysqlUserConfig")
    def external_mysql_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointExternalMysqlUserConfigArgs']]:
        """
        ExternalMysql user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_mysql_user_config")

    @external_mysql_user_config.setter
    def external_mysql_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointExternalMysqlUserConfigArgs']]):
        pulumi.set(self, "external_mysql_user_config", value)

    @property
    @pulumi.getter(name="externalOpensearchLogsUserConfig")
    def external_opensearch_logs_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointExternalOpensearchLogsUserConfigArgs']]:
        """
        ExternalOpensearchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_opensearch_logs_user_config")

    @external_opensearch_logs_user_config.setter
    def external_opensearch_logs_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointExternalOpensearchLogsUserConfigArgs']]):
        pulumi.set(self, "external_opensearch_logs_user_config", value)

    @property
    @pulumi.getter(name="externalPostgresql")
    def external_postgresql(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointExternalPostgresqlArgs']]:
        """
        ExternalPostgresql user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_postgresql")

    @external_postgresql.setter
    def external_postgresql(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointExternalPostgresqlArgs']]):
        pulumi.set(self, "external_postgresql", value)

    @property
    @pulumi.getter(name="externalPrometheusUserConfig")
    def external_prometheus_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointExternalPrometheusUserConfigArgs']]:
        """
        ExternalPrometheus user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_prometheus_user_config")

    @external_prometheus_user_config.setter
    def external_prometheus_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointExternalPrometheusUserConfigArgs']]):
        pulumi.set(self, "external_prometheus_user_config", value)

    @property
    @pulumi.getter(name="externalSchemaRegistryUserConfig")
    def external_schema_registry_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgs']]:
        """
        ExternalSchemaRegistry user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_schema_registry_user_config")

    @external_schema_registry_user_config.setter
    def external_schema_registry_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgs']]):
        pulumi.set(self, "external_schema_registry_user_config", value)

    @property
    @pulumi.getter(name="jolokiaUserConfig")
    def jolokia_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointJolokiaUserConfigArgs']]:
        """
        Jolokia user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "jolokia_user_config")

    @jolokia_user_config.setter
    def jolokia_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointJolokiaUserConfigArgs']]):
        pulumi.set(self, "jolokia_user_config", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        Project the service integration endpoint is in.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="prometheusUserConfig")
    def prometheus_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointPrometheusUserConfigArgs']]:
        """
        Prometheus user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "prometheus_user_config")

    @prometheus_user_config.setter
    def prometheus_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointPrometheusUserConfigArgs']]):
        pulumi.set(self, "prometheus_user_config", value)

    @property
    @pulumi.getter(name="rsyslogUserConfig")
    def rsyslog_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationEndpointRsyslogUserConfigArgs']]:
        """
        Rsyslog user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "rsyslog_user_config")

    @rsyslog_user_config.setter
    def rsyslog_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationEndpointRsyslogUserConfigArgs']]):
        pulumi.set(self, "rsyslog_user_config", value)


class ServiceIntegrationEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autoscaler_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointAutoscalerUserConfigArgs', 'ServiceIntegrationEndpointAutoscalerUserConfigArgsDict']]] = None,
                 datadog_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointDatadogUserConfigArgs', 'ServiceIntegrationEndpointDatadogUserConfigArgsDict']]] = None,
                 endpoint_name: Optional[pulumi.Input[str]] = None,
                 endpoint_type: Optional[pulumi.Input[str]] = None,
                 external_aws_cloudwatch_logs_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfigArgs', 'ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfigArgsDict']]] = None,
                 external_aws_cloudwatch_metrics_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfigArgs', 'ServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfigArgsDict']]] = None,
                 external_aws_s3_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointExternalAwsS3UserConfigArgs', 'ServiceIntegrationEndpointExternalAwsS3UserConfigArgsDict']]] = None,
                 external_clickhouse_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointExternalClickhouseUserConfigArgs', 'ServiceIntegrationEndpointExternalClickhouseUserConfigArgsDict']]] = None,
                 external_elasticsearch_logs_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointExternalElasticsearchLogsUserConfigArgs', 'ServiceIntegrationEndpointExternalElasticsearchLogsUserConfigArgsDict']]] = None,
                 external_google_cloud_bigquery: Optional[pulumi.Input[Union['ServiceIntegrationEndpointExternalGoogleCloudBigqueryArgs', 'ServiceIntegrationEndpointExternalGoogleCloudBigqueryArgsDict']]] = None,
                 external_google_cloud_logging_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfigArgs', 'ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfigArgsDict']]] = None,
                 external_kafka_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointExternalKafkaUserConfigArgs', 'ServiceIntegrationEndpointExternalKafkaUserConfigArgsDict']]] = None,
                 external_mysql_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointExternalMysqlUserConfigArgs', 'ServiceIntegrationEndpointExternalMysqlUserConfigArgsDict']]] = None,
                 external_opensearch_logs_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointExternalOpensearchLogsUserConfigArgs', 'ServiceIntegrationEndpointExternalOpensearchLogsUserConfigArgsDict']]] = None,
                 external_postgresql: Optional[pulumi.Input[Union['ServiceIntegrationEndpointExternalPostgresqlArgs', 'ServiceIntegrationEndpointExternalPostgresqlArgsDict']]] = None,
                 external_prometheus_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointExternalPrometheusUserConfigArgs', 'ServiceIntegrationEndpointExternalPrometheusUserConfigArgsDict']]] = None,
                 external_schema_registry_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgs', 'ServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgsDict']]] = None,
                 jolokia_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointJolokiaUserConfigArgs', 'ServiceIntegrationEndpointJolokiaUserConfigArgsDict']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 prometheus_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointPrometheusUserConfigArgs', 'ServiceIntegrationEndpointPrometheusUserConfigArgsDict']]] = None,
                 rsyslog_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointRsyslogUserConfigArgs', 'ServiceIntegrationEndpointRsyslogUserConfigArgsDict']]] = None,
                 __props__=None):
        """
        Creates and manages an integration endpoint.

        Integration endpoints let you send data like metrics and logs from Aiven services to external systems. The `autoscaler` endpoint lets you automatically scale the disk space on your services.

        After creating an endpoint, use the service integration resource to connect it to a service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        # Datadog endpoint
        example_endpoint = aiven.ServiceIntegrationEndpoint("example_endpoint",
            project=example_project["project"],
            endpoint_name="Datadog endpoint",
            endpoint_type="datadog")
        # Disk autoscaler endpoint
        autoscaler_endpoint = aiven.ServiceIntegrationEndpoint("autoscaler_endpoint",
            project=example_project["project"],
            endpoint_name="disk-autoscaler-200GiB",
            endpoint_type="autoscaler",
            autoscaler_user_config={
                "autoscalings": [{
                    "cap_gb": 200,
                    "type": "autoscale_disk",
                }],
            })
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/serviceIntegrationEndpoint:ServiceIntegrationEndpoint example_endpoint PROJECT/ID
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ServiceIntegrationEndpointAutoscalerUserConfigArgs', 'ServiceIntegrationEndpointAutoscalerUserConfigArgsDict']] autoscaler_user_config: Autoscaler user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationEndpointDatadogUserConfigArgs', 'ServiceIntegrationEndpointDatadogUserConfigArgsDict']] datadog_user_config: Datadog user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[str] endpoint_name: Name of the service integration endpoint.
        :param pulumi.Input[str] endpoint_type: The type of service integration endpoint. The possible values are `autoscaler`, `datadog`, `external_aws_cloudwatch_logs`, `external_aws_cloudwatch_metrics`, `external_aws_s3`, `external_clickhouse`, `external_elasticsearch_logs`, `external_google_cloud_bigquery`, `external_google_cloud_logging`, `external_kafka`, `external_mysql`, `external_opensearch_logs`, `external_postgresql`, `external_prometheus`, `external_redis`, `external_schema_registry`, `external_sumologic_logs`, `jolokia`, `prometheus` and `rsyslog`.
        :param pulumi.Input[Union['ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfigArgs', 'ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfigArgsDict']] external_aws_cloudwatch_logs_user_config: ExternalAwsCloudwatchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfigArgs', 'ServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfigArgsDict']] external_aws_cloudwatch_metrics_user_config: ExternalAwsCloudwatchMetrics user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationEndpointExternalAwsS3UserConfigArgs', 'ServiceIntegrationEndpointExternalAwsS3UserConfigArgsDict']] external_aws_s3_user_config: ExternalAwsS3 user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationEndpointExternalClickhouseUserConfigArgs', 'ServiceIntegrationEndpointExternalClickhouseUserConfigArgsDict']] external_clickhouse_user_config: ExternalClickhouse user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationEndpointExternalElasticsearchLogsUserConfigArgs', 'ServiceIntegrationEndpointExternalElasticsearchLogsUserConfigArgsDict']] external_elasticsearch_logs_user_config: ExternalElasticsearchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationEndpointExternalGoogleCloudBigqueryArgs', 'ServiceIntegrationEndpointExternalGoogleCloudBigqueryArgsDict']] external_google_cloud_bigquery: ExternalGoogleCloudBigquery user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfigArgs', 'ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfigArgsDict']] external_google_cloud_logging_user_config: ExternalGoogleCloudLogging user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationEndpointExternalKafkaUserConfigArgs', 'ServiceIntegrationEndpointExternalKafkaUserConfigArgsDict']] external_kafka_user_config: ExternalKafka user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationEndpointExternalMysqlUserConfigArgs', 'ServiceIntegrationEndpointExternalMysqlUserConfigArgsDict']] external_mysql_user_config: ExternalMysql user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationEndpointExternalOpensearchLogsUserConfigArgs', 'ServiceIntegrationEndpointExternalOpensearchLogsUserConfigArgsDict']] external_opensearch_logs_user_config: ExternalOpensearchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationEndpointExternalPostgresqlArgs', 'ServiceIntegrationEndpointExternalPostgresqlArgsDict']] external_postgresql: ExternalPostgresql user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationEndpointExternalPrometheusUserConfigArgs', 'ServiceIntegrationEndpointExternalPrometheusUserConfigArgsDict']] external_prometheus_user_config: ExternalPrometheus user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgs', 'ServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgsDict']] external_schema_registry_user_config: ExternalSchemaRegistry user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationEndpointJolokiaUserConfigArgs', 'ServiceIntegrationEndpointJolokiaUserConfigArgsDict']] jolokia_user_config: Jolokia user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[str] project: Project the service integration endpoint is in.
        :param pulumi.Input[Union['ServiceIntegrationEndpointPrometheusUserConfigArgs', 'ServiceIntegrationEndpointPrometheusUserConfigArgsDict']] prometheus_user_config: Prometheus user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationEndpointRsyslogUserConfigArgs', 'ServiceIntegrationEndpointRsyslogUserConfigArgsDict']] rsyslog_user_config: Rsyslog user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceIntegrationEndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages an integration endpoint.

        Integration endpoints let you send data like metrics and logs from Aiven services to external systems. The `autoscaler` endpoint lets you automatically scale the disk space on your services.

        After creating an endpoint, use the service integration resource to connect it to a service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        # Datadog endpoint
        example_endpoint = aiven.ServiceIntegrationEndpoint("example_endpoint",
            project=example_project["project"],
            endpoint_name="Datadog endpoint",
            endpoint_type="datadog")
        # Disk autoscaler endpoint
        autoscaler_endpoint = aiven.ServiceIntegrationEndpoint("autoscaler_endpoint",
            project=example_project["project"],
            endpoint_name="disk-autoscaler-200GiB",
            endpoint_type="autoscaler",
            autoscaler_user_config={
                "autoscalings": [{
                    "cap_gb": 200,
                    "type": "autoscale_disk",
                }],
            })
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/serviceIntegrationEndpoint:ServiceIntegrationEndpoint example_endpoint PROJECT/ID
        ```

        :param str resource_name: The name of the resource.
        :param ServiceIntegrationEndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceIntegrationEndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autoscaler_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointAutoscalerUserConfigArgs', 'ServiceIntegrationEndpointAutoscalerUserConfigArgsDict']]] = None,
                 datadog_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointDatadogUserConfigArgs', 'ServiceIntegrationEndpointDatadogUserConfigArgsDict']]] = None,
                 endpoint_name: Optional[pulumi.Input[str]] = None,
                 endpoint_type: Optional[pulumi.Input[str]] = None,
                 external_aws_cloudwatch_logs_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfigArgs', 'ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfigArgsDict']]] = None,
                 external_aws_cloudwatch_metrics_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfigArgs', 'ServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfigArgsDict']]] = None,
                 external_aws_s3_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointExternalAwsS3UserConfigArgs', 'ServiceIntegrationEndpointExternalAwsS3UserConfigArgsDict']]] = None,
                 external_clickhouse_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointExternalClickhouseUserConfigArgs', 'ServiceIntegrationEndpointExternalClickhouseUserConfigArgsDict']]] = None,
                 external_elasticsearch_logs_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointExternalElasticsearchLogsUserConfigArgs', 'ServiceIntegrationEndpointExternalElasticsearchLogsUserConfigArgsDict']]] = None,
                 external_google_cloud_bigquery: Optional[pulumi.Input[Union['ServiceIntegrationEndpointExternalGoogleCloudBigqueryArgs', 'ServiceIntegrationEndpointExternalGoogleCloudBigqueryArgsDict']]] = None,
                 external_google_cloud_logging_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfigArgs', 'ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfigArgsDict']]] = None,
                 external_kafka_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointExternalKafkaUserConfigArgs', 'ServiceIntegrationEndpointExternalKafkaUserConfigArgsDict']]] = None,
                 external_mysql_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointExternalMysqlUserConfigArgs', 'ServiceIntegrationEndpointExternalMysqlUserConfigArgsDict']]] = None,
                 external_opensearch_logs_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointExternalOpensearchLogsUserConfigArgs', 'ServiceIntegrationEndpointExternalOpensearchLogsUserConfigArgsDict']]] = None,
                 external_postgresql: Optional[pulumi.Input[Union['ServiceIntegrationEndpointExternalPostgresqlArgs', 'ServiceIntegrationEndpointExternalPostgresqlArgsDict']]] = None,
                 external_prometheus_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointExternalPrometheusUserConfigArgs', 'ServiceIntegrationEndpointExternalPrometheusUserConfigArgsDict']]] = None,
                 external_schema_registry_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgs', 'ServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgsDict']]] = None,
                 jolokia_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointJolokiaUserConfigArgs', 'ServiceIntegrationEndpointJolokiaUserConfigArgsDict']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 prometheus_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointPrometheusUserConfigArgs', 'ServiceIntegrationEndpointPrometheusUserConfigArgsDict']]] = None,
                 rsyslog_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointRsyslogUserConfigArgs', 'ServiceIntegrationEndpointRsyslogUserConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceIntegrationEndpointArgs.__new__(ServiceIntegrationEndpointArgs)

            __props__.__dict__["autoscaler_user_config"] = autoscaler_user_config
            __props__.__dict__["datadog_user_config"] = datadog_user_config
            if endpoint_name is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint_name'")
            __props__.__dict__["endpoint_name"] = endpoint_name
            if endpoint_type is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint_type'")
            __props__.__dict__["endpoint_type"] = endpoint_type
            __props__.__dict__["external_aws_cloudwatch_logs_user_config"] = external_aws_cloudwatch_logs_user_config
            __props__.__dict__["external_aws_cloudwatch_metrics_user_config"] = external_aws_cloudwatch_metrics_user_config
            __props__.__dict__["external_aws_s3_user_config"] = external_aws_s3_user_config
            __props__.__dict__["external_clickhouse_user_config"] = external_clickhouse_user_config
            __props__.__dict__["external_elasticsearch_logs_user_config"] = external_elasticsearch_logs_user_config
            __props__.__dict__["external_google_cloud_bigquery"] = external_google_cloud_bigquery
            __props__.__dict__["external_google_cloud_logging_user_config"] = external_google_cloud_logging_user_config
            __props__.__dict__["external_kafka_user_config"] = external_kafka_user_config
            __props__.__dict__["external_mysql_user_config"] = external_mysql_user_config
            __props__.__dict__["external_opensearch_logs_user_config"] = external_opensearch_logs_user_config
            __props__.__dict__["external_postgresql"] = external_postgresql
            __props__.__dict__["external_prometheus_user_config"] = external_prometheus_user_config
            __props__.__dict__["external_schema_registry_user_config"] = external_schema_registry_user_config
            __props__.__dict__["jolokia_user_config"] = jolokia_user_config
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["prometheus_user_config"] = prometheus_user_config
            __props__.__dict__["rsyslog_user_config"] = rsyslog_user_config
            __props__.__dict__["endpoint_config"] = None
        super(ServiceIntegrationEndpoint, __self__).__init__(
            'aiven:index/serviceIntegrationEndpoint:ServiceIntegrationEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            autoscaler_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointAutoscalerUserConfigArgs', 'ServiceIntegrationEndpointAutoscalerUserConfigArgsDict']]] = None,
            datadog_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointDatadogUserConfigArgs', 'ServiceIntegrationEndpointDatadogUserConfigArgsDict']]] = None,
            endpoint_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            endpoint_name: Optional[pulumi.Input[str]] = None,
            endpoint_type: Optional[pulumi.Input[str]] = None,
            external_aws_cloudwatch_logs_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfigArgs', 'ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfigArgsDict']]] = None,
            external_aws_cloudwatch_metrics_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfigArgs', 'ServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfigArgsDict']]] = None,
            external_aws_s3_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointExternalAwsS3UserConfigArgs', 'ServiceIntegrationEndpointExternalAwsS3UserConfigArgsDict']]] = None,
            external_clickhouse_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointExternalClickhouseUserConfigArgs', 'ServiceIntegrationEndpointExternalClickhouseUserConfigArgsDict']]] = None,
            external_elasticsearch_logs_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointExternalElasticsearchLogsUserConfigArgs', 'ServiceIntegrationEndpointExternalElasticsearchLogsUserConfigArgsDict']]] = None,
            external_google_cloud_bigquery: Optional[pulumi.Input[Union['ServiceIntegrationEndpointExternalGoogleCloudBigqueryArgs', 'ServiceIntegrationEndpointExternalGoogleCloudBigqueryArgsDict']]] = None,
            external_google_cloud_logging_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfigArgs', 'ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfigArgsDict']]] = None,
            external_kafka_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointExternalKafkaUserConfigArgs', 'ServiceIntegrationEndpointExternalKafkaUserConfigArgsDict']]] = None,
            external_mysql_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointExternalMysqlUserConfigArgs', 'ServiceIntegrationEndpointExternalMysqlUserConfigArgsDict']]] = None,
            external_opensearch_logs_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointExternalOpensearchLogsUserConfigArgs', 'ServiceIntegrationEndpointExternalOpensearchLogsUserConfigArgsDict']]] = None,
            external_postgresql: Optional[pulumi.Input[Union['ServiceIntegrationEndpointExternalPostgresqlArgs', 'ServiceIntegrationEndpointExternalPostgresqlArgsDict']]] = None,
            external_prometheus_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointExternalPrometheusUserConfigArgs', 'ServiceIntegrationEndpointExternalPrometheusUserConfigArgsDict']]] = None,
            external_schema_registry_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgs', 'ServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgsDict']]] = None,
            jolokia_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointJolokiaUserConfigArgs', 'ServiceIntegrationEndpointJolokiaUserConfigArgsDict']]] = None,
            project: Optional[pulumi.Input[str]] = None,
            prometheus_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointPrometheusUserConfigArgs', 'ServiceIntegrationEndpointPrometheusUserConfigArgsDict']]] = None,
            rsyslog_user_config: Optional[pulumi.Input[Union['ServiceIntegrationEndpointRsyslogUserConfigArgs', 'ServiceIntegrationEndpointRsyslogUserConfigArgsDict']]] = None) -> 'ServiceIntegrationEndpoint':
        """
        Get an existing ServiceIntegrationEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ServiceIntegrationEndpointAutoscalerUserConfigArgs', 'ServiceIntegrationEndpointAutoscalerUserConfigArgsDict']] autoscaler_user_config: Autoscaler user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationEndpointDatadogUserConfigArgs', 'ServiceIntegrationEndpointDatadogUserConfigArgsDict']] datadog_user_config: Datadog user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] endpoint_config: Backend configuration for the endpoint.
        :param pulumi.Input[str] endpoint_name: Name of the service integration endpoint.
        :param pulumi.Input[str] endpoint_type: The type of service integration endpoint. The possible values are `autoscaler`, `datadog`, `external_aws_cloudwatch_logs`, `external_aws_cloudwatch_metrics`, `external_aws_s3`, `external_clickhouse`, `external_elasticsearch_logs`, `external_google_cloud_bigquery`, `external_google_cloud_logging`, `external_kafka`, `external_mysql`, `external_opensearch_logs`, `external_postgresql`, `external_prometheus`, `external_redis`, `external_schema_registry`, `external_sumologic_logs`, `jolokia`, `prometheus` and `rsyslog`.
        :param pulumi.Input[Union['ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfigArgs', 'ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfigArgsDict']] external_aws_cloudwatch_logs_user_config: ExternalAwsCloudwatchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfigArgs', 'ServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfigArgsDict']] external_aws_cloudwatch_metrics_user_config: ExternalAwsCloudwatchMetrics user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationEndpointExternalAwsS3UserConfigArgs', 'ServiceIntegrationEndpointExternalAwsS3UserConfigArgsDict']] external_aws_s3_user_config: ExternalAwsS3 user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationEndpointExternalClickhouseUserConfigArgs', 'ServiceIntegrationEndpointExternalClickhouseUserConfigArgsDict']] external_clickhouse_user_config: ExternalClickhouse user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationEndpointExternalElasticsearchLogsUserConfigArgs', 'ServiceIntegrationEndpointExternalElasticsearchLogsUserConfigArgsDict']] external_elasticsearch_logs_user_config: ExternalElasticsearchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationEndpointExternalGoogleCloudBigqueryArgs', 'ServiceIntegrationEndpointExternalGoogleCloudBigqueryArgsDict']] external_google_cloud_bigquery: ExternalGoogleCloudBigquery user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfigArgs', 'ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfigArgsDict']] external_google_cloud_logging_user_config: ExternalGoogleCloudLogging user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationEndpointExternalKafkaUserConfigArgs', 'ServiceIntegrationEndpointExternalKafkaUserConfigArgsDict']] external_kafka_user_config: ExternalKafka user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationEndpointExternalMysqlUserConfigArgs', 'ServiceIntegrationEndpointExternalMysqlUserConfigArgsDict']] external_mysql_user_config: ExternalMysql user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationEndpointExternalOpensearchLogsUserConfigArgs', 'ServiceIntegrationEndpointExternalOpensearchLogsUserConfigArgsDict']] external_opensearch_logs_user_config: ExternalOpensearchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationEndpointExternalPostgresqlArgs', 'ServiceIntegrationEndpointExternalPostgresqlArgsDict']] external_postgresql: ExternalPostgresql user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationEndpointExternalPrometheusUserConfigArgs', 'ServiceIntegrationEndpointExternalPrometheusUserConfigArgsDict']] external_prometheus_user_config: ExternalPrometheus user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgs', 'ServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgsDict']] external_schema_registry_user_config: ExternalSchemaRegistry user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationEndpointJolokiaUserConfigArgs', 'ServiceIntegrationEndpointJolokiaUserConfigArgsDict']] jolokia_user_config: Jolokia user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[str] project: Project the service integration endpoint is in.
        :param pulumi.Input[Union['ServiceIntegrationEndpointPrometheusUserConfigArgs', 'ServiceIntegrationEndpointPrometheusUserConfigArgsDict']] prometheus_user_config: Prometheus user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationEndpointRsyslogUserConfigArgs', 'ServiceIntegrationEndpointRsyslogUserConfigArgsDict']] rsyslog_user_config: Rsyslog user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceIntegrationEndpointState.__new__(_ServiceIntegrationEndpointState)

        __props__.__dict__["autoscaler_user_config"] = autoscaler_user_config
        __props__.__dict__["datadog_user_config"] = datadog_user_config
        __props__.__dict__["endpoint_config"] = endpoint_config
        __props__.__dict__["endpoint_name"] = endpoint_name
        __props__.__dict__["endpoint_type"] = endpoint_type
        __props__.__dict__["external_aws_cloudwatch_logs_user_config"] = external_aws_cloudwatch_logs_user_config
        __props__.__dict__["external_aws_cloudwatch_metrics_user_config"] = external_aws_cloudwatch_metrics_user_config
        __props__.__dict__["external_aws_s3_user_config"] = external_aws_s3_user_config
        __props__.__dict__["external_clickhouse_user_config"] = external_clickhouse_user_config
        __props__.__dict__["external_elasticsearch_logs_user_config"] = external_elasticsearch_logs_user_config
        __props__.__dict__["external_google_cloud_bigquery"] = external_google_cloud_bigquery
        __props__.__dict__["external_google_cloud_logging_user_config"] = external_google_cloud_logging_user_config
        __props__.__dict__["external_kafka_user_config"] = external_kafka_user_config
        __props__.__dict__["external_mysql_user_config"] = external_mysql_user_config
        __props__.__dict__["external_opensearch_logs_user_config"] = external_opensearch_logs_user_config
        __props__.__dict__["external_postgresql"] = external_postgresql
        __props__.__dict__["external_prometheus_user_config"] = external_prometheus_user_config
        __props__.__dict__["external_schema_registry_user_config"] = external_schema_registry_user_config
        __props__.__dict__["jolokia_user_config"] = jolokia_user_config
        __props__.__dict__["project"] = project
        __props__.__dict__["prometheus_user_config"] = prometheus_user_config
        __props__.__dict__["rsyslog_user_config"] = rsyslog_user_config
        return ServiceIntegrationEndpoint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoscalerUserConfig")
    def autoscaler_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationEndpointAutoscalerUserConfig']]:
        """
        Autoscaler user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "autoscaler_user_config")

    @property
    @pulumi.getter(name="datadogUserConfig")
    def datadog_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationEndpointDatadogUserConfig']]:
        """
        Datadog user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "datadog_user_config")

    @property
    @pulumi.getter(name="endpointConfig")
    def endpoint_config(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Backend configuration for the endpoint.
        """
        return pulumi.get(self, "endpoint_config")

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> pulumi.Output[str]:
        """
        Name of the service integration endpoint.
        """
        return pulumi.get(self, "endpoint_name")

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> pulumi.Output[str]:
        """
        The type of service integration endpoint. The possible values are `autoscaler`, `datadog`, `external_aws_cloudwatch_logs`, `external_aws_cloudwatch_metrics`, `external_aws_s3`, `external_clickhouse`, `external_elasticsearch_logs`, `external_google_cloud_bigquery`, `external_google_cloud_logging`, `external_kafka`, `external_mysql`, `external_opensearch_logs`, `external_postgresql`, `external_prometheus`, `external_redis`, `external_schema_registry`, `external_sumologic_logs`, `jolokia`, `prometheus` and `rsyslog`.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="externalAwsCloudwatchLogsUserConfig")
    def external_aws_cloudwatch_logs_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfig']]:
        """
        ExternalAwsCloudwatchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_aws_cloudwatch_logs_user_config")

    @property
    @pulumi.getter(name="externalAwsCloudwatchMetricsUserConfig")
    def external_aws_cloudwatch_metrics_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfig']]:
        """
        ExternalAwsCloudwatchMetrics user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_aws_cloudwatch_metrics_user_config")

    @property
    @pulumi.getter(name="externalAwsS3UserConfig")
    def external_aws_s3_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationEndpointExternalAwsS3UserConfig']]:
        """
        ExternalAwsS3 user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_aws_s3_user_config")

    @property
    @pulumi.getter(name="externalClickhouseUserConfig")
    def external_clickhouse_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationEndpointExternalClickhouseUserConfig']]:
        """
        ExternalClickhouse user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_clickhouse_user_config")

    @property
    @pulumi.getter(name="externalElasticsearchLogsUserConfig")
    def external_elasticsearch_logs_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationEndpointExternalElasticsearchLogsUserConfig']]:
        """
        ExternalElasticsearchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_elasticsearch_logs_user_config")

    @property
    @pulumi.getter(name="externalGoogleCloudBigquery")
    def external_google_cloud_bigquery(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationEndpointExternalGoogleCloudBigquery']]:
        """
        ExternalGoogleCloudBigquery user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_google_cloud_bigquery")

    @property
    @pulumi.getter(name="externalGoogleCloudLoggingUserConfig")
    def external_google_cloud_logging_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfig']]:
        """
        ExternalGoogleCloudLogging user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_google_cloud_logging_user_config")

    @property
    @pulumi.getter(name="externalKafkaUserConfig")
    def external_kafka_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationEndpointExternalKafkaUserConfig']]:
        """
        ExternalKafka user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_kafka_user_config")

    @property
    @pulumi.getter(name="externalMysqlUserConfig")
    def external_mysql_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationEndpointExternalMysqlUserConfig']]:
        """
        ExternalMysql user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_mysql_user_config")

    @property
    @pulumi.getter(name="externalOpensearchLogsUserConfig")
    def external_opensearch_logs_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationEndpointExternalOpensearchLogsUserConfig']]:
        """
        ExternalOpensearchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_opensearch_logs_user_config")

    @property
    @pulumi.getter(name="externalPostgresql")
    def external_postgresql(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationEndpointExternalPostgresql']]:
        """
        ExternalPostgresql user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_postgresql")

    @property
    @pulumi.getter(name="externalPrometheusUserConfig")
    def external_prometheus_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationEndpointExternalPrometheusUserConfig']]:
        """
        ExternalPrometheus user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_prometheus_user_config")

    @property
    @pulumi.getter(name="externalSchemaRegistryUserConfig")
    def external_schema_registry_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationEndpointExternalSchemaRegistryUserConfig']]:
        """
        ExternalSchemaRegistry user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_schema_registry_user_config")

    @property
    @pulumi.getter(name="jolokiaUserConfig")
    def jolokia_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationEndpointJolokiaUserConfig']]:
        """
        Jolokia user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "jolokia_user_config")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        Project the service integration endpoint is in.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="prometheusUserConfig")
    def prometheus_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationEndpointPrometheusUserConfig']]:
        """
        Prometheus user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "prometheus_user_config")

    @property
    @pulumi.getter(name="rsyslogUserConfig")
    def rsyslog_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationEndpointRsyslogUserConfig']]:
        """
        Rsyslog user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "rsyslog_user_config")

