# -*- coding: utf-8 -*-
# Generated by Django 1.11.7 on 2017-12-15 19:05
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0068_suite_version'),
    ]

    operations = [
        migrations.CreateModel(
            name='SuiteMetadata',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('suite', models.CharField(max_length=256)),
                ('kind', models.CharField(choices=[('suite', 'Suite'), ('test', 'Test'), ('metric', 'Metric')], max_length=6)),
                ('name', models.CharField(max_length=256, null=True)),
                ('description', models.TextField(blank=True, null=True)),
                ('instructions_to_reproduce', models.TextField(blank=True, null=True)),
            ],
            options={
                'verbose_name_plural': 'Suite metadata',
            },
        ),
        migrations.AlterUniqueTogether(
            name='suitemetadata',
            unique_together=set([('kind', 'suite', 'name')]),
        ),
        migrations.AddField(
            model_name='metric',
            name='metadata',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.SuiteMetadata'),
        ),
        migrations.AddField(
            model_name='suite',
            name='metadata',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.SuiteMetadata'),
        ),
        migrations.AddField(
            model_name='test',
            name='metadata',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='core.SuiteMetadata'),
        ),
    ]
