# -*- coding: utf-8 -*-
# Generated by Django 1.11.16 on 2018-10-24 19:49
from __future__ import unicode_literals

from django.db import migrations
from simple_history.manager import HistoryManager


def populate_historical_emailtemplate(apps, schema_editor):
    EmailTemplate = apps.get_model('core', 'EmailTemplate')

    # In memory model that stores EmailTemplate's versions
    HistoricalEmailTemplate = apps.get_model('core', 'HistoricalEmailTemplate')

    # Workaround to get a HistoryManager instance
    HistoricalEmailTemplate._history_excluded_fields = []
    history = HistoryManager(HistoricalEmailTemplate)

    history.bulk_history_create(EmailTemplate.objects.all())


def clean_historical_emailtemplate(apps, schema_editor):
    HistoricalEmailTemplate = apps.get_model('core', 'HistoricalEmailTemplate')
    HistoricalEmailTemplate.objects.all().delete()


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0093_historicalemailtemplate'),
    ]

    operations = [
        migrations.RunPython(populate_historical_emailtemplate, clean_historical_emailtemplate),
    ]
