# -*- coding: utf-8 -*-
# Generated by Django 1.11.9 on 2018-11-20 12:37
from __future__ import unicode_literals

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import squad.core.utils


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0103_populate_project_status'),
    ]

    operations = [
        migrations.CreateModel(
            name='DelayedReport',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('output_format', models.CharField(choices=[('text/plain', 'text/plain'), ('text/html', 'text/html')], max_length=32)),
                ('email_recipient', models.EmailField(blank=True, max_length=254, null=True)),
                ('email_recipient_notified', models.BooleanField(default=False)),
                ('callback', models.URLField(blank=True, null=True)),
                ('callback_token', models.CharField(blank=True, max_length=128, null=True)),
                ('callback_notified', models.BooleanField(default=False)),
                ('data_retention_days', models.PositiveSmallIntegerField(default=5, validators=[django.core.validators.MaxValueValidator(30)])),
                ('output_text', models.TextField(blank=True, null=True)),
                ('output_html', models.TextField(blank=True, null=True)),
                ('error_message', models.CharField(blank=True, max_length=1024, null=True, validators=[squad.core.utils.yaml_validator])),
                ('status_code', models.PositiveSmallIntegerField(blank=True, null=True, validators=[django.core.validators.MaxValueValidator(511), django.core.validators.MinValueValidator(100)])),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('baseline', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='delayed_report_baselines', to='core.ProjectStatus')),
                ('build', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='delayed_reports', to='core.Build')),
                ('template', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='core.EmailTemplate')),
            ],
        ),
    ]
