# -*- coding: utf-8 -*-
# Generated by Django 1.11.14 on 2019-01-08 11:50
from __future__ import unicode_literals

from django.db import migrations, models


def set_notification_strategy(apps, schema_editor):
    Project = apps.get_model('core', 'Project')
    for project in Project.objects.all():
        for subscription in project.subscriptions.all():
            subscription.notification_strategy = project.notification_strategy
            subscription.save()


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0106_delayedreport_output_subject'),
    ]

    operations = [
        migrations.AddField(
            model_name='subscription',
            name='notification_strategy',
            field=models.CharField(choices=[('all', 'All builds'), ('change', 'Only on change'), ('regression', 'Only on regression')], default='all', max_length=32),
        ),
        migrations.RunPython(
            set_notification_strategy,
            reverse_code=migrations.RunPython.noop,
        ),
        migrations.RemoveField(
            model_name='project',
            name='notification_strategy',
        ),
    ]
