# -*- coding: utf-8 -*-
# Generated by Django 1.11.20 on 2019-03-18 19:28
from __future__ import unicode_literals

from django.db import migrations


def move_users_to_squad_groups(apps, schema_editor):
    Group = apps.get_model('core', 'Group')
    GroupMember = apps.get_model('core', 'GroupMember')
    for group in Group.objects.all():
        for user_group in group.user_groups.all():
            for user in user_group.user_set.all():
                GroupMember.objects.create(group=group, user=user, access='submitter')


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0109_group_member'),
    ]

    operations = [
        migrations.RunPython(
            move_users_to_squad_groups,
            reverse_code=migrations.RunPython.noop,
        ),
    ]
