# -*- coding: utf-8 -*-
# Generated by Django 2.2.6 on 2020-01-30 19:19
from __future__ import unicode_literals

from django.db import migrations


def update_testrun_has_metrics_entry(apps, schema_editor):
    Status = apps.get_model('core', 'Status')
    target_statuses = Status.objects.filter(has_metrics='f', metrics_summary__gt=0, suite_id=None)
    for status in target_statuses:
        status.has_metrics = True
        status.save()


class Migration(migrations.Migration):

    dependencies = [('core', '0124_set_default_expected_test_runs_to_zero')]

    operations = [
        migrations.RunPython(
            update_testrun_has_metrics_entry,
            reverse_code=migrations.RunPython.noop
        )
    ]
