# Generated by Django 2.2.13 on 2020-09-23 19:54

from django.db import migrations


def migrate_existing_submitters_to_privliged(apps, schema_editor):
    group_memebers = apps.get_model('core', 'GroupMember')
    all_submitters = group_memebers.objects.filter(access='submitter').all()
    for member in all_submitters:
        member.access = 'privileged'
        member.save()


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0135_add_privileged_access_level'),
    ]

    operations = [
        migrations.RunPython(
            migrate_existing_submitters_to_privliged,
            reverse_code=migrations.RunPython.noop
        )
    ]
